/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jmri.Block;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanPropertyDescriptor;
import jmri.SelectionPropertyDescriptor;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.SignalMastManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.swing.JTablePersistenceManager;
import jmri.util.davidflanagan.HardcopyWriter;
import jmri.util.swing.ComboBoxToolTipRenderer;
import jmri.util.swing.StayOpenCheckBoxItem;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanTableDataModel<T extends NamedBean>
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int SYSNAMECOL = 0;
    public static final int USERNAMECOL = 1;
    public static final int VALUECOL = 2;
    public static final int COMMENTCOL = 3;
    public static final int DELETECOL = 4;
    public static final int NUMCOLUMN = 5;
    protected List<String> sysNameList = null;
    private NamedBeanHandleManager nbMan;
    private static final Logger log = LoggerFactory.getLogger(BeanTableDataModel.class);

    public BeanTableDataModel() {
        this.initModel();
    }

    private void initModel() {
        this.nbMan = InstanceManager.getDefault(NamedBeanHandleManager.class);
        this.getManager().addPropertyChangeListener(this);
        this.updateNameList();
    }

    protected int getPropertyColumnCount() {
        return this.getManager().getKnownBeanProperties().size();
    }

    @CheckForNull
    protected NamedBeanPropertyDescriptor<?> getPropertyColumnDescriptor(int column) {
        int propertyCount;
        List<NamedBeanPropertyDescriptor<?>> propertyColumns = this.getManager().getKnownBeanProperties();
        int totalCount = this.getColumnCount();
        int tgt = column - (totalCount - (propertyCount = propertyColumns.size()));
        if (tgt < 0 || tgt >= propertyCount) {
            return null;
        }
        return propertyColumns.get(tgt);
    }

    protected synchronized void updateNameList() {
        T b;
        if (this.sysNameList != null) {
            for (String s : this.sysNameList) {
                b = this.getBySystemName(s);
                if (b == null) continue;
                b.removePropertyChangeListener(this);
            }
        }
        this.sysNameList = this.getManager().getNamedBeanSet().stream().map(NamedBean::getSystemName).collect(Collectors.toList());
        for (String s : this.sysNameList) {
            b = this.getBySystemName(s);
            if (b == null) continue;
            b.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("length")) {
            this.updateNameList();
            log.debug("Table changed length to {}", (Object)this.sysNameList.size());
            this.fireTableDataChanged();
        } else if (this.matchPropertyName(e) && e.getSource() instanceof NamedBean) {
            String name = ((NamedBean)e.getSource()).getSystemName();
            int row = this.sysNameList.indexOf(name);
            log.debug("Update cell {},{} for {}", new Object[]{row, 2, name});
            try {
                this.fireTableRowsUpdated(row, row);
            }
            catch (Exception ex) {
                log.error("Exception updating table", (Throwable)ex);
            }
        }
    }

    protected boolean matchPropertyName(PropertyChangeEvent e) {
        return e.getPropertyName().contains("State") || e.getPropertyName().contains("Appearance") || e.getPropertyName().contains("Comment") || e.getPropertyName().contains("UserName");
    }

    @Override
    public int getRowCount() {
        return this.sysNameList.size();
    }

    @Override
    public int getColumnCount() {
        return 5 + this.getPropertyColumnCount();
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColumnSystemName");
            }
            case 1: {
                return Bundle.getMessage("ColumnUserName");
            }
            case 2: {
                return Bundle.getMessage("ColumnState");
            }
            case 3: {
                return Bundle.getMessage("ColumnComment");
            }
            case 4: {
                return "";
            }
        }
        NamedBeanPropertyDescriptor<?> desc = this.getPropertyColumnDescriptor(col);
        if (desc == null) {
            return "btm unknown";
        }
        return desc.getColumnHeaderText();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return NamedBean.class;
            }
            case 1: 
            case 3: {
                return String.class;
            }
            case 2: 
            case 4: {
                return JButton.class;
            }
        }
        NamedBeanPropertyDescriptor<?> desc = this.getPropertyColumnDescriptor(col);
        if (desc == null) {
            return null;
        }
        return desc.getValueClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
            case 1: {
                T b = this.getBySystemName(this.sysNameList.get(row));
                String uname = b.getUserName();
                return uname == null || uname.isEmpty();
            }
        }
        NamedBeanPropertyDescriptor<?> desc = this.getPropertyColumnDescriptor(col);
        if (desc == null) {
            return false;
        }
        return desc.isEditable((NamedBean)this.getBySystemName(this.sysNameList.get(row)));
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.getBySystemName(this.sysNameList.get(row));
            }
            case 1: {
                T b = this.getBySystemName(this.sysNameList.get(row));
                return b != null ? b.getUserName() : null;
            }
            case 2: {
                return this.getValue(this.sysNameList.get(row));
            }
            case 3: {
                T b = this.getBySystemName(this.sysNameList.get(row));
                return b != null ? b.getComment() : null;
            }
            case 4: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        NamedBeanPropertyDescriptor<?> desc = this.getPropertyColumnDescriptor(col);
        if (desc == null) {
            log.error("internal state inconsistent with table requst for getValueAt {} {}", (Object)row, (Object)col);
            return null;
        }
        if (!this.isCellEditable(row, col)) {
            return null;
        }
        T b = this.getBySystemName(this.sysNameList.get(row));
        Object value = b.getProperty(desc.propertyKey);
        if (desc instanceof SelectionPropertyDescriptor) {
            JComboBox<String> c = new JComboBox<String>(((SelectionPropertyDescriptor)desc).getOptions());
            c.setSelectedItem(value != null ? value.toString() : desc.defaultValue.toString());
            ComboBoxToolTipRenderer renderer = new ComboBoxToolTipRenderer();
            c.setRenderer(renderer);
            renderer.setTooltips(((SelectionPropertyDescriptor)desc).getOptionToolTips());
            return c;
        }
        if (value == null) {
            return desc.defaultValue;
        }
        return value;
    }

    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: {
                return new JTextField((int)5).getPreferredSize().width;
            }
            case 1: 
            case 3: {
                return new JTextField((int)15).getPreferredSize().width;
            }
            case 2: 
            case 4: {
                return new JTextField((String)Bundle.getMessage((String)"ButtonDelete")).getPreferredSize().width;
            }
        }
        NamedBeanPropertyDescriptor<?> desc = this.getPropertyColumnDescriptor(col);
        if (desc == null || desc.getColumnHeaderText() == null) {
            log.error("Unexpected column in getPreferredWidth: {} table {}", (Object)col, (Object)this);
            return new JTextField((int)8).getPreferredSize().width;
        }
        return new JTextField((String)desc.getColumnHeaderText()).getPreferredSize().width;
    }

    public abstract String getValue(String var1);

    protected abstract Manager<T> getManager();

    protected void setManager(@Nonnull Manager<T> man) {
    }

    protected abstract T getBySystemName(@Nonnull String var1);

    protected abstract T getByUserName(@Nonnull String var1);

    protected abstract void clickOn(T var1);

    public int getDisplayDeleteMsg() {
        return InstanceManager.getDefault(UserPreferencesManager.class).getMultipleChoiceOption(this.getMasterClassName(), "deleteInUse");
    }

    public void setDisplayDeleteMsg(int boo) {
        InstanceManager.getDefault(UserPreferencesManager.class).setMultipleChoiceOption(this.getMasterClassName(), "deleteInUse", boo);
    }

    protected abstract String getMasterClassName();

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 1: {
                String msg;
                int optionPane;
                if (value.equals("")) {
                    value = null;
                } else {
                    T nB = this.getByUserName((String)value);
                    if (nB != null) {
                        log.error("User name is not unique {}", value);
                        String msg2 = Bundle.getMessage("WarningUserName", "" + value);
                        JOptionPane.showMessageDialog(null, msg2, Bundle.getMessage("WarningTitle"), 0);
                        return;
                    }
                }
                T nBean = this.getBySystemName(this.sysNameList.get(row));
                nBean.setUserName((String)value);
                if (!this.nbMan.inUse(this.sysNameList.get(row), nBean) || (optionPane = JOptionPane.showConfirmDialog(null, msg = Bundle.getMessage("UpdateToUserName", this.getBeanType(), value, this.sysNameList.get(row)), Bundle.getMessage("UpdateToUserNameTitle"), 0)) != 0) break;
                try {
                    this.nbMan.updateBeanFromSystemToUser((NamedBean)nBean);
                }
                catch (JmriException ex) {
                    log.error("Impossible exception setting user name", (Throwable)ex);
                }
                break;
            }
            case 3: {
                this.getBySystemName(this.sysNameList.get(row)).setComment((String)value);
                break;
            }
            case 2: {
                T t = this.getBySystemName(this.sysNameList.get(row));
                this.clickOn(t);
                break;
            }
            case 4: {
                this.deleteBean(row, col);
                break;
            }
            default: {
                NamedBeanPropertyDescriptor<?> desc = this.getPropertyColumnDescriptor(col);
                if (desc == null) {
                    log.error("btdm setvalueat {} {}", (Object)row, (Object)col);
                    break;
                }
                if (value instanceof JComboBox) {
                    value = ((JComboBox)value).getSelectedItem();
                }
                T b = this.getBySystemName(this.sysNameList.get(row));
                b.setProperty(desc.propertyKey, value);
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    protected void deleteBean(int row, int col) {
        DeleteBeanWorker worker = new DeleteBeanWorker(this, this.getBySystemName(this.sysNameList.get(row)));
        worker.execute();
    }

    protected void doDelete(T bean) {
        try {
            this.getManager().deleteBean(bean, "DoDelete");
        }
        catch (PropertyVetoException e) {
            log.error(e.getMessage());
        }
    }

    public void configureTable(JTable table) {
        this.setPropertyColumnsVisible(table, false);
        table.setDefaultRenderer(JComboBox.class, new BtValueRenderer());
        table.setDefaultEditor(JComboBox.class, new BtComboboxEditor());
        table.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
        table.getTableHeader().setReorderingAllowed(true);
        table.setAutoResizeMode(0);
        XTableColumnModel columnModel = (XTableColumnModel)table.getColumnModel();
        int i = 0;
        while (i < columnModel.getColumnCount(false)) {
            int width = this.getPreferredWidth(i);
            columnModel.getColumnByModelIndex(i).setPreferredWidth(width);
            ++i;
        }
        table.sizeColumnsToFit(-1);
        this.configValueColumn(table);
        this.configDeleteColumn(table);
        PopupListener popupListener = new PopupListener();
        table.addMouseListener(popupListener);
        this.persistTable(table);
    }

    protected void configValueColumn(JTable table) {
        this.setColumnToHoldButton(table, 2, this.configureButton());
    }

    public JButton configureButton() {
        JButton b = new JButton(Bundle.getMessage("BeanStateInconsistent"));
        b.putClientProperty("JComponent.sizeVariant", "small");
        b.putClientProperty("JButton.buttonType", "square");
        return b;
    }

    protected void configDeleteColumn(JTable table) {
        this.setColumnToHoldButton(table, 4, new JButton(Bundle.getMessage("ButtonDelete")));
    }

    protected void setColumnToHoldButton(JTable table, int column, JButton sample) {
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        table.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        table.setDefaultEditor(JButton.class, buttonEditor);
        table.setRowHeight(sample.getPreferredSize().height);
        table.getColumnModel().getColumn(column).setPreferredWidth(sample.getPreferredSize().width + 4);
    }

    public synchronized void dispose() {
        this.getManager().removePropertyChangeListener(this);
        if (this.sysNameList != null) {
            for (String s : this.sysNameList) {
                T b = this.getBySystemName(s);
                if (b == null) continue;
                b.removePropertyChangeListener(this);
            }
        }
    }

    public void printTable(HardcopyWriter w) {
        int columnSize = (w.getCharactersPerLine() - this.getColumnCount() - 1) / this.getColumnCount();
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), (columnSize + 1) * this.getColumnCount());
        String[] columnStrings = new String[this.getColumnCount()];
        int i = 0;
        while (i < this.getColumnCount()) {
            columnStrings[i] = this.getColumnName(i);
            ++i;
        }
        w.setFontStyle(1);
        this.printColumns(w, columnStrings, columnSize);
        w.setFontStyle(0);
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), (columnSize + 1) * this.getColumnCount());
        StringBuilder spaces = new StringBuilder();
        int i2 = 0;
        while (i2 < columnSize) {
            spaces.append(" ");
            ++i2;
        }
        i2 = 0;
        while (i2 < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                Object value = this.getValueAt(i2, j);
                columnStrings[j] = value == null ? spaces.toString() : (value instanceof JComboBox ? Objects.requireNonNull(((JComboBox)value).getSelectedItem()).toString() : value.toString());
                ++j;
            }
            this.printColumns(w, columnStrings, columnSize);
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), (columnSize + 1) * this.getColumnCount());
            ++i2;
        }
        w.close();
    }

    protected void printColumns(HardcopyWriter w, String[] columnStrings, int columnSize) {
        StringBuilder spaces = new StringBuilder();
        int i = 0;
        while (i < columnSize) {
            spaces.append(" ");
            ++i;
        }
        boolean complete = false;
        while (!complete) {
            StringBuilder lineString = new StringBuilder();
            complete = true;
            int i2 = 0;
            while (i2 < columnStrings.length) {
                String columnString = "";
                if (columnStrings[i2].length() > columnSize) {
                    boolean noWord = true;
                    int k = columnSize;
                    while (k >= 1) {
                        if (columnStrings[i2].charAt(k - 1) == ' ' || columnStrings[i2].charAt(k - 1) == '-' || columnStrings[i2].charAt(k - 1) == '_') {
                            columnString = String.valueOf(columnStrings[i2].substring(0, k)) + spaces.substring(columnStrings[i2].substring(0, k).length());
                            columnStrings[i2] = columnStrings[i2].substring(k);
                            noWord = false;
                            complete = false;
                            break;
                        }
                        --k;
                    }
                    if (noWord) {
                        columnString = columnStrings[i2].substring(0, columnSize);
                        columnStrings[i2] = columnStrings[i2].substring(columnSize);
                        complete = false;
                    }
                } else {
                    columnString = String.valueOf(columnStrings[i2]) + spaces.substring(columnStrings[i2].length());
                    columnStrings[i2] = "";
                }
                lineString.append(columnString).append(" ");
                ++i2;
            }
            try {
                w.write(lineString.toString());
                i2 = 0;
                while (i2 < w.getCharactersPerLine()) {
                    w.write(w.getCurrentLineNumber(), i2, w.getCurrentLineNumber() + 1, i2);
                    i2 = i2 + columnSize + 1;
                }
                w.write("\n");
            }
            catch (IOException e) {
                log.warn("error during printing: {}", (Object)e.getMessage());
            }
        }
    }

    public JTable makeJTable(@Nonnull String name, @Nonnull TableModel model, @CheckForNull RowSorter<? extends TableModel> sorter) {
        Objects.requireNonNull(name, "the table name must be nonnull");
        Objects.requireNonNull(model, "the table model must be nonnull");
        JTable table = new JTable(model){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                int realRowIndex = this.convertRowIndexToModel(rowIndex);
                int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                return BeanTableDataModel.this.getCellToolTip(this, realRowIndex, realColumnIndex);
            }

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                if (e instanceof KeyEvent && (((KeyEvent)e).getKeyCode() == 524 || ((KeyEvent)e).getKeyCode() == 157)) {
                    return false;
                }
                return super.editCellAt(row, column, e);
            }
        };
        return this.configureJTable(name, table, sorter);
    }

    protected JTable configureJTable(@Nonnull String name, @Nonnull JTable table, @CheckForNull RowSorter<? extends TableModel> sorter) {
        Objects.requireNonNull(table, "the table must be nonnull");
        Objects.requireNonNull(name, "the table name must be nonnull");
        table.setRowSorter(sorter);
        table.setName(name);
        table.getTableHeader().setReorderingAllowed(true);
        table.setColumnModel(new XTableColumnModel());
        table.createDefaultColumnsFromModel();
        this.addMouseListenerToHeader(table);
        return table;
    }

    protected String getBeanType() {
        return this.getManager().getBeanTypeHandled(false);
    }

    public void setPropertyColumnsVisible(JTable table, boolean visible) {
        XTableColumnModel columnModel = (XTableColumnModel)table.getColumnModel();
        int i = this.getColumnCount() - 1;
        while (i >= this.getColumnCount() - this.getPropertyColumnCount()) {
            TableColumn column = columnModel.getColumnByModelIndex(i);
            columnModel.setColumnVisible(column, visible);
            --i;
        }
    }

    protected void showPopup(MouseEvent e) {
        JTable source = (JTable)e.getSource();
        int row = source.rowAtPoint(e.getPoint());
        int column = source.columnAtPoint(e.getPoint());
        if (!source.isRowSelected(row)) {
            source.changeSelection(row, column, false, false);
        }
        int rowindex = source.convertRowIndexToModel(row);
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(Bundle.getMessage("CopyName"));
        menuItem.addActionListener(e1 -> this.copyName(rowindex, 0));
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("Rename"));
        menuItem.addActionListener(e1 -> this.renameBean(rowindex, 0));
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("ClearName"));
        menuItem.addActionListener(e1 -> this.removeName(rowindex, 0));
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("MoveName"));
        menuItem.addActionListener(e1 -> this.moveBean(rowindex, 0));
        if (this.getRowCount() == 1) {
            menuItem.setEnabled(false);
        }
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("EditComment"));
        menuItem.addActionListener(e1 -> this.editComment(rowindex, 0));
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("ButtonDelete"));
        menuItem.addActionListener(e1 -> this.deleteBean(rowindex, 0));
        popupMenu.add(menuItem);
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    public void copyName(int row, int column) {
        T nBean = this.getBySystemName(this.sysNameList.get(row));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection name = new StringSelection(nBean.getUserName());
        clipboard.setContents(name, null);
    }

    public void renameBean(int row, int column) {
        T nBean = this.getBySystemName(this.sysNameList.get(row));
        String oldName = nBean.getUserName() == null ? "" : nBean.getUserName();
        String newName = JOptionPane.showInputDialog(null, Bundle.getMessage("RenameFrom", this.getBeanType(), "\"" + oldName + "\""), oldName);
        if (newName == null || newName.equals(nBean.getUserName())) {
            return;
        }
        T nB = this.getByUserName(newName);
        if (nB != null) {
            log.error("User name is not unique {}", (Object)newName);
            String msg = Bundle.getMessage("WarningUserName", newName);
            JOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 0);
            return;
        }
        if (!this.allowBlockNameChange("Rename", nBean, newName)) {
            return;
        }
        nBean.setUserName(newName);
        this.fireTableRowsUpdated(row, row);
        if (!newName.isEmpty()) {
            if (oldName == null || oldName.isEmpty()) {
                if (!this.nbMan.inUse(this.sysNameList.get(row), nBean)) {
                    return;
                }
                String msg = Bundle.getMessage("UpdateToUserName", this.getBeanType(), newName, this.sysNameList.get(row));
                int optionPane = JOptionPane.showConfirmDialog(null, msg, Bundle.getMessage("UpdateToUserNameTitle"), 0);
                if (optionPane == 0) {
                    try {
                        this.nbMan.updateBeanFromSystemToUser((NamedBean)nBean);
                    }
                    catch (JmriException ex) {
                        log.error("Impossible exception renaming Bean", (Throwable)ex);
                    }
                }
            } else {
                this.nbMan.renameBean(oldName, newName, nBean);
            }
        } else {
            this.nbMan.updateBeanFromUserToSystem((NamedBean)nBean);
        }
    }

    public void removeName(int row, int column) {
        T nBean = this.getBySystemName(this.sysNameList.get(row));
        if (!this.allowBlockNameChange("Remove", nBean, "")) {
            return;
        }
        String msg = Bundle.getMessage("UpdateToSystemName", this.getBeanType());
        int optionPane = JOptionPane.showConfirmDialog(null, msg, Bundle.getMessage("UpdateToSystemNameTitle"), 0);
        if (optionPane == 0) {
            this.nbMan.updateBeanFromUserToSystem((NamedBean)nBean);
        }
        nBean.setUserName(null);
        this.fireTableRowsUpdated(row, row);
    }

    boolean allowBlockNameChange(String changeType, T bean, String newName) {
        if (!(bean instanceof Block)) {
            return true;
        }
        String oldName = bean.getUserName();
        if (oldName == null) {
            return true;
        }
        LayoutBlock layoutBlock = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(oldName);
        if (layoutBlock == null) {
            return true;
        }
        if (changeType.equals("Remove")) {
            log.warn("Cannot remove user name for block {}", (Object)oldName);
            JOptionPane.showMessageDialog(null, Bundle.getMessage("BlockRemoveUserNameWarning", oldName), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        int optionPane = JOptionPane.showConfirmDialog(null, Bundle.getMessage("BlockChangeUserName", oldName, newName), Bundle.getMessage("QuestionTitle"), 0);
        return optionPane == 0;
    }

    public void moveBean(int row, int column) {
        T t = this.getBySystemName(this.sysNameList.get(row));
        String currentName = t.getUserName();
        T oldNameBean = this.getBySystemName(this.sysNameList.get(row));
        if (currentName == null || currentName.isEmpty()) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("MoveDialogErrorMessage"));
            return;
        }
        JComboBox box = new JComboBox();
        this.getManager().getNamedBeanSet().forEach(b -> {
            String userName = b.getUserName();
            if (userName == null || userName.isEmpty()) {
                box.addItem(b.getSystemName());
            }
        });
        int retval = JOptionPane.showOptionDialog(null, Bundle.getMessage("MoveDialog", this.getBeanType(), currentName, oldNameBean.getSystemName()), Bundle.getMessage("MoveDialogTitle"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonCancel"), Bundle.getMessage("ButtonOK"), box}, null);
        log.debug("Dialog value {} selected {}:{}", new Object[]{retval, box.getSelectedIndex(), box.getSelectedItem()});
        if (retval != 1) {
            return;
        }
        String entry = (String)box.getSelectedItem();
        assert (entry != null);
        T newNameBean = this.getBySystemName(entry);
        if (oldNameBean != newNameBean) {
            String msg;
            int optionPane;
            oldNameBean.setUserName(null);
            newNameBean.setUserName(currentName);
            InstanceManager.getDefault(NamedBeanHandleManager.class).moveBean(oldNameBean, newNameBean, currentName);
            if (this.nbMan.inUse(newNameBean.getSystemName(), newNameBean) && (optionPane = JOptionPane.showConfirmDialog(null, msg = Bundle.getMessage("UpdateToUserName", this.getBeanType(), currentName, this.sysNameList.get(row)), Bundle.getMessage("UpdateToUserNameTitle"), 0)) == 0) {
                try {
                    this.nbMan.updateBeanFromSystemToUser((NamedBean)newNameBean);
                }
                catch (JmriException ex) {
                    log.error("Impossible exception moving Bean", (Throwable)ex);
                }
            }
            this.fireTableRowsUpdated(row, row);
            InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("UpdateComplete", this.getBeanType()), this.getMasterClassName(), "remindSaveReLoad");
        }
    }

    public void editComment(int row, int column) {
        T nBean = this.getBySystemName(this.sysNameList.get(row));
        JTextArea commentField = new JTextArea(5, 50);
        JScrollPane commentFieldScroller = new JScrollPane(commentField);
        commentField.setText(nBean.getComment());
        Object[] editCommentOption = new Object[]{Bundle.getMessage("ButtonCancel"), Bundle.getMessage("ButtonUpdate")};
        int retval = JOptionPane.showOptionDialog(null, commentFieldScroller, Bundle.getMessage("EditComment"), 0, 1, null, editCommentOption, editCommentOption[1]);
        if (retval != 1) {
            return;
        }
        nBean.setComment(commentField.getText());
    }

    public String getCellToolTip(JTable table, int row, int col) {
        String tip = null;
        if (!table.getName().contains("SignalMastLogic")) {
            T nBean;
            int column = 3;
            if (table.getName().contains("SignalGroup")) {
                column = 2;
            }
            if (col == column && (nBean = this.getBySystemName(this.sysNameList.get(row))) != null) {
                tip = this.formatToolTip(nBean.getComment());
            }
        } else if (col == 4) {
            SignalMastLogic sml;
            SignalMastManager smm = InstanceManager.getDefault(SignalMastManager.class);
            SignalMast source = smm.getSignalMast((String)table.getModel().getValueAt(row, 0));
            SignalMast dest = smm.getSignalMast((String)table.getModel().getValueAt(row, 2));
            if (source != null && (sml = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic(source)) != null && dest != null) {
                tip = this.formatToolTip(sml.getComment(dest));
            }
        }
        return tip;
    }

    String formatToolTip(String comment) {
        String tip = null;
        if (comment != null && !comment.isEmpty()) {
            tip = "<html>" + comment.replaceAll(System.getProperty("line.separator"), "<br>") + "</html>";
        }
        return tip;
    }

    protected void showTableHeaderPopup(MouseEvent e, JTable table) {
        JPopupMenu popupMenu = new JPopupMenu();
        XTableColumnModel tcm = (XTableColumnModel)table.getColumnModel();
        int i = 0;
        while (i < tcm.getColumnCount(false)) {
            TableColumn tc = tcm.getColumnByModelIndex(i);
            String columnName = table.getModel().getColumnName(i);
            if (columnName != null && !columnName.isEmpty()) {
                StayOpenCheckBoxItem menuItem = new StayOpenCheckBoxItem(table.getModel().getColumnName(i), tcm.isColumnVisible(tc));
                menuItem.addActionListener(new HeaderActionListener(tc, tcm));
                popupMenu.add(menuItem);
            }
            ++i;
        }
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void addMouseListenerToHeader(JTable table) {
        TableHeaderListener mouseHeaderListener = new TableHeaderListener(table);
        table.getTableHeader().addMouseListener(mouseHeaderListener);
    }

    public void persistTable(@Nonnull JTable table) throws NullPointerException {
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(manager -> {
            this.setColumnIdentities(table);
            manager.resetState(table);
            manager.persist(table);
        });
    }

    public void stopPersistingTable(@Nonnull JTable table) throws NullPointerException {
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(manager -> manager.stopPersisting(table));
    }

    protected void setColumnIdentities(JTable table) {
        Objects.requireNonNull(table.getModel(), "Table must have data model");
        Objects.requireNonNull(table.getColumnModel(), "Table must have column model");
        Enumeration<TableColumn> columns = table.getColumnModel() instanceof XTableColumnModel ? ((XTableColumnModel)table.getColumnModel()).getColumns(false) : table.getColumnModel().getColumns();
        int i = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (column.getIdentifier() == null || column.getIdentifier().toString().isEmpty()) {
                column.setIdentifier(String.format("Column%d", i));
            }
            ++i;
        }
    }

    private class BtComboboxEditor
    extends ValueEditor {
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof JComboBox) {
                ((JComboBox)value).addActionListener(e1 -> {
                    boolean bl = table.getCellEditor().stopCellEditing();
                });
            }
            if (value instanceof JComponent) {
                int modelcol = table.convertColumnIndexToModel(column);
                int modelrow = table.convertRowIndexToModel(row);
                boolean editable = table.getModel().isCellEditable(modelrow, modelcol);
                ((JComponent)value).setEnabled(editable);
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class BtValueRenderer
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Component) {
                return (Component)value;
            }
            if (value instanceof String) {
                return new JLabel((String)value);
            }
            JPanel f = new JPanel();
            f.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            return f;
        }
    }

    static class DeleteBeanWorker
    extends SwingWorker<Void, Void> {
        private final T t;
        final /* synthetic */ BeanTableDataModel this$0;

        public DeleteBeanWorker(T bean) {
            this.this$0 = var1_1;
            this.t = bean;
        }

        @Override
        public Void doInBackground() {
            StringBuilder message = new StringBuilder();
            try {
                this.this$0.getManager().deleteBean(this.t, "CanDelete");
            }
            catch (PropertyVetoException e2) {
                if (e2.getPropertyChangeEvent().getPropertyName().equals("DoNotDelete")) {
                    log.warn(e2.getMessage());
                    message.append(Bundle.getMessage("VetoDeleteBean", this.t.getBeanType(), this.t.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME), e2.getMessage()));
                    JOptionPane.showMessageDialog(null, message.toString(), Bundle.getMessage("WarningTitle"), 0);
                    return null;
                }
                message.append(e2.getMessage());
            }
            int count = this.t.getListenerRefs().size();
            log.debug("Delete with {}", (Object)count);
            if (this.this$0.getDisplayDeleteMsg() == 2 && message.toString().isEmpty()) {
                this.this$0.doDelete(this.t);
            } else {
                JDialog dialog = new JDialog();
                dialog.setTitle(Bundle.getMessage("WarningTitle"));
                dialog.setDefaultCloseOperation(2);
                JPanel container = new JPanel();
                container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                container.setLayout(new BoxLayout(container, 1));
                if (count > 0) {
                    JLabel question = new JLabel(Bundle.getMessage("DeletePrompt", this.t.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME)));
                    question.setAlignmentX(0.5f);
                    container.add(question);
                    ArrayList<String> listenerRefs = this.t.getListenerRefs();
                    if (listenerRefs.size() > 0) {
                        ArrayList<String> listeners = new ArrayList<String>();
                        for (String listenerRef : listenerRefs) {
                            if (listeners.contains(listenerRef)) continue;
                            listeners.add(listenerRef);
                        }
                        message.append("<br>");
                        message.append(Bundle.getMessage("ReminderInUse", count));
                        message.append("<ul>");
                        for (String listener : listeners) {
                            message.append("<li>");
                            message.append(listener);
                            message.append("</li>");
                        }
                        message.append("</ul>");
                        JEditorPane pane = new JEditorPane();
                        pane.setContentType("text/html");
                        pane.setText("<html>" + message.toString() + "</html>");
                        pane.setEditable(false);
                        JScrollPane jScrollPane = new JScrollPane(pane);
                        container.add(jScrollPane);
                    }
                } else {
                    String msg = MessageFormat.format(Bundle.getMessage("DeletePrompt"), this.t.getSystemName());
                    JLabel question = new JLabel(msg);
                    question.setAlignmentX(0.5f);
                    container.add(question);
                }
                JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
                remember.setFont(remember.getFont().deriveFont(10.0f));
                remember.setAlignmentX(0.5f);
                JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
                JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
                JPanel button = new JPanel();
                button.setAlignmentX(0.5f);
                button.add(yesButton);
                button.add(noButton);
                container.add(button);
                noButton.addActionListener(e -> dialog.dispose());
                yesButton.addActionListener(e -> {
                    if (remember.isSelected()) {
                        this.this$0.setDisplayDeleteMsg(2);
                    }
                    this.this$0.doDelete(this.t);
                    dialog.dispose();
                });
                container.add(remember);
                container.setAlignmentX(0.5f);
                container.setAlignmentY(0.5f);
                dialog.getContentPane().add(container);
                dialog.pack();
                dialog.getRootPane().setDefaultButton(noButton);
                noButton.requestFocusInWindow();
                dialog.getRootPane().registerKeyboardAction(e -> {
                    dialog.setVisible(false);
                    dialog.dispose();
                }, KeyStroke.getKeyStroke(27, 0), 2);
                dialog.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - dialog.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - dialog.getHeight() / 2);
                dialog.setModal(true);
                dialog.setVisible(true);
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Exception while deleting bean", (Throwable)e);
            }
        }
    }

    static class HeaderActionListener
    implements ActionListener {
        private final TableColumn tc;
        private final XTableColumnModel tcm;

        HeaderActionListener(TableColumn tc, XTableColumnModel tcm) {
            this.tc = tc;
            this.tcm = tcm;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem check = (JCheckBoxMenuItem)e.getSource();
            if (!check.isSelected() && this.tcm.getColumnCount(true) == 1) {
                return;
            }
            this.tcm.setColumnVisible(this.tc, check.isSelected());
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BeanTableDataModel.this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BeanTableDataModel.this.showPopup(e);
            }
        }
    }

    class PopupMenuRemoveName
    implements ActionListener {
        private final int row;

        PopupMenuRemoveName(int row) {
            this.row = row;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BeanTableDataModel.this.deleteBean(this.row, 0);
        }
    }

    class TableHeaderListener
    extends MouseAdapter {
        private final JTable table;

        TableHeaderListener(JTable tbl) {
            this.table = tbl;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BeanTableDataModel.this.showTableHeaderPopup(e, this.table);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BeanTableDataModel.this.showTableHeaderPopup(e, this.table);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BeanTableDataModel.this.showTableHeaderPopup(e, this.table);
            }
        }
    }
}

