/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.TableRowSorter;
import jmri.jmrit.beantable.AudioTableAction;
import jmri.jmrit.beantable.Bundle;
import jmri.swing.RowSorterUtil;
import jmri.util.swing.XTableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioTablePanel
extends JPanel {
    private AudioTableAction.AudioTableDataModel listenerDataModel;
    private AudioTableAction.AudioTableDataModel bufferDataModel;
    private AudioTableAction.AudioTableDataModel sourceDataModel;
    private JTable listenerDataTable;
    private JTable bufferDataTable;
    private JTable sourceDataTable;
    private JScrollPane listenerDataScroll;
    private JScrollPane bufferDataScroll;
    private JScrollPane sourceDataScroll;
    private JTabbedPane audioTabs;
    Box bottomBox;
    int bottomBoxIndex;
    static final int bottomStrutWidth = 20;
    private static final ResourceBundle rba = ResourceBundle.getBundle("jmri.jmrit.audio.swing.AudioTableBundle");
    private static final Logger log = LoggerFactory.getLogger(AudioTablePanel.class);

    public AudioTablePanel(AudioTableAction.AudioTableDataModel listenerModel, AudioTableAction.AudioTableDataModel bufferModel, AudioTableAction.AudioTableDataModel sourceModel, String helpTarget) {
        this.listenerDataModel = listenerModel;
        TableRowSorter<AudioTableAction.AudioTableDataModel> sorter = new TableRowSorter<AudioTableAction.AudioTableDataModel>(this.listenerDataModel);
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        this.listenerDataTable = this.listenerDataModel.makeJTable(this.listenerDataModel.getMasterClassName(), this.listenerDataModel, sorter);
        this.listenerDataScroll = new JScrollPane(this.listenerDataTable);
        this.listenerDataTable.setColumnModel(new XTableColumnModel());
        this.listenerDataTable.createDefaultColumnsFromModel();
        this.bufferDataModel = bufferModel;
        sorter = new TableRowSorter<AudioTableAction.AudioTableDataModel>(this.bufferDataModel);
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        this.bufferDataTable = this.bufferDataModel.makeJTable(this.bufferDataModel.getMasterClassName(), this.bufferDataModel, sorter);
        this.bufferDataScroll = new JScrollPane(this.bufferDataTable);
        this.bufferDataTable.setColumnModel(new XTableColumnModel());
        this.bufferDataTable.createDefaultColumnsFromModel();
        this.sourceDataModel = sourceModel;
        sorter = new TableRowSorter<AudioTableAction.AudioTableDataModel>(this.sourceDataModel);
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        this.sourceDataTable = this.sourceDataModel.makeJTable(this.sourceDataModel.getMasterClassName(), this.sourceDataModel, sorter);
        this.sourceDataScroll = new JScrollPane(this.sourceDataTable);
        this.sourceDataTable.setColumnModel(new XTableColumnModel());
        this.sourceDataTable.createDefaultColumnsFromModel();
        this.listenerDataModel.configureTable(this.listenerDataTable);
        this.listenerDataModel.configEditColumn(this.listenerDataTable);
        this.listenerDataModel.persistTable(this.listenerDataTable);
        this.bufferDataModel.configureTable(this.bufferDataTable);
        this.bufferDataModel.configEditColumn(this.bufferDataTable);
        this.bufferDataModel.persistTable(this.bufferDataTable);
        this.sourceDataModel.configureTable(this.sourceDataTable);
        this.sourceDataModel.configEditColumn(this.sourceDataTable);
        this.sourceDataModel.persistTable(this.sourceDataTable);
        this.setLayout(new BorderLayout());
        this.audioTabs = new JTabbedPane();
        this.audioTabs.addTab(rba.getString("LabelListener"), this.listenerDataScroll);
        this.audioTabs.addTab(rba.getString("LabelBuffers"), this.bufferDataScroll);
        this.audioTabs.addTab(rba.getString("LabelSources"), this.sourceDataScroll);
        this.add((Component)this.audioTabs, "Center");
        this.bottomBox = Box.createHorizontalBox();
        this.bottomBox.add(Box.createHorizontalGlue());
        this.bottomBoxIndex = 0;
        this.add((Component)this.bottomBox, "South");
        this.extras();
        this.listenerDataScroll.setHorizontalScrollBarPolicy(32);
        this.listenerDataScroll.setVerticalScrollBarPolicy(22);
        this.bufferDataScroll.setHorizontalScrollBarPolicy(32);
        this.bufferDataScroll.setVerticalScrollBarPolicy(22);
        this.sourceDataScroll.setHorizontalScrollBarPolicy(32);
        this.sourceDataScroll.setVerticalScrollBarPolicy(22);
    }

    void extras() {
    }

    protected Box getBottomBox() {
        return this.bottomBox;
    }

    public JMenuItem getPrintItem() {
        JMenuItem printItem = new JMenuItem(Bundle.getMessage("PrintTable"));
        printItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MessageFormat footerFormat = new MessageFormat("Page {0,number}");
                    AudioTablePanel.this.listenerDataTable.print(JTable.PrintMode.FIT_WIDTH, new MessageFormat("Listener Table"), footerFormat);
                    AudioTablePanel.this.bufferDataTable.print(JTable.PrintMode.FIT_WIDTH, new MessageFormat("Buffer Table"), footerFormat);
                    AudioTablePanel.this.sourceDataTable.print(JTable.PrintMode.FIT_WIDTH, new MessageFormat("Source Table"), footerFormat);
                }
                catch (PrinterException e1) {
                    log.warn("error printing: {}", (Object)e1, (Object)e1);
                }
            }
        });
        return printItem;
    }

    protected void addToBottomBox(Component comp) {
        this.bottomBox.add(Box.createHorizontalStrut(20), this.bottomBoxIndex);
        ++this.bottomBoxIndex;
        this.bottomBox.add(comp, this.bottomBoxIndex);
        ++this.bottomBoxIndex;
    }

    public void dispose() {
        if (this.listenerDataModel != null) {
            this.listenerDataModel.stopPersistingTable(this.listenerDataTable);
            this.listenerDataModel.dispose();
        }
        this.listenerDataModel = null;
        this.listenerDataTable = null;
        this.listenerDataScroll = null;
        if (this.bufferDataModel != null) {
            this.bufferDataModel.stopPersistingTable(this.bufferDataTable);
            this.bufferDataModel.dispose();
        }
        this.bufferDataModel = null;
        this.bufferDataTable = null;
        this.bufferDataScroll = null;
        if (this.sourceDataModel != null) {
            this.sourceDataModel.stopPersistingTable(this.sourceDataTable);
            this.sourceDataModel.dispose();
        }
        this.sourceDataModel = null;
        this.sourceDataTable = null;
        this.sourceDataScroll = null;
    }
}

