/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.audio.NullAudioFactory;
import jmri.jmrit.audio.swing.AudioBufferFrame;
import jmri.jmrit.audio.swing.AudioListenerFrame;
import jmri.jmrit.audio.swing.AudioSourceFrame;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.AudioTableFrame;
import jmri.jmrit.beantable.AudioTablePanel;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioTableAction
extends AbstractTableAction<Audio> {
    AudioTableDataModel listeners;
    AudioTableDataModel buffers;
    AudioTableDataModel sources;
    AudioSourceFrame sourceFrame;
    AudioBufferFrame bufferFrame;
    AudioListenerFrame listenerFrame;
    AudioTableFrame atf;
    AudioTablePanel atp;
    private static final Logger log = LoggerFactory.getLogger(AudioTableAction.class);

    public AudioTableAction(String actionName) {
        super(actionName);
        if (!InstanceManager.getOptionalDefault(AudioManager.class).isPresent()) {
            this.setEnabled(false);
        }
    }

    public AudioTableAction() {
        this(Bundle.getMessage("TitleAudioTable"));
    }

    @Override
    public void addToFrame(@Nonnull BeanTableFrame<Audio> f) {
        JButton addBufferButton = new JButton(Bundle.getMessage("ButtonAddAudioBuffer"));
        this.atp.addToBottomBox(addBufferButton);
        addBufferButton.addActionListener(this::addBufferPressed);
        JButton addSourceButton = new JButton(Bundle.getMessage("ButtonAddAudioSource"));
        this.atp.addToBottomBox(addSourceButton);
        addSourceButton.addActionListener(this::addSourcePressed);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.createModel();
        this.atf = new AudioTableFrame(this.atp, this.helpTarget()){

            @Override
            void extras() {
                AudioTableAction.this.addToFrame(this);
            }
        };
        this.setTitle();
        this.atf.pack();
        this.atf.setVisible(true);
    }

    @Override
    protected void createModel() {
        InstanceManager.getOptionalDefault(AudioManager.class).ifPresent(cm -> {
            if (cm.getActiveAudioFactory() == null) {
                cm.init();
                if (cm.getActiveAudioFactory() instanceof NullAudioFactory) {
                    InstanceManager.getDefault(UserPreferencesManager.class).showWarningMessage("Error", "NullAudioFactory initialised - no sounds will be available", this.getClassName(), "nullAudio", false, true);
                }
            }
        });
        this.listeners = new AudioListenerTableDataModel();
        this.buffers = new AudioBufferTableDataModel();
        this.sources = new AudioSourceTableDataModel();
        this.atp = new AudioTablePanel(this.listeners, this.buffers, this.sources, this.helpTarget());
    }

    @Override
    public JPanel getPanel() {
        this.createModel();
        return this.atp;
    }

    @Override
    protected void setTitle() {
        this.atf.setTitle(Bundle.getMessage("TitleAudioTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.AudioTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        log.warn("This should not have happened");
    }

    void addSourcePressed(ActionEvent e) {
        if (this.sourceFrame == null) {
            this.sourceFrame = new AudioSourceFrame(Bundle.getMessage("TitleAddAudioSource"), this.sources);
        }
        this.sourceFrame.updateBufferList();
        this.sourceFrame.resetFrame();
        this.sourceFrame.setEscapeKeyClosesWindow(true);
        this.sourceFrame.pack();
        this.sourceFrame.setVisible(true);
    }

    void addBufferPressed(ActionEvent e) {
        if (this.bufferFrame == null) {
            this.bufferFrame = new AudioBufferFrame(Bundle.getMessage("TitleAddAudioBuffer"), this.buffers);
        }
        this.bufferFrame.resetFrame();
        this.bufferFrame.setEscapeKeyClosesWindow(true);
        this.bufferFrame.pack();
        this.bufferFrame.setVisible(true);
    }

    @Override
    public void setMenuBar(BeanTableFrame<Audio> f) {
        MenuElement[] subElements;
        JMenuBar menuBar = f.getJMenuBar();
        JMenu fileMenu = null;
        int i = 0;
        while (i < menuBar.getMenuCount()) {
            if (menuBar.getComponent(i) instanceof JMenu && ((JMenu)menuBar.getComponent(i)).getText().equals(Bundle.getMessage("MenuFile"))) {
                fileMenu = menuBar.getMenu(i);
            }
            ++i;
        }
        if (fileMenu == null) {
            return;
        }
        MenuElement[] menuElementArray = subElements = fileMenu.getSubElements();
        int n = subElements.length;
        int n2 = 0;
        while (n2 < n) {
            MenuElement[] popsubElements;
            MenuElement subElement = menuElementArray[n2];
            MenuElement[] menuElementArray2 = popsubElements = subElement.getSubElements();
            int n3 = popsubElements.length;
            int n4 = 0;
            while (n4 < n3) {
                MenuElement popsubElement = menuElementArray2[n4];
                if (popsubElement instanceof JMenuItem && ((JMenuItem)popsubElement).getText().equals(Bundle.getMessage("PrintTable"))) {
                    JMenuItem printMenu = (JMenuItem)popsubElement;
                    fileMenu.remove(printMenu);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        fileMenu.add(this.atp.getPrintItem());
    }

    protected void editAudio(Audio a) {
        switch (a.getSubType()) {
            case 'L': {
                if (this.listenerFrame == null) {
                    this.listenerFrame = new AudioListenerFrame(Bundle.getMessage("TitleAddAudioListener"), this.listeners);
                }
                this.listenerFrame.populateFrame(a);
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        AudioTableAction.this.listenerFrame.pack();
                        AudioTableAction.this.listenerFrame.setVisible(true);
                    }
                };
                SwingUtilities.invokeLater(t);
                break;
            }
            case 'B': {
                if (this.bufferFrame == null) {
                    this.bufferFrame = new AudioBufferFrame(Bundle.getMessage("TitleAddAudioBuffer"), this.buffers);
                }
                this.bufferFrame.populateFrame(a);
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        AudioTableAction.this.bufferFrame.pack();
                        AudioTableAction.this.bufferFrame.setVisible(true);
                    }
                };
                SwingUtilities.invokeLater(t);
                break;
            }
            case 'S': {
                if (this.sourceFrame == null) {
                    this.sourceFrame = new AudioSourceFrame(Bundle.getMessage("TitleAddAudioBuffer"), this.sources);
                }
                this.sourceFrame.updateBufferList();
                this.sourceFrame.populateFrame(a);
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        AudioTableAction.this.sourceFrame.pack();
                        AudioTableAction.this.sourceFrame.setVisible(true);
                    }
                };
                SwingUtilities.invokeLater(t);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void setMessagePreferencesDetails() {
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "nullAudio", Bundle.getMessage("HideNullAudioWarningMessage"));
        super.setMessagePreferencesDetails();
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleAudioTable");
    }

    @Override
    protected String getClassName() {
        return AudioTableAction.class.getName();
    }

    public class AudioBufferTableDataModel
    extends AudioTableDataModel {
        AudioBufferTableDataModel() {
            super('B');
        }

        @Override
        protected synchronized void updateNameList() {
            this.updateSpecificNameList('B');
        }
    }

    public class AudioListenerTableDataModel
    extends AudioTableDataModel {
        AudioListenerTableDataModel() {
            super('L');
        }

        @Override
        protected synchronized void updateNameList() {
            this.updateSpecificNameList('L');
        }

        @Override
        protected void showPopup(MouseEvent e) {
        }
    }

    public class AudioSourceTableDataModel
    extends AudioTableDataModel {
        AudioSourceTableDataModel() {
            super('S');
        }

        @Override
        protected synchronized void updateNameList() {
            this.updateSpecificNameList('S');
        }
    }

    public abstract class AudioTableDataModel
    extends BeanTableDataModel<Audio> {
        char subType;
        public static final int EDITCOL = 5;

        public AudioTableDataModel(char subType) {
            this.subType = subType;
            this.getManager().addPropertyChangeListener(this);
            this.updateNameList();
        }

        public AudioManager getManager() {
            return InstanceManager.getDefault(AudioManager.class);
        }

        @Override
        protected String getMasterClassName() {
            return AudioTableAction.this.getClassName();
        }

        @Override
        public Audio getBySystemName(@Nonnull String name) {
            return InstanceManager.getDefault(AudioManager.class).getBySystemName(name);
        }

        @Override
        public Audio getByUserName(@Nonnull String name) {
            return InstanceManager.getDefault(AudioManager.class).getByUserName(name);
        }

        protected synchronized void updateSpecificNameList(char subType) {
            if (this.sysNameList != null) {
                for (String sysName2 : this.sysNameList) {
                    Audio b = this.getBySystemName(sysName2);
                    if (b == null) continue;
                    b.removePropertyChangeListener(this);
                }
            }
            this.sysNameList = this.getManager().getSystemNameList(subType);
            this.sysNameList.stream().forEach(sysName -> this.getBySystemName((String)sysName).addPropertyChangeListener(this));
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 2: {
                    return Bundle.getMessage("LightControlDescription");
                }
                case 5: {
                    return "";
                }
            }
            return super.getColumnName(col);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 2: {
                    return String.class;
                }
                case 5: {
                    return JButton.class;
                }
                case 4: {
                    return this.subType != 'L' ? JButton.class : String.class;
                }
            }
            return super.getColumnClass(col);
        }

        @Override
        public String getValue(String systemName) {
            Audio m = InstanceManager.getDefault(AudioManager.class).getBySystemName(systemName);
            if (this.subType == 'S') {
                return m != null ? ((AudioSource)m).getDebugString() : "";
            }
            return m != null ? m.toString() : "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.sysNameList.get(row);
                }
                case 1: {
                    Audio a = this.getBySystemName((String)this.sysNameList.get(row));
                    return a != null ? a.getUserName() : null;
                }
                case 2: {
                    Audio a = this.getBySystemName((String)this.sysNameList.get(row));
                    return a != null ? this.getValue(a.getSystemName()) : null;
                }
                case 3: {
                    Audio a = this.getBySystemName((String)this.sysNameList.get(row));
                    return a != null ? a.getComment() : null;
                }
                case 4: {
                    return this.subType != 'L' ? Bundle.getMessage("ButtonDelete") : "";
                }
                case 5: {
                    return Bundle.getMessage("ButtonEdit");
                }
            }
            log.error("internal state inconsistent with table requst for {} {}", (Object)row, (Object)col);
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 5: {
                    Audio a = this.getBySystemName((String)this.sysNameList.get(row));
                    AudioTableAction.this.editAudio(a);
                    break;
                }
                default: {
                    super.setValueAt(value, row, col);
                }
            }
        }

        @Override
        public int getPreferredWidth(int col) {
            switch (col) {
                case 2: {
                    return new JTextField((int)50).getPreferredSize().width;
                }
                case 5: {
                    return new JButton((String)Bundle.getMessage((String)"ButtonEdit")).getPreferredSize().width;
                }
            }
            return super.getPreferredWidth(col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 4: {
                    return this.subType != 'L';
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return true;
                }
            }
            return super.isCellEditable(row, col);
        }

        @Override
        protected void clickOn(Audio t) {
        }

        @Override
        protected void configValueColumn(JTable table) {
        }

        protected void configEditColumn(JTable table) {
            this.setColumnToHoldButton(table, 5, new JButton(Bundle.getMessage("ButtonEdit")));
        }

        @Override
        protected String getBeanType() {
            return "Audio";
        }
    }
}

