/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import com.alexandriasoftware.swing.Validation;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import jmri.Manager;
import jmri.jmrit.beantable.Bundle;
import jmri.swing.ManagerComboBox;
import jmri.swing.SystemNameValidator;
import jmri.util.swing.JmriPanel;

public class AddNewHardwareDevicePanel
extends JmriPanel {
    JButton cancel = new JButton(Bundle.getMessage("ButtonClose"));
    JSpinner _endRange;
    JCheckBox _range;
    JLabel sysNameLabel = new JLabel(Bundle.getMessage("SystemConnectionLabel"));
    JLabel sysAddressLabel = new JLabel(Bundle.getMessage("LabelHardwareAddress"));
    JLabel userNameLabel = new JLabel(Bundle.getMessage("LabelUserName"));
    JLabel finishLabel = new JLabel(Bundle.getMessage("LabelNumberToAdd"));
    JLabel statusBar;

    public AddNewHardwareDevicePanel(@Nonnull JTextField sysAddress, @Nonnull SystemNameValidator sysAddressValidator, @Nonnull JTextField userName, @Nonnull ManagerComboBox<?> prefixBox, JSpinner endRange, JCheckBox addRange, @Nonnull JButton addButton, @Nonnull ActionListener cancelListener, @Nonnull ActionListener rangeListener, @Nonnull JLabel statusBar) {
        this.setLayout(new BoxLayout(this, 1));
        this.statusBar = statusBar;
        this._endRange = endRange;
        this._range = addRange;
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        p.add((Component)this.sysNameLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        p.add((Component)this.sysAddressLabel, c);
        this.sysAddressLabel.setLabelFor(sysAddress);
        c.gridy = 2;
        p.add((Component)this.userNameLabel, c);
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 0;
        p.add(prefixBox, c);
        c.gridx = 3;
        p.add((Component)addRange, c);
        c.gridx = 2;
        c.gridy = 1;
        p.add((Component)sysAddress, c);
        sysAddress.setToolTipText(Bundle.getMessage("HardwareAddressToolTip"));
        c.gridx = 3;
        p.add((Component)this.finishLabel, c);
        c.gridx = 4;
        p.add((Component)endRange, c);
        c.gridx = 2;
        c.gridy = 2;
        p.add((Component)userName, c);
        userName.setToolTipText(Bundle.getMessage("UserNameToolTip"));
        this.add(p);
        this.finishLabel.setEnabled(false);
        this._endRange.setEnabled(false);
        JPanel panelStatus = new JPanel();
        panelStatus.setLayout(new FlowLayout());
        statusBar.setFont(statusBar.getFont().deriveFont(0.9f * (float)this.sysAddressLabel.getFont().getSize()));
        statusBar.setForeground(Color.gray);
        panelStatus.add(statusBar);
        this.add(panelStatus);
        JPanel panelBottom = new JPanel();
        panelBottom.setLayout(new FlowLayout(4));
        panelBottom.add(this.cancel);
        this.cancel.addActionListener(cancelListener);
        panelBottom.add(addButton);
        this.add(panelBottom);
        addRange.addItemListener(e -> this.rangeState());
        prefixBox.addActionListener(rangeListener);
        sysAddress.setInputVerifier((InputVerifier)((Object)sysAddressValidator));
        if (prefixBox.getSelectedItem() == null) {
            prefixBox.setSelectedIndex(0);
        }
        prefixBox.addActionListener(evt -> {
            Object manager = prefixBox.getSelectedItem();
            if (manager != null) {
                sysAddress.setText("");
                sysAddressValidator.setManager((Manager<?>)manager);
            }
        });
        sysAddressValidator.addPropertyChangeListener("validation", evt -> {
            Validation validation = sysAddressValidator.getValidation();
            Validation.Type type = validation.getType();
            addButton.setEnabled(type != Validation.Type.WARNING && type != Validation.Type.DANGER);
            this.setStatusBarText(validation.getMessage());
        });
        sysAddressValidator.setManager((Manager<?>)prefixBox.getSelectedItem());
        sysAddressValidator.verify(sysAddress);
    }

    public void addLabels(String labelSystemName, String labelUserName) {
        this.sysAddressLabel.setText(labelSystemName);
        this.userNameLabel.setText(labelUserName);
    }

    private void rangeState() {
        if (this._range.isSelected()) {
            this.finishLabel.setEnabled(true);
            this._endRange.setEnabled(true);
        } else {
            this.finishLabel.setEnabled(false);
            this._endRange.setEnabled(false);
        }
    }

    public void setStatusBarText(@CheckForNull String message) {
        if (message == null) {
            this.statusBar.setText("");
        } else {
            if ((message = message.trim()).startsWith("<html>") && message.contains("<br>") && !(message = message.substring(0, message.indexOf("<br>"))).endsWith("</html>")) {
                message = String.valueOf(message) + "</html>";
            }
            this.statusBar.setText(message);
        }
    }
}

