/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.managers.AbstractProxyManager;
import jmri.swing.RowSorterUtil;
import jmri.util.AlphanumComparator;
import jmri.util.swing.TriStateJCheckBox;
import jmri.util.swing.XTableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableTabAction<E extends NamedBean>
extends AbstractTableAction<E> {
    protected JPanel dataPanel;
    protected JTabbedPane dataTabs;
    protected boolean init = false;
    protected ArrayList<TabbedTableItem<E>> tabbedTableArray = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(AbstractTableTabAction.class);

    public AbstractTableTabAction(String s) {
        super(s);
    }

    @Override
    protected void createModel() {
        this.dataPanel = new JPanel();
        this.dataTabs = new JTabbedPane();
        this.dataPanel.setLayout(new BorderLayout());
        Manager<E> mgr = this.getManager();
        if (mgr instanceof AbstractProxyManager) {
            AbstractProxyManager proxy = (AbstractProxyManager)mgr;
            this.tabbedTableArray.add(new TabbedTableItem<E>(Bundle.getMessage("All"), true, mgr, this.getNewTableAction("All")));
            proxy.getDisplayOrderManagerList().stream().map(manager -> {
                String manuName = manager.getMemo().getUserName();
                TabbedTableItem<E> itemModel = new TabbedTableItem<E>(manuName, true, manager, this.getNewTableAction(manuName));
                return itemModel;
            }).forEachOrdered(itemModel -> this.tabbedTableArray.add((TabbedTableItem<TabbedTableItem>)itemModel));
        } else {
            Manager<E> man = this.getManager();
            String manuName = man != null ? man.getMemo().getUserName() : "Unknown Manager";
            this.tabbedTableArray.add(new TabbedTableItem<E>(manuName, true, this.getManager(), this.getNewTableAction(manuName)));
        }
        int x = 0;
        while (x < this.tabbedTableArray.size()) {
            AbstractTableAction<E> table = this.tabbedTableArray.get(x).getAAClass();
            table.addToPanel(this);
            this.dataTabs.addTab(this.tabbedTableArray.get(x).getItemString(), null, this.tabbedTableArray.get(x).getPanel(), null);
            ++x;
        }
        this.dataTabs.addChangeListener(evt -> this.setMenuBar(this.f));
        this.dataPanel.add((Component)this.dataTabs, "Center");
        this.init = true;
    }

    @Override
    protected abstract Manager<E> getManager();

    protected abstract AbstractTableAction<E> getNewTableAction(String var1);

    @Override
    public JPanel getPanel() {
        if (!this.init) {
            this.createModel();
        }
        return this.dataPanel;
    }

    @Override
    protected void setTitle() {
    }

    @Override
    protected abstract String helpTarget();

    @Override
    protected void addPressed(ActionEvent e) {
        log.warn("This should not have happened");
    }

    @Override
    public void addToFrame(BeanTableFrame<E> f) {
        try {
            TabbedTableItem<E> table = this.tabbedTableArray.get(this.dataTabs.getSelectedIndex());
            if (table != null) {
                table.getAAClass().addToFrame(f);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.error("{} in add to Frame {} {}", new Object[]{ex.toString(), this.dataTabs.getSelectedIndex(), this.dataTabs.getSelectedComponent()});
        }
    }

    @Override
    public void setMenuBar(BeanTableFrame<E> f) {
        try {
            this.tabbedTableArray.get(this.dataTabs.getSelectedIndex()).getAAClass().setMenuBar(f);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.error("{} in add to Menu {} {}", new Object[]{ex.toString(), this.dataTabs.getSelectedIndex(), this.dataTabs.getSelectedComponent()});
        }
    }

    public void addToBottomBox(JComponent c, String str) {
        this.tabbedTableArray.forEach((Consumer<TabbedTableItem<TabbedTableItem>>)((Consumer<TabbedTableItem>)table -> {
            String item = table.getItemString();
            if (item != null && item.equals(str)) {
                table.addToBottomBox(c);
            }
        }));
    }

    @Override
    public void print(JTable.PrintMode mode, MessageFormat headerFormat, MessageFormat footerFormat) {
        try {
            this.tabbedTableArray.get(this.dataTabs.getSelectedIndex()).getDataTable().print(mode, headerFormat, footerFormat);
        }
        catch (PrinterException e1) {
            log.warn("error printing: {}", (Throwable)e1);
        }
        catch (NullPointerException nullPointerException) {
            log.error("Trying to print returned a NPE error");
        }
    }

    @Override
    public void dispose() {
        int x = 0;
        while (x < this.tabbedTableArray.size()) {
            this.tabbedTableArray.get(x).dispose();
            ++x;
        }
        super.dispose();
    }

    protected static class TabbedTableItem<E extends NamedBean>
    implements TableColumnModelListener {
        final AbstractTableAction<E> tableAction;
        final String itemText;
        private BeanTableDataModel<E> dataModel;
        private JTable dataTable;
        private JScrollPane dataScroll;
        final Box bottomBox;
        private boolean addToFrameRan = false;
        final Manager<E> manager;
        private int bottomBoxIndex;
        static final int BOTTOM_STRUT_WIDTH = 20;
        private boolean standardModel = true;
        final JPanel dataPanel = new JPanel();
        private final TriStateJCheckBox propertyVisible = new TriStateJCheckBox(Bundle.getMessage("ShowSystemSpecificProperties"));

        public TabbedTableItem(String choice, boolean stdModel, Manager<E> manager, AbstractTableAction<E> tableAction) {
            this.tableAction = tableAction;
            this.itemText = choice;
            this.standardModel = stdModel;
            this.manager = manager;
            this.bottomBox = Box.createHorizontalBox();
            this.bottomBox.add(Box.createHorizontalGlue());
            this.bottomBoxIndex = 0;
            this.dataPanel.setLayout(new BorderLayout());
            if (stdModel) {
                this.createDataModel();
            } else {
                this.addPanelModel();
            }
        }

        final void createDataModel() {
            if (this.manager != null) {
                this.tableAction.setManager(this.manager);
            }
            this.dataModel = this.tableAction.getTableDataModel();
            TableRowSorter<BeanTableDataModel<E>> sorter = new TableRowSorter<BeanTableDataModel<E>>(this.dataModel);
            this.dataTable = this.dataModel.makeJTable(String.valueOf(this.dataModel.getMasterClassName()) + ":" + this.getItemString(), this.dataModel, sorter);
            this.dataScroll = new JScrollPane(this.dataTable);
            RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
            sorter.setComparator(1, new AlphanumComparator());
            RowSorterUtil.setSortOrder(sorter, 1, SortOrder.ASCENDING);
            this.dataModel.configureTable(this.dataTable);
            this.tableAction.configureTable(this.dataTable);
            Dimension dataTableSize = this.dataTable.getPreferredSize();
            dataTableSize.height = Math.max(dataTableSize.height, 400);
            this.dataScroll.getViewport().setPreferredSize(dataTableSize);
            this.dataScroll.setHorizontalScrollBarPolicy(32);
            this.dataScroll.setVerticalScrollBarPolicy(22);
            this.dataPanel.add((Component)this.dataScroll, "Center");
            this.dataPanel.add((Component)this.bottomBox, "South");
            if (this.tableAction.includeAddButton()) {
                JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
                this.addToBottomBox(addButton);
                addButton.addActionListener(e -> this.tableAction.addPressed(e));
            }
            if (this.dataModel.getPropertyColumnCount() > 0) {
                this.propertyVisible.setToolTipText(Bundle.getMessage("ShowSystemSpecificPropertiesToolTip"));
                this.addToBottomBox(this.propertyVisible);
                this.propertyVisible.addActionListener(e -> this.dataModel.setPropertyColumnsVisible(this.dataTable, this.propertyVisible.isSelected()));
            }
            this.fireColumnsUpdated();
            this.dataTable.getColumnModel().addColumnModelListener(this);
        }

        private void fireColumnsUpdated() {
            TableColumnModel model = this.dataTable.getColumnModel();
            if (model instanceof XTableColumnModel) {
                Enumeration<TableColumn> e = ((XTableColumnModel)model).getColumns(false);
                int numCols = ((XTableColumnModel)model).getColumnCount(false);
                if (numCols != this.dataModel.getColumnCount()) {
                    log.debug("Difference with Xtable cols: {} Model cols: {}", (Object)numCols, (Object)this.dataModel.getColumnCount());
                    return;
                }
                boolean[] colsVisible = new boolean[numCols];
                while (e.hasMoreElements()) {
                    boolean visible;
                    TableColumn column = e.nextElement();
                    colsVisible[column.getModelIndex()] = visible = ((XTableColumnModel)model).isColumnVisible(column);
                }
                this.tableAction.columnsVisibleUpdated(colsVisible);
                this.setPropertyVisibleCheckbox(colsVisible);
            }
        }

        private void setPropertyVisibleCheckbox(boolean[] colsVisible) {
            int numberofCustomCols = this.dataModel.getPropertyColumnCount();
            if (numberofCustomCols > 0) {
                boolean[] customColVisibility = new boolean[numberofCustomCols];
                int i = 0;
                while (i < numberofCustomCols) {
                    customColVisibility[i] = colsVisible[colsVisible.length - i - 1];
                    ++i;
                }
                this.propertyVisible.setState(customColVisibility);
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            this.fireColumnsUpdated();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            this.fireColumnsUpdated();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        final void addPanelModel() {
            this.dataPanel.add((Component)this.tableAction.getPanel(), "Center");
            this.dataPanel.add((Component)this.bottomBox, "South");
        }

        public boolean getStandardTableModel() {
            return this.standardModel;
        }

        public String getItemString() {
            return this.itemText;
        }

        public AbstractTableAction<E> getAAClass() {
            return this.tableAction;
        }

        public JPanel getPanel() {
            return this.dataPanel;
        }

        public boolean getAdditionsToFrameDone() {
            return this.addToFrameRan;
        }

        public void setAddToFrameRan() {
            this.addToFrameRan = true;
        }

        public JTable getDataTable() {
            return this.dataTable;
        }

        protected void addToBottomBox(JComponent comp) {
            try {
                this.bottomBox.add(Box.createHorizontalStrut(20), this.bottomBoxIndex);
                ++this.bottomBoxIndex;
                this.bottomBox.add((Component)comp, this.bottomBoxIndex);
                ++this.bottomBoxIndex;
            }
            catch (IllegalArgumentException ex) {
                log.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
        }

        protected void dispose() {
            if (this.dataTable != null) {
                this.dataTable.getColumnModel().removeColumnModelListener(this);
            }
            if (this.dataModel != null) {
                this.dataModel.stopPersistingTable(this.dataTable);
                this.dataModel.dispose();
            }
            this.dataModel = null;
            this.dataTable = null;
            this.dataScroll = null;
        }
    }
}

