/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.ProxyManager;
import jmri.SystemConnectionMemo;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableTabAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrix.SystemConnectionMemoManager;
import jmri.swing.ManagerComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableAction<E extends NamedBean>
extends AbstractAction {
    protected BeanTableDataModel<E> m;
    protected BeanTableFrame<E> f;
    protected boolean includeAddButton = true;
    private static final Logger log = LoggerFactory.getLogger(AbstractTableAction.class);

    public AbstractTableAction(String actionName) {
        super(actionName);
    }

    public AbstractTableAction(String actionName, Object option) {
        super(actionName);
    }

    protected abstract void createModel();

    protected abstract void setTitle();

    @Override
    public void actionPerformed(ActionEvent e) {
        this.createModel();
        TableRowSorter<BeanTableDataModel<E>> sorter = new TableRowSorter<BeanTableDataModel<E>>(this.m);
        JTable dataTable = this.m.makeJTable(this.m.getMasterClassName(), this.m, sorter);
        dataTable.getTableHeader().setReorderingAllowed(true);
        this.f = new BeanTableFrame<E>(this.m, this.helpTarget(), dataTable){

            @Override
            void extras() {
                if (AbstractTableAction.this.includeAddButton) {
                    JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
                    this.addToBottomBox(addButton, this.getClass().getName());
                    addButton.addActionListener(e1 -> AbstractTableAction.this.addPressed(e1));
                }
            }
        };
        this.setMenuBar(this.f);
        this.configureTable(dataTable);
        this.setTitle();
        this.addToFrame(this.f);
        this.f.pack();
        this.f.setVisible(true);
    }

    protected void columnsVisibleUpdated(boolean[] colsVisible) {
        log.debug("columns updated {}", (Object)colsVisible);
    }

    public BeanTableDataModel<E> getTableDataModel() {
        this.createModel();
        return this.m;
    }

    public void setFrame(@Nonnull BeanTableFrame<E> frame) {
        this.f = frame;
    }

    public BeanTableFrame<E> getFrame() {
        return this.f;
    }

    public void addToFrame(@Nonnull BeanTableFrame<E> f) {
    }

    public void addToPanel(AbstractTableTabAction<E> f) {
    }

    protected void setManager(@Nonnull Manager<E> man) {
    }

    @CheckForNull
    protected Manager<E> getManager() {
        return null;
    }

    public void setMenuBar(BeanTableFrame<E> f) {
    }

    public JPanel getPanel() {
        return null;
    }

    protected void configureTable(JTable table) {
    }

    public void dispose() {
        if (this.m != null) {
            this.m.dispose();
        }
    }

    @Nonnull
    protected String nextName(@Nonnull String name) {
        String[] parts = name.split("(?=\\d+$)", 2);
        String numString = "0";
        if (parts.length == 2) {
            numString = parts[1];
        }
        int numStringLength = numString.length();
        int num = Integer.parseInt(numString) + 1;
        return String.valueOf(parts[0]) + String.format("%0" + numStringLength + "d", num);
    }

    protected String helpTarget() {
        return "index";
    }

    public String getClassDescription() {
        return "Abstract Table Action";
    }

    public void setMessagePreferencesDetails() {
        HashMap<Integer, String> options = new HashMap<Integer, String>(3);
        options.put(0, Bundle.getMessage("DeleteAsk"));
        options.put(1, Bundle.getMessage("DeleteNever"));
        options.put(2, Bundle.getMessage("DeleteAlways"));
        InstanceManager.getDefault(UserPreferencesManager.class).setMessageItemDetails(this.getClassName(), "deleteInUse", Bundle.getMessage("DeleteItemInUse"), options, 0);
    }

    protected abstract String getClassName();

    public boolean includeAddButton() {
        return this.includeAddButton;
    }

    public void print(JTable.PrintMode mode, MessageFormat headerFormat, MessageFormat footerFormat) {
        log.error("Printing not handled for {} tables.", (Object)this.m.getBeanType());
    }

    protected abstract void addPressed(ActionEvent var1);

    protected void configureManagerComboBox(ManagerComboBox<E> comboBox, Manager<E> manager, Class<? extends Manager<E>> managerClass) {
        Manager<E> defaultManager = InstanceManager.getDefault(managerClass);
        if (defaultManager instanceof ProxyManager) {
            comboBox.setManagers(defaultManager);
        } else {
            comboBox.setManagers(manager);
        }
        if (manager instanceof ProxyManager) {
            String systemSelectionCombo;
            UserPreferencesManager upm = InstanceManager.getDefault(UserPreferencesManager.class);
            if (upm.getComboBoxLastSelection(systemSelectionCombo = String.valueOf(this.getClass().getName()) + ".SystemSelected") != null) {
                SystemConnectionMemo memo = SystemConnectionMemoManager.getDefault().getSystemConnectionMemoForUserName(upm.getComboBoxLastSelection(systemSelectionCombo));
                if (memo != null) {
                    comboBox.setSelectedItem(memo.get(managerClass));
                } else {
                    ProxyManager proxy = (ProxyManager)manager;
                    comboBox.setSelectedItem(proxy.getDefaultManager());
                }
            } else {
                ProxyManager proxy = (ProxyManager)manager;
                comboBox.setSelectedItem(proxy.getDefaultManager());
            }
        } else {
            comboBox.setSelectedItem(manager);
        }
    }

    protected void removePrefixBoxListener(ManagerComboBox<E> prefixBox) {
        Arrays.asList(prefixBox.getActionListeners()).forEach(l -> prefixBox.removeActionListener((ActionListener)l));
    }

    protected void displayHwError(String curAddress, Exception ex) {
        log.warn("Invalid Entry: {}", (Object)ex.getMessage());
        InstanceManager.getDefault(UserPreferencesManager.class).showErrorMessage(Bundle.getMessage("ErrorTitle"), Bundle.getMessage("ErrorConvertHW", curAddress), "" + ex, "", true, false);
    }
}

