/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrit.beantable.LogixNGTableAction;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.LogixNG_UserPreferences;
import jmri.jmrit.logixng.tools.swing.AbstractLogixNGEditor;
import jmri.jmrit.picker.PickFrame;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogixNGTableAction<E extends NamedBean>
extends AbstractTableAction<E> {
    private static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.logixng.LogixNGBundle");
    static final String PRINT_LINE_NUMBERS_OPTION = "jmri.jmrit.logixng.PrintLineNumbers";
    static final String PRINT_ERROR_HANDLING_OPTION = "jmri.jmrit.logixng.ErrorHandling";
    static final String PRINT_NOT_CONNECTED_OPTION = "jmri.jmrit.logixng.NotConnectedSockets";
    static final String PRINT_LOCAL_VARIABLES_OPTION = "jmri.jmrit.logixng.LocalVariables";
    JTextArea _textContent;
    protected AbstractLogixNGEditor<E> _editor = null;
    boolean _showReminder = false;
    PickFrame _pickTables;
    protected E _curNamedBean = null;
    int conditionalRowNumber = 0;
    protected final Base.PrintTreeSettings _printTreeSettings = new Base.PrintTreeSettings();
    JmriJFrame addLogixNGFrame = null;
    JTextField _systemName = new JTextField(20);
    JTextField _addUserName = new JTextField(20);
    JCheckBox _autoSystemName = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    JLabel _sysNameLabel = new JLabel(String.valueOf(rbx.getString("BeanNameLogixNG")) + " " + Bundle.getMessage("ColumnSystemName") + ":");
    JLabel _userNameLabel = new JLabel(String.valueOf(rbx.getString("BeanNameLogixNG")) + " " + Bundle.getMessage("ColumnUserName") + ":");
    String systemNameAuto = String.valueOf(this.getClassName()) + ".AutoSystemName";
    JButton create;
    private boolean _inEditMode = false;
    private boolean _inCopyMode = false;
    String _logixNGSysName;
    JFileChooser userFileChooser = new JFileChooser(FileUtil.getUserFilesPath());
    private static final Logger log = LoggerFactory.getLogger(AbstractLogixNGTableAction.class);

    public AbstractLogixNGTableAction(String s) {
        super(s);
        super.setEnabled(false);
    }

    protected abstract AbstractLogixNGEditor<E> getEditor(BeanTableFrame<E> var1, BeanTableDataModel<E> var2, String var3);

    @Override
    @Nonnull
    protected abstract Manager<E> getManager();

    protected abstract void enableAll(boolean var1);

    protected abstract void setEnabled(E var1, boolean var2);

    protected abstract boolean isEnabled(E var1);

    protected abstract E createBean(String var1);

    protected abstract E createBean(String var1, String var2);

    protected abstract void deleteBean(E var1);

    protected boolean browseMonoSpace() {
        return false;
    }

    protected abstract String getBeanText(E var1);

    protected abstract String getAddTitleKey();

    protected abstract String getCreateButtonHintKey();

    protected abstract void getListenerRefsIncludingChildren(E var1, List<String> var2);

    protected abstract boolean hasChildren(E var1);

    @Override
    protected void createModel() {
        this.m = new BeanTableDataModel<E>(){
            public static final int ENABLECOL = 2;
            public static final int EDITCOL = 4;
            protected String enabledString = Bundle.getMessage("ColumnHeadEnabled");

            @Override
            public String getColumnName(int col) {
                if (col == 4) {
                    return Bundle.getMessage("ColumnHeadMenu");
                }
                if (col == 2) {
                    return this.enabledString;
                }
                return super.getColumnName(col);
            }

            @Override
            public Class<?> getColumnClass(int col) {
                if (col == 4) {
                    return String.class;
                }
                if (col == 2) {
                    return Boolean.class;
                }
                return super.getColumnClass(col);
            }

            @Override
            public int getPreferredWidth(int col) {
                if (col == 0) {
                    return new JTextField((int)12).getPreferredSize().width;
                }
                if (col == 1) {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                if (col == 4) {
                    return new JTextField((int)12).getPreferredSize().width;
                }
                if (col == 2) {
                    return new JTextField((int)5).getPreferredSize().width;
                }
                return super.getPreferredWidth(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                if (col == 4) {
                    return true;
                }
                if (col == 2) {
                    return true;
                }
                return super.isCellEditable(row, col);
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 4) {
                    return Bundle.getMessage("ButtonSelect");
                }
                if (col == 2) {
                    NamedBean x = (NamedBean)this.getValueAt(row, 0);
                    if (x == null) {
                        return null;
                    }
                    return AbstractLogixNGTableAction.this.isEnabled(x);
                }
                return super.getValueAt(row, col);
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                if (col == 4) {
                    String sName = ((NamedBean)this.getValueAt(row, 0)).getSystemName();
                    if (Bundle.getMessage("ButtonEdit").equals(value)) {
                        AbstractLogixNGTableAction.this.editPressed(sName);
                    } else if (Bundle.getMessage("BrowserButton").equals(value)) {
                        AbstractLogixNGTableAction.this.conditionalRowNumber = row;
                        AbstractLogixNGTableAction.this.browserPressed(sName);
                    } else if (Bundle.getMessage("ButtonCopy").equals(value)) {
                        AbstractLogixNGTableAction.this.copyPressed(sName);
                    } else if (Bundle.getMessage("ButtonDelete").equals(value)) {
                        AbstractLogixNGTableAction.this.deletePressed(sName);
                    }
                } else if (col == 2) {
                    NamedBean x;
                    boolean v = AbstractLogixNGTableAction.this.isEnabled(x = (NamedBean)this.getValueAt(row, 0));
                    AbstractLogixNGTableAction.this.setEnabled(x, !v);
                } else {
                    super.setValueAt(value, row, col);
                }
            }

            @Override
            protected void doDelete(E bean) {
                AbstractLogixNGTableAction.this.deleteBean(bean);
            }

            @Override
            protected boolean matchPropertyName(PropertyChangeEvent e) {
                if (e.getPropertyName().equals(this.enabledString)) {
                    return true;
                }
                return super.matchPropertyName(e);
            }

            @Override
            public Manager<E> getManager() {
                return AbstractLogixNGTableAction.this.getManager();
            }

            @Override
            public E getBySystemName(String name) {
                return AbstractLogixNGTableAction.this.getManager().getBySystemName(name);
            }

            @Override
            public E getByUserName(String name) {
                return AbstractLogixNGTableAction.this.getManager().getByUserName(name);
            }

            @Override
            protected String getMasterClassName() {
                return AbstractLogixNGTableAction.this.getClassName();
            }

            @Override
            public void configureTable(JTable table) {
                table.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
                table.setDefaultRenderer(JComboBox.class, new ValueRenderer());
                table.setDefaultEditor(JComboBox.class, new ValueEditor());
                if (!(this.getManager() instanceof LogixNG_Manager)) {
                    table.getColumnModel().getColumn(2).setMinWidth(0);
                    table.getColumnModel().getColumn(2).setMaxWidth(0);
                }
                super.configureTable(table);
            }

            @Override
            protected void configDeleteColumn(JTable table) {
                JComboBox<String> editCombo = new JComboBox<String>();
                editCombo.addItem(Bundle.getMessage("ButtonSelect"));
                editCombo.addItem(Bundle.getMessage("ButtonEdit"));
                editCombo.addItem(Bundle.getMessage("BrowserButton"));
                editCombo.addItem(Bundle.getMessage("ButtonCopy"));
                editCombo.addItem(Bundle.getMessage("ButtonDelete"));
                TableColumn col = table.getColumnModel().getColumn(4);
                col.setCellEditor(new DefaultCellEditor(editCombo));
            }

            @Override
            public void clickOn(NamedBean t) {
            }

            @Override
            public String getValue(String s) {
                return "";
            }

            @Override
            protected String getBeanType() {
                return rbx.getString("BeanNameLogixNG");
            }
        };
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleLogixNGTable"));
    }

    @Override
    public void setMenuBar(BeanTableFrame f) {
        JMenu menu = new JMenu(Bundle.getMessage("MenuOptions"));
        menu.setMnemonic(79);
        JMenuBar menuBar = f.getJMenuBar();
        int pos = menuBar.getMenuCount() - 1;
        int offset = 1;
        log.debug("setMenuBar number of menu items = " + pos);
        int i = 0;
        while (i <= pos) {
            if (menuBar.getComponent(i) instanceof JMenu && ((JMenu)menuBar.getComponent(i)).getText().equals(Bundle.getMessage("MenuHelp"))) {
                offset = -1;
            }
            ++i;
        }
        if (this instanceof LogixNGTableAction) {
            JMenuItem r = new JMenuItem(Bundle.getMessage("EnableAllLogixNGs"));
            r.addActionListener(e -> this.enableAll(true));
            menu.add(r);
            r = new JMenuItem(Bundle.getMessage("DisableAllLogixNGs"));
            r.addActionListener(e -> this.enableAll(false));
            menu.add(r);
            menuBar.add((Component)menu, pos + offset);
            ++offset;
        }
        menu = new JMenu(Bundle.getMessage("MenuTools"));
        menu.setMnemonic(84);
        JMenuItem item = new JMenuItem(Bundle.getMessage("OpenPickListTables"));
        item.addActionListener(e -> this.openPickListTable());
        menu.add(item);
        menuBar.add((Component)menu, pos + offset);
    }

    private void openPickListTable() {
        if (this._pickTables == null) {
            this._pickTables = new PickFrame(Bundle.getMessage("TitlePickList"));
        } else {
            this._pickTables.setVisible(true);
        }
        this._pickTables.toFront();
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.LogixNGTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        if (!this.checkFlags(null)) {
            return;
        }
        this._showReminder = true;
        if (this.addLogixNGFrame == null) {
            String titleKey = this.getAddTitleKey();
            String buttonHintKey = this.getCreateButtonHintKey();
            JPanel panel5 = this.makeAddFrame(titleKey, "Add");
            this.create = new JButton(Bundle.getMessage("ButtonCreate"));
            panel5.add(this.create);
            this.create.addActionListener(this::createPressed);
            this.create.setToolTipText(Bundle.getMessage(buttonHintKey));
        }
        this.addLogixNGFrame.pack();
        this.addLogixNGFrame.setVisible(true);
        this._autoSystemName.setSelected(false);
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> this._autoSystemName.setSelected(prefMgr.getCheckboxPreferenceState(this.systemNameAuto, true)));
    }

    protected abstract JPanel makeAddFrame(String var1, String var2);

    void autoSystemName() {
        if (this._autoSystemName.isSelected()) {
            this._systemName.setEnabled(false);
            this._sysNameLabel.setEnabled(false);
        } else {
            this._systemName.setEnabled(true);
            this._sysNameLabel.setEnabled(true);
        }
    }

    void cancelAddPressed(ActionEvent e) {
        this.addLogixNGFrame.setVisible(false);
        this.addLogixNGFrame.dispose();
        this.addLogixNGFrame = null;
        this._inCopyMode = false;
        if (this.f != null) {
            this.f.setVisible(true);
        }
    }

    void copyPressed(String sName) {
        if (!this.checkFlags(sName)) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, "Copy is not implemented yet.", "Error", 0);
                AbstractLogixNGTableAction.this._inCopyMode = false;
            }
        };
        log.debug("copyPressed started for {}", (Object)sName);
        SwingUtilities.invokeLater(t);
        this._inCopyMode = true;
        this._logixNGSysName = sName;
    }

    void copyLogixNGPressed(ActionEvent e) {
    }

    boolean checkLogixNGUserName(String uName) {
        E x;
        if (uName != null && uName.trim().length() > 0 && (x = this.getManager().getByUserName(uName)) != null) {
            JOptionPane.showMessageDialog(this.addLogixNGFrame, Bundle.getMessage("LogixNGError3"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    boolean checkLogixNGSysName() {
        String sName = this._systemName.getText();
        if (sName.length() < 1) {
            JOptionPane.showMessageDialog(this.addLogixNGFrame, Bundle.getMessage("LogixNGError8"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        if (sName.length() < 2 || sName.charAt(0) != 'I' || sName.charAt(1) != 'Q') {
            String s = sName;
            sName = "IQ" + s;
        }
        this._systemName.setText(sName);
        return true;
    }

    boolean checkFlags(String sName) {
        E x;
        if (this._inEditMode) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("LogixNGError32", this._curNamedBean.getSystemName()), Bundle.getMessage("ErrorTitle"), 0);
            if (this._editor != null) {
                this._editor.bringToFront();
            }
            return false;
        }
        if (this._inCopyMode) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("LogixNGError31", this._logixNGSysName), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        if (sName != null && (x = this.getManager().getBySystemName(sName)) == null) {
            log.error("No bean with system name: " + sName);
            JOptionPane.showMessageDialog(null, Bundle.getMessage("LogixNGError5"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    void createPressed(ActionEvent e) {
        String sName;
        this._showReminder = true;
        String uName = this._addUserName.getText().trim();
        if (uName.length() == 0) {
            uName = null;
        }
        if (this._autoSystemName.isSelected()) {
            if (!this.checkLogixNGUserName(uName)) {
                return;
            }
            this._curNamedBean = this.createBean(uName);
            if (this._curNamedBean == null) {
                log.error("Failure to create bean with System Name: {}", (Object)"none");
                return;
            }
            sName = this._curNamedBean.getSystemName();
        } else {
            if (!this.checkLogixNGSysName()) {
                return;
            }
            sName = this._systemName.getText();
            Object x = null;
            try {
                x = this.getManager().getBySystemName(sName);
            }
            catch (Exception exception) {
                this.handleCreateException(sName);
                return;
            }
            if (x != null) {
                JOptionPane.showMessageDialog(this.addLogixNGFrame, Bundle.getMessage("LogixNGError1"), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            if (!this.checkLogixNGUserName(uName)) {
                return;
            }
            this._curNamedBean = this.createBean(sName, uName);
            if (this._curNamedBean == null) {
                log.error("Failure to create bean with System Name: {}", (Object)sName);
                return;
            }
        }
        this.cancelAddPressed(null);
        this.editPressed(sName);
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setCheckboxPreferenceState(this.systemNameAuto, this._autoSystemName.isSelected()));
    }

    void handleCreateException(String sysName) {
        JOptionPane.showMessageDialog(this.addLogixNGFrame, Bundle.getMessage("ErrorLogixAddFailed", sysName), Bundle.getMessage("ErrorTitle"), 0);
    }

    void editPressed(String sName) {
        this._curNamedBean = this.getManager().getBySystemName(sName);
        if (!this.checkFlags(sName)) {
            return;
        }
        this._editor = this.getEditor(this.f, this.m, sName);
        if (this._editor == null) {
            return;
        }
        this._inEditMode = true;
        this._editor.addEditorEventListener(data -> {
            String lgxName = sName;
            data.forEach((key, value) -> {
                if (key.equals("Finish")) {
                    this._editor = null;
                    this._inEditMode = false;
                    this.f.setVisible(true);
                } else if (key.equals("Delete")) {
                    this._inEditMode = false;
                    this.deletePressed((String)value);
                } else if (key.equals("chgUname")) {
                    E x = this.getManager().getBySystemName(lgxName);
                    if (x == null) {
                        log.error("Found no logixNG for name {} when changing user name (2)", (Object)lgxName);
                        return;
                    }
                    x.setUserName((String)value);
                    this.m.fireTableDataChanged();
                }
            });
        });
    }

    void showSaveReminder() {
        if (this._showReminder && InstanceManager.getNullableDefault(UserPreferencesManager.class) != null) {
            InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("ReminderSaveString", Bundle.getMessage("MenuItemLogixNGTable")), this.getClassName(), "remindSaveLogix");
        }
    }

    @Override
    public void setMessagePreferencesDetails() {
        HashMap<Integer, String> options = new HashMap<Integer, String>(3);
        options.put(0, Bundle.getMessage("DeleteAsk"));
        options.put(1, Bundle.getMessage("DeleteNever"));
        options.put(2, Bundle.getMessage("DeleteAlways"));
        InstanceManager.getDefault(UserPreferencesManager.class).setMessageItemDetails(this.getClassName(), "delete", Bundle.getMessage("DeleteLogixNG"), options, 0);
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "remindSaveLogixNG", Bundle.getMessage("HideSaveReminder"));
        super.setMessagePreferencesDetails();
    }

    void deletePressed(String sName) {
        if (!this.checkFlags(sName)) {
            return;
        }
        E x = this.getManager().getBySystemName(sName);
        UserPreferencesManager p = InstanceManager.getNullableDefault(UserPreferencesManager.class);
        if (x == null) {
            return;
        }
        StringBuilder message = new StringBuilder();
        try {
            this.getManager().deleteBean(x, "CanDelete");
        }
        catch (PropertyVetoException e2) {
            if (e2.getPropertyChangeEvent().getPropertyName().equals("DoNotDelete")) {
                log.warn(e2.getMessage());
                message.append(Bundle.getMessage("VetoDeleteBean", x.getBeanType(), x.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME), e2.getMessage()));
                JOptionPane.showMessageDialog(null, message.toString(), Bundle.getMessage("QuestionTitle"), 0);
                return;
            }
            message.append(e2.getMessage());
        }
        ArrayList<String> listenerRefs = new ArrayList<String>();
        this.getListenerRefsIncludingChildren(x, listenerRefs);
        int listenerRefsCount = listenerRefs.size();
        log.debug("Delete with {}", (Object)listenerRefsCount);
        if (p != null && p.getMultipleChoiceOption(this.getClassName(), "delete") == 2 && message.toString().isEmpty()) {
            this.deleteBean(x);
        } else {
            String prompt;
            JDialog dialog = new JDialog();
            dialog.setTitle(Bundle.getMessage("QuestionTitle"));
            dialog.setDefaultCloseOperation(2);
            JPanel container = new JPanel();
            container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            container.setLayout(new BoxLayout(container, 1));
            if (listenerRefsCount > 0) {
                prompt = this.hasChildren(x) ? "DeleteWithChildrenPrompt" : "DeletePrompt";
                JLabel question = new JLabel(Bundle.getMessage(prompt, x.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME)));
                question.setAlignmentX(0.5f);
                container.add(question);
                ArrayList<String> listeners = new ArrayList<String>();
                for (String listenerRef : listenerRefs) {
                    if (listeners.contains(listenerRef)) continue;
                    listeners.add(listenerRef);
                }
                message.append("<br>");
                message.append(Bundle.getMessage("ReminderInUse", listenerRefsCount));
                message.append("<ul>");
                for (String listener : listeners) {
                    message.append("<li>");
                    message.append(listener);
                    message.append("</li>");
                }
                message.append("</ul>");
                JEditorPane pane = new JEditorPane();
                pane.setContentType("text/html");
                pane.setText("<html>" + message.toString() + "</html>");
                pane.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(pane);
                container.add(jScrollPane);
            } else {
                prompt = this.hasChildren(x) ? "DeleteWithChildrenPrompt" : "DeletePrompt";
                String msg = MessageFormat.format(Bundle.getMessage(prompt), x.getSystemName());
                JLabel question = new JLabel(msg);
                question.setAlignmentX(0.5f);
                container.add(question);
            }
            JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
            remember.setFont(remember.getFont().deriveFont(10.0f));
            remember.setAlignmentX(0.5f);
            JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
            JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
            JPanel button = new JPanel();
            button.setAlignmentX(0.5f);
            button.add(yesButton);
            button.add(noButton);
            container.add(button);
            noButton.addActionListener(e -> dialog.dispose());
            yesButton.addActionListener(e -> {
                if (remember.isSelected() && p != null) {
                    p.setMultipleChoiceOption(this.getClassName(), "delete", 2);
                }
                this.deleteBean(x);
                dialog.dispose();
            });
            container.add(remember);
            container.setAlignmentX(0.5f);
            container.setAlignmentY(0.5f);
            dialog.getContentPane().add(container);
            dialog.pack();
            dialog.getRootPane().setDefaultButton(noButton);
            noButton.requestFocusInWindow();
            dialog.getRootPane().registerKeyboardAction(e -> {
                dialog.setVisible(false);
                dialog.dispose();
            }, KeyStroke.getKeyStroke(27, 0), 2);
            dialog.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - dialog.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - dialog.getHeight() / 2);
            dialog.setModal(true);
            dialog.setVisible(true);
        }
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleLogixNGTable");
    }

    @Override
    protected String getClassName() {
        return LogixNG_UserPreferences.class.getName();
    }

    void browserPressed(String sName) {
        this._curNamedBean = this.getManager().getBySystemName(sName);
        this.getPrintTreeSettings();
        this.makeBrowserWindow();
    }

    void getPrintTreeSettings() {
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> {
            this._printTreeSettings._printLineNumbers = prefMgr.getSimplePreferenceState(PRINT_LINE_NUMBERS_OPTION);
            this._printTreeSettings._printErrorHandling = prefMgr.getSimplePreferenceState(PRINT_ERROR_HANDLING_OPTION);
            this._printTreeSettings._printNotConnectedSockets = prefMgr.getSimplePreferenceState(PRINT_NOT_CONNECTED_OPTION);
            this._printTreeSettings._printLocalVariables = prefMgr.getSimplePreferenceState(PRINT_LOCAL_VARIABLES_OPTION);
        });
    }

    void updateBrowserText() {
        if (this._textContent != null) {
            this._textContent.setText(this.getBeanText(this._curNamedBean));
        }
    }

    void makeBrowserWindow() {
        JmriJFrame condBrowserFrame = new JmriJFrame(Bundle.getMessage("LogixNG_Browse_Title"), false, true);
        condBrowserFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                AbstractLogixNGTableAction.this._textContent = null;
            }
        });
        Container contentPane = condBrowserFrame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        String tStr = String.valueOf(Bundle.getMessage("BrowserLogixNG")) + " " + this._curNamedBean.getSystemName() + "    " + this._curNamedBean.getUserName() + "    " + (this.isEnabled(this._curNamedBean) ? Bundle.getMessage("BrowserEnabled") : Bundle.getMessage("BrowserDisabled"));
        topPanel.add(new JLabel(tStr));
        contentPane.add((Component)topPanel, "North");
        this._textContent = new JTextArea(this.getBeanText(this._curNamedBean));
        if (this.browseMonoSpace()) {
            this._textContent.setFont(new Font("Monospaced", 0, 12));
        }
        JScrollPane scrollPane = new JScrollPane(this._textContent);
        contentPane.add(scrollPane);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        JButton helpBrowse = new JButton(Bundle.getMessage("MenuHelp"));
        bottomPanel.add((Component)helpBrowse, "West");
        helpBrowse.addActionListener(e -> JOptionPane.showMessageDialog(condBrowserFrame, Bundle.getMessage("LogixNG_Browse_HelpText"), Bundle.getMessage("BrowserHelpTitle"), 1));
        JPanel settingsPanel = this.getSettingsPanel();
        bottomPanel.add((Component)settingsPanel, "Center");
        JButton saveBrowse = new JButton(Bundle.getMessage("BrowserSaveButton"));
        saveBrowse.setToolTipText(Bundle.getMessage("BrowserSaveButtonHint"));
        bottomPanel.add((Component)saveBrowse, "East");
        saveBrowse.addActionListener(e -> this.saveBrowserPressed());
        contentPane.add((Component)bottomPanel, "South");
        condBrowserFrame.pack();
        condBrowserFrame.setVisible(true);
    }

    void saveBrowserPressed() {
        this.userFileChooser.setApproveButtonText(Bundle.getMessage("BrowserSaveDialogApprove"));
        this.userFileChooser.setDialogTitle(Bundle.getMessage("BrowserSaveDialogTitle"));
        this.userFileChooser.rescanCurrentDirectory();
        this.userFileChooser.setSelectedFile(new File(String.valueOf(this._curNamedBean.getSystemName()) + ".txt"));
        int retVal = this.userFileChooser.showSaveDialog(null);
        if (retVal != 0) {
            log.debug("Save browser content stopped, no file selected");
            return;
        }
        File file = this.userFileChooser.getSelectedFile();
        log.debug("Save browser content to '{}'", (Object)file);
        if (file.exists()) {
            Object[] options = new Object[]{Bundle.getMessage("BrowserSaveDuplicateReplace"), Bundle.getMessage("BrowserSaveDuplicateAppend"), Bundle.getMessage("ButtonCancel")};
            int selectedOption = JOptionPane.showOptionDialog(null, Bundle.getMessage("BrowserSaveDuplicatePrompt", file.getName()), Bundle.getMessage("BrowserSaveDuplicateTitle"), -1, 2, null, options, options[0]);
            if (selectedOption == 2 || selectedOption == -1) {
                log.debug("Save browser content stopped, file replace/append cancelled");
                return;
            }
            if (selectedOption == 0) {
                FileUtil.delete(file);
            }
        }
        String tStr = String.valueOf(Bundle.getMessage("BrowserLogixNG")) + " " + this._curNamedBean.getSystemName() + "    " + this._curNamedBean.getUserName() + "    " + (this.isEnabled(this._curNamedBean) ? Bundle.getMessage("BrowserEnabled") : Bundle.getMessage("BrowserDisabled"));
        JTextArea textContent = new JTextArea();
        try {
            FileUtil.appendTextToFile(file, tStr);
            FileUtil.appendTextToFile(file, textContent.getText());
        }
        catch (IOException e) {
            log.error("Unable to write browser content to '{}', exception: '{}'", (Object)file, (Object)e);
        }
    }

    protected JPanel getSettingsPanel() {
        JPanel checkBoxPanel = new JPanel();
        JCheckBox printLineNumbers = new JCheckBox(Bundle.getMessage("LogixNG_Browse_PrintLineNumbers"));
        printLineNumbers.setSelected(this._printTreeSettings._printLineNumbers);
        printLineNumbers.addChangeListener(event -> {
            if (this._printTreeSettings._printLineNumbers != printLineNumbers.isSelected()) {
                this._printTreeSettings._printLineNumbers = printLineNumbers.isSelected();
                InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setSimplePreferenceState(PRINT_LINE_NUMBERS_OPTION, printLineNumbers.isSelected()));
                this.updateBrowserText();
            }
        });
        checkBoxPanel.add(printLineNumbers);
        JCheckBox printErrorHandling = new JCheckBox(Bundle.getMessage("LogixNG_Browse_PrintErrorHandling"));
        printErrorHandling.setSelected(this._printTreeSettings._printErrorHandling);
        printErrorHandling.addChangeListener(event -> {
            if (this._printTreeSettings._printErrorHandling != printErrorHandling.isSelected()) {
                this._printTreeSettings._printErrorHandling = printErrorHandling.isSelected();
                InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setSimplePreferenceState(PRINT_ERROR_HANDLING_OPTION, printErrorHandling.isSelected()));
                this.updateBrowserText();
            }
        });
        checkBoxPanel.add(printErrorHandling);
        JCheckBox printNotConnectedSockets = new JCheckBox(Bundle.getMessage("LogixNG_Browse_PrintNotConnectedSocket"));
        printNotConnectedSockets.setSelected(this._printTreeSettings._printNotConnectedSockets);
        printNotConnectedSockets.addChangeListener(event -> {
            if (this._printTreeSettings._printNotConnectedSockets != printNotConnectedSockets.isSelected()) {
                this._printTreeSettings._printNotConnectedSockets = printNotConnectedSockets.isSelected();
                this.updateBrowserText();
                InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setSimplePreferenceState(PRINT_NOT_CONNECTED_OPTION, printNotConnectedSockets.isSelected()));
            }
        });
        checkBoxPanel.add(printNotConnectedSockets);
        JCheckBox printLocalVariables = new JCheckBox(Bundle.getMessage("LogixNG_Browse_PrintLocalVariables"));
        printLocalVariables.setSelected(this._printTreeSettings._printLocalVariables);
        printLocalVariables.addChangeListener(event -> {
            if (this._printTreeSettings._printLocalVariables != printLocalVariables.isSelected()) {
                this._printTreeSettings._printLocalVariables = printLocalVariables.isSelected();
                this.updateBrowserText();
                InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setSimplePreferenceState(PRINT_LOCAL_VARIABLES_OPTION, printLocalVariables.isSelected()));
            }
        });
        checkBoxPanel.add(printLocalVariables);
        return checkBoxPanel;
    }
}

