/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.automat.monitor;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jmri.jmrit.automat.AbstractAutomaton;
import jmri.jmrit.automat.AutomatSummary;
import jmri.jmrit.automat.monitor.Bundle;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomatTableDataModel
extends AbstractTableModel {
    static final int NAMECOL = 0;
    static final int TURNSCOL = 1;
    static final int KILLCOL = 2;
    static final int NUMCOLUMN = 3;
    AutomatSummary summary = AutomatSummary.instance();
    private ArrayList<AbstractAutomaton> automats = this.summary.getAutomats();
    private final PropertyChangeListener listener = evt -> SwingUtilities.invokeLater(() -> {
        this.automats = this.summary.getAutomats();
        switch (evt.getPropertyName()) {
            case "Insert": {
                this.fireTableDataChanged();
                break;
            }
            case "Remove": {
                this.fireTableDataChanged();
                break;
            }
            case "Count": {
                int row = (Integer)evt.getNewValue();
                if (row >= this.getRowCount()) break;
                this.fireTableCellUpdated(row, 1);
                break;
            }
            default: {
                log.debug("Ignoring unexpected property {}", (Object)evt.getPropertyName());
            }
        }
    });
    private static final Logger log = LoggerFactory.getLogger(AutomatTableDataModel.class);

    public AutomatTableDataModel() {
        this.summary.addPropertyChangeListener(this.listener);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.automats.size();
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColName");
            }
            case 1: {
                return Bundle.getMessage("ColCycles");
            }
            case 2: {
                return Bundle.getMessage("ColKill");
            }
        }
        return Bundle.getMessage("ColUnknown");
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 2: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        AbstractAutomaton automat = this.automats.get(row);
        if (automat != null) {
            switch (col) {
                case 0: {
                    return automat.getName();
                }
                case 1: {
                    return automat.getCount();
                }
                case 2: {
                    return Bundle.getMessage("ButtonKill");
                }
            }
            log.error("internal state inconsistent with table requst for {} {}", (Object)row, (Object)col);
            return null;
        }
        return null;
    }

    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: {
                return new JTextField((int)20).getPreferredSize().width;
            }
            case 1: {
                return new JTextField((int)5).getPreferredSize().width;
            }
            case 2: {
                return new JButton((String)Bundle.getMessage((String)"ButtonKill")).getPreferredSize().width;
            }
        }
        log.warn("Unexpected column in getPreferredWidth: {}", (Object)col);
        return new JTextField((int)5).getPreferredSize().width;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 2) {
            this.summary.get(row).stop();
        }
    }

    public void configureTable(JTable table) {
        table.getTableHeader().setReorderingAllowed(true);
        table.setAutoResizeMode(0);
        int i = 0;
        while (i < table.getColumnCount()) {
            int width = this.getPreferredWidth(i);
            table.getColumnModel().getColumn(i).setPreferredWidth(width);
            ++i;
        }
        table.sizeColumnsToFit(-1);
        this.setColumnToHoldButton(table, 2, new JButton(Bundle.getMessage("ButtonKill")));
    }

    void setColumnToHoldButton(JTable table, int column, JButton sample) {
        TableColumnModel tcm = table.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(column).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(column).setCellEditor(buttonEditor);
        table.setRowHeight(sample.getPreferredSize().height);
        table.getColumnModel().getColumn(column).setPreferredWidth(sample.getPreferredSize().width);
    }

    public synchronized void dispose() {
        AutomatSummary.instance().removePropertyChangeListener(this.listener);
    }
}

