/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.automat;

import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.Sensor;
import jmri.jmrit.automat.AbstractAutomaton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleAutomaton3
extends AbstractAutomaton {
    DccThrottle throttle = null;
    Sensor fwdSensor;
    Sensor revSensor;
    String fwdSensorName = "182";
    String revSensorName = "178";
    int locoNumber = 77;
    boolean locoLong = false;
    boolean moveFwd;
    int fwdState;
    int revState;
    private static final Logger log = LoggerFactory.getLogger(SampleAutomaton3.class);

    @Override
    protected void init() {
        this.fwdSensor = InstanceManager.sensorManagerInstance().provideSensor(this.fwdSensorName);
        this.revSensor = InstanceManager.sensorManagerInstance().provideSensor(this.revSensorName);
        this.throttle = this.getThrottle(this.locoNumber, this.locoLong);
    }

    @Override
    protected boolean handle() {
        this.moveFwd = true;
        this.throttle.setIsForward(this.moveFwd);
        this.throttle.setSpeedSetting(0.5f);
        log.debug("Waiting for state change");
        while ((this.fwdState = this.fwdSensor.getKnownState()) != 2) {
            this.waitSensorChange(this.fwdState, this.fwdSensor);
        }
        log.debug("Forward sensor active");
        this.moveFwd = false;
        this.throttle.setIsForward(this.moveFwd);
        this.throttle.setSpeedSetting(0.33f);
        while ((this.revState = this.revSensor.getKnownState()) != 2) {
            this.waitSensorChange(this.revState, this.revSensor);
        }
        log.debug("Backward sensor active");
        this.moveFwd = true;
        this.throttle.setIsForward(this.moveFwd);
        return true;
    }
}

