/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.automat;

import jmri.InstanceManager;
import jmri.Sensor;
import jmri.Turnout;
import jmri.jmrit.automat.AbstractAutomaton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleAutomaton
extends AbstractAutomaton {
    Turnout turnout;
    Sensor sensor;
    String sensorName = "31";
    String turnoutName = "26";
    int now;
    private static final Logger log = LoggerFactory.getLogger(SampleAutomaton.class);

    @Override
    protected void init() {
        log.info("SampleAutomaton monitors sensor {} and controls turnout {}", (Object)this.sensorName, (Object)this.turnoutName);
        this.turnout = InstanceManager.turnoutManagerInstance().provideTurnout(this.turnoutName);
        this.sensor = InstanceManager.sensorManagerInstance().provideSensor(this.sensorName);
        this.now = this.sensor.getKnownState();
        this.setTurnout(this.now);
    }

    @Override
    protected boolean handle() {
        log.debug("Waiting for state change");
        this.waitSensorChange(this.now, this.sensor);
        this.now = this.sensor.getKnownState();
        log.debug("Found new state: {}", (Object)this.now);
        this.setTurnout(this.now);
        return true;
    }

    void setTurnout(int now) {
        if (now == 2) {
            this.turnout.setCommandedState(4);
        } else {
            this.turnout.setCommandedState(2);
        }
    }
}

