/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.automat;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import jmri.jmrit.automat.AbstractAutomaton;

public class AutomatSummary {
    private static volatile AutomatSummary self = null;
    private final ArrayList<AbstractAutomaton> automats = new ArrayList();
    PropertyChangeSupport prop = new PropertyChangeSupport(this);

    private AutomatSummary() {
    }

    public static AutomatSummary instance() {
        if (self == null) {
            self = new AutomatSummary();
        }
        return self;
    }

    public void removePropertyChangeListener(PropertyChangeListener p) {
        this.prop.removePropertyChangeListener(p);
    }

    public void addPropertyChangeListener(PropertyChangeListener p) {
        this.prop.addPropertyChangeListener(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AbstractAutomaton a) {
        ArrayList<AbstractAutomaton> arrayList = this.automats;
        synchronized (arrayList) {
            this.automats.add(a);
        }
        this.notify("Insert", null, this.indexOf(a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AbstractAutomaton a) {
        int index = this.indexOf(a);
        ArrayList<AbstractAutomaton> arrayList = this.automats;
        synchronized (arrayList) {
            this.automats.remove(a);
        }
        this.notify("Remove", null, index);
    }

    public ArrayList<AbstractAutomaton> getAutomats() {
        return new ArrayList<AbstractAutomaton>(this.automats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        int length;
        ArrayList<AbstractAutomaton> arrayList = this.automats;
        synchronized (arrayList) {
            length = this.automats.size();
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractAutomaton get(int i) {
        AbstractAutomaton retval;
        ArrayList<AbstractAutomaton> arrayList = this.automats;
        synchronized (arrayList) {
            retval = this.automats.get(i);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractAutomaton get(String name) {
        ArrayList<AbstractAutomaton> arrayList = this.automats;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.length()) {
                AbstractAutomaton a = this.automats.get(i);
                if (a.getName().equals(name)) {
                    return a;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(AbstractAutomaton a) {
        int retval;
        ArrayList<AbstractAutomaton> arrayList = this.automats;
        synchronized (arrayList) {
            retval = this.automats.indexOf(a);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop(AbstractAutomaton a) {
        int i;
        ArrayList<AbstractAutomaton> arrayList = this.automats;
        synchronized (arrayList) {
            i = this.automats.indexOf(a);
        }
        this.notify("Count", null, i);
    }

    void notify(String property, Object arg1, Object arg2) {
        Notifier r = new Notifier(property, arg1, arg2);
        SwingUtilities.invokeLater(r);
    }

    class Notifier
    implements Runnable {
        Object arg1;
        Object arg2;
        String property;

        Notifier(String property, Object arg1, Object arg2) {
            this.property = property;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        @Override
        public void run() {
            AutomatSummary.this.prop.firePropertyChange(this.property, this.arg1, this.arg2);
        }
    }
}

