/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.automat;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.BasicRosterEntry;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.NamedBean;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.Sensor;
import jmri.ThrottleListener;
import jmri.ThrottleManager;
import jmri.Turnout;
import jmri.jmrit.automat.AutomatSummary;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.Warrant;
import jmri.util.ThreadingUtil;
import jmri.util.WaitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAutomaton
implements Runnable {
    AutomatSummary summary = AutomatSummary.instance();
    Thread currentThread = null;
    private boolean running = false;
    private String name = null;
    private int count;
    protected boolean promptOnWait = false;
    private boolean waiting = false;
    private boolean inThread = false;
    private final AbstractAutomaton self = this;
    private volatile boolean blockChanged = false;
    private volatile String blockName = null;
    NamedBean[] waitChangePrecheckBeans = null;
    int[] waitChangePrecheckStates = null;
    BlockingQueue<PropertyChangeEvent> waitChangeQueue = new LinkedBlockingQueue<PropertyChangeEvent>();
    private DccThrottle throttle;
    private boolean failedThrottleRequest = false;
    private volatile int cvReturnValue;
    JFrame messageFrame = null;
    String message = null;
    JFrame debugWaitFrame = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractAutomaton.class);

    public AbstractAutomaton() {
        String className = this.getClass().getName();
        int lastdot = className.lastIndexOf(".");
        this.setName(className.substring(lastdot + 1, className.length()));
    }

    public AbstractAutomaton(String name) {
        this.setName(name);
    }

    public void start() {
        if (this.currentThread != null) {
            log.error("Start with currentThread not null!");
        }
        this.currentThread = ThreadingUtil.newThread(this, this.name);
        this.currentThread.start();
        this.summary.register(this);
        this.count = 0;
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * Exception decompiling
     */
    @Override
    @SuppressFBWarnings(value={"IMSE_DONT_CATCH_IMSE"}, justification="get these when stop() issued against thread doing BlockingQueue.take() in waitChange, should remove when stop() reimplemented")
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stop() {
        log.trace("stop() invoked");
        if (this.currentThread == null) {
            log.error("Stop with currentThread null!");
            return;
        }
        Thread stoppingThread = this.currentThread;
        this.currentThread = null;
        try {
            stoppingThread.stop();
        }
        catch (ThreadDeath e) {
            log.error("Exception while in stop(): {}", (Object)e.toString());
        }
        this.done();
        log.trace("stop() completed");
    }

    void done() {
        this.summary.remove(this);
    }

    public int getCount() {
        return this.count;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    void defaultName() {
    }

    protected void init() {
    }

    protected boolean handle() {
        return false;
    }

    public void waitMsec(int milliseconds) {
        long stillToGo;
        long target = System.currentTimeMillis() + (long)milliseconds;
        while ((stillToGo = target - System.currentTimeMillis()) > 0L) {
            try {
                Thread.sleep(stillToGo);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    private final void startWait() {
        this.waiting = true;
    }

    private final void endWait() {
        if (this.promptOnWait) {
            this.debuggingWait();
        }
        this.waiting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wait(int milliseconds) {
        this.startWait();
        AbstractAutomaton abstractAutomaton = this;
        synchronized (abstractAutomaton) {
            try {
                if (milliseconds < 0) {
                    super.wait();
                } else {
                    super.wait(milliseconds);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                log.warn("interrupted in wait");
            }
        }
        this.endWait();
    }

    public int waitSensorChange(int mState, Sensor mSensor) {
        int now;
        if (!this.inThread) {
            log.warn("waitSensorChange invoked from invalid context");
        }
        if (log.isDebugEnabled()) {
            log.debug("waitSensorChange starts: {}", (Object)mSensor.getSystemName());
        }
        PropertyChangeListener l = e -> {
            AbstractAutomaton abstractAutomaton = this.self;
            synchronized (abstractAutomaton) {
                this.self.notifyAll();
            }
        };
        mSensor.addPropertyChangeListener(l);
        while (mState == (now = mSensor.getKnownState())) {
            this.wait(-1);
        }
        mSensor.removePropertyChangeListener(l);
        return now;
    }

    public void waitSensorActive(Sensor mSensor) {
        if (log.isDebugEnabled()) {
            log.debug("waitSensorActive starts");
        }
        this.waitSensorState(mSensor, 2);
    }

    public void waitSensorInactive(Sensor mSensor) {
        if (log.isDebugEnabled()) {
            log.debug("waitSensorInActive starts");
        }
        this.waitSensorState(mSensor, 4);
    }

    public synchronized void waitSensorState(Sensor mSensor, int state) {
        if (!this.inThread) {
            log.warn("waitSensorState invoked from invalid context");
        }
        if (mSensor.getKnownState() == state) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("waitSensorState starts: {} {}", (Object)mSensor.getSystemName(), (Object)state);
        }
        PropertyChangeListener l = e -> {
            AbstractAutomaton abstractAutomaton = this.self;
            synchronized (abstractAutomaton) {
                this.self.notifyAll();
            }
        };
        mSensor.addPropertyChangeListener(l);
        while (state != mSensor.getKnownState()) {
            this.wait(-1);
        }
        mSensor.removePropertyChangeListener(l);
    }

    public void waitSensorInactive(@Nonnull Sensor[] mSensors) {
        log.debug("waitSensorInactive[] starts");
        this.waitSensorState(mSensors, 4);
    }

    public void waitSensorActive(@Nonnull Sensor[] mSensors) {
        log.debug("waitSensorActive[] starts");
        this.waitSensorState(mSensors, 2);
    }

    public synchronized void waitSensorState(@Nonnull Sensor[] mSensors, int state) {
        if (!this.inThread) {
            log.warn("waitSensorState invoked from invalid context");
        }
        log.debug("waitSensorState[] starts");
        if (this.checkForState(mSensors, state)) {
            log.debug("returns immediately");
            return;
        }
        PropertyChangeListener[] listeners = new PropertyChangeListener[mSensors.length];
        int i = 0;
        while (i < mSensors.length) {
            listeners[i] = e -> {
                AbstractAutomaton abstractAutomaton = this.self;
                synchronized (abstractAutomaton) {
                    log.trace("notify waitSensorState[] of property change");
                    this.self.notifyAll();
                }
            };
            mSensors[i].addPropertyChangeListener(listeners[i]);
            ++i;
        }
        while (!this.checkForState(mSensors, state)) {
            this.wait(-1);
        }
        i = 0;
        while (i < mSensors.length) {
            mSensors[i].removePropertyChangeListener(listeners[i]);
            ++i;
        }
    }

    public synchronized void waitWarrantRunState(@Nonnull Warrant warrant, int state) {
        if (!this.inThread) {
            log.warn("waitWarrantRunState invoked from invalid context");
        }
        if (log.isDebugEnabled()) {
            log.debug("waitWarrantRunState {}, {} starts", (Object)warrant.getDisplayName(), (Object)state);
        }
        if (warrant.getRunMode() == state) {
            log.debug("waitWarrantRunState returns immediately");
            return;
        }
        PropertyChangeListener listener = e -> {
            AbstractAutomaton abstractAutomaton = this.self;
            synchronized (abstractAutomaton) {
                log.trace("notify waitWarrantRunState of property change");
                this.self.notifyAll();
            }
        };
        warrant.addPropertyChangeListener(listener);
        while (warrant.getRunMode() != state) {
            this.wait(-1);
        }
        warrant.removePropertyChangeListener(listener);
    }

    public synchronized void waitWarrantBlock(@Nonnull Warrant warrant, @Nonnull String block, boolean occupied) {
        if (!this.inThread) {
            log.warn("waitWarrantBlock invoked from invalid context");
        }
        if (log.isDebugEnabled()) {
            log.debug("waitWarrantBlock {}, {} {} starts", new Object[]{warrant.getDisplayName(), block, occupied});
        }
        if (warrant.getCurrentBlockName().equals(block) == occupied) {
            log.debug("waitWarrantBlock returns immediately");
            return;
        }
        PropertyChangeListener listener = e -> {
            AbstractAutomaton abstractAutomaton = this.self;
            synchronized (abstractAutomaton) {
                log.trace("notify waitWarrantBlock of property change");
                this.self.notifyAll();
            }
        };
        warrant.addPropertyChangeListener(listener);
        while (warrant.getCurrentBlockName().equals(block) != occupied) {
            this.wait(-1);
        }
        warrant.removePropertyChangeListener(listener);
    }

    public synchronized String waitWarrantBlockChange(@Nonnull Warrant warrant) {
        if (!this.inThread) {
            log.warn("waitWarrantBlockChange invoked from invalid context");
        }
        if (log.isDebugEnabled()) {
            log.debug("waitWarrantBlockChange {}", (Object)warrant.getDisplayName());
        }
        if (warrant.getRunMode() != 2) {
            log.debug("waitWarrantBlockChange returns immediately");
            return null;
        }
        this.blockName = null;
        this.blockChanged = false;
        PropertyChangeListener listener = e -> {
            if (e.getPropertyName().equals("blockChange")) {
                this.blockChanged = true;
                this.blockName = ((OBlock)e.getNewValue()).getDisplayName();
            }
            if (e.getPropertyName().equals("runMode") && !Integer.valueOf(2).equals(e.getNewValue())) {
                this.blockName = null;
                this.blockChanged = true;
            }
            AbstractAutomaton abstractAutomaton = this.self;
            synchronized (abstractAutomaton) {
                log.trace("notify waitWarrantBlockChange of property change");
                this.self.notifyAll();
            }
        };
        warrant.addPropertyChangeListener(listener);
        while (!this.blockChanged) {
            this.wait(-1);
        }
        warrant.removePropertyChangeListener(listener);
        return this.blockName;
    }

    public synchronized void waitTurnoutConsistent(@Nonnull Turnout[] mTurnouts) {
        if (!this.inThread) {
            log.warn("waitTurnoutConsistent invoked from invalid context");
        }
        if (log.isDebugEnabled()) {
            log.debug("waitTurnoutConsistent[] starts");
        }
        if (this.checkForConsistent(mTurnouts)) {
            log.debug("returns immediately");
            return;
        }
        PropertyChangeListener[] listeners = new PropertyChangeListener[mTurnouts.length];
        int i = 0;
        while (i < mTurnouts.length) {
            listeners[i] = e -> {
                AbstractAutomaton abstractAutomaton = this.self;
                synchronized (abstractAutomaton) {
                    log.trace("notify waitTurnoutConsistent[] of property change");
                    this.self.notifyAll();
                }
            };
            mTurnouts[i].addPropertyChangeListener(listeners[i]);
            ++i;
        }
        while (!this.checkForConsistent(mTurnouts)) {
            this.wait(-1);
        }
        i = 0;
        while (i < mTurnouts.length) {
            mTurnouts[i].removePropertyChangeListener(listeners[i]);
            ++i;
        }
    }

    public void setTurnouts(@Nonnull Turnout[] closed, @Nonnull Turnout[] thrown) {
        Turnout[] turnouts = new Turnout[closed.length + thrown.length];
        int ti = 0;
        int i = 0;
        while (i < closed.length) {
            turnouts[ti++] = closed[i];
            closed[i].setCommandedState(2);
            ++i;
        }
        i = 0;
        while (i < thrown.length) {
            turnouts[ti++] = thrown[i];
            thrown[i].setCommandedState(4);
            ++i;
        }
        this.waitTurnoutConsistent(turnouts);
    }

    public void waitChange(@Nonnull NamedBean[] mInputs, int maxDelay) {
        int i;
        if (!this.inThread) {
            log.warn("waitChange invoked from invalid context");
        }
        int[] tempState = this.waitChangePrecheckStates;
        boolean recreate = false;
        if (this.waitChangePrecheckBeans != null && this.waitChangePrecheckStates != null) {
            if (this.waitChangePrecheckBeans.length != mInputs.length) {
                log.warn("Precheck ignored because of mismatch in size: before {}, now {}", (Object)this.waitChangePrecheckBeans.length, (Object)mInputs.length);
                recreate = true;
            }
            if (this.waitChangePrecheckBeans.length != this.waitChangePrecheckStates.length) {
                log.error("Precheck data inconsistent because of mismatch in size: {}, {}", (Object)this.waitChangePrecheckBeans.length, (Object)this.waitChangePrecheckStates.length);
                recreate = true;
            }
            if (!recreate) {
                i = 0;
                while (i < mInputs.length) {
                    if (this.waitChangePrecheckBeans[i] != mInputs[i]) {
                        log.warn("Precheck ignored because of mismatch in bean {}", (Object)i);
                        recreate = true;
                        break;
                    }
                    ++i;
                }
            }
        } else {
            recreate = true;
        }
        if (recreate) {
            log.trace("recreate state array");
            tempState = new int[mInputs.length];
            i = 0;
            while (i < mInputs.length) {
                tempState[i] = mInputs[i].getState();
                ++i;
            }
        }
        this.waitChangePrecheckBeans = null;
        this.waitChangePrecheckStates = null;
        int[] initialState = tempState;
        log.debug("waitChange[] starts for {} listeners", (Object)mInputs.length);
        this.waitChangeQueue.clear();
        PropertyChangeListener[] listeners = new PropertyChangeListener[mInputs.length];
        i = 0;
        while (i < mInputs.length) {
            listeners[i] = e -> {
                if (!this.waitChangeQueue.offer(e)) {
                    log.warn("Waiting changes capacity exceeded; not adding {} to queue", (Object)e);
                }
            };
            mInputs[i].addPropertyChangeListener(listeners[i]);
            ++i;
        }
        log.trace("waitChange[] listeners registered");
        ThreadingUtil.runOnLayoutEventually(() -> {
            log.trace("start separate waitChange check");
            int j = 0;
            while (j < mInputs.length) {
                if (initialState[j] != mInputs[j].getState()) {
                    log.trace("notify that input {} changed when initial on-layout check was finally done", (Object)j);
                    PropertyChangeEvent e = new PropertyChangeEvent(mInputs[j], "State", initialState[j], mInputs[j].getState());
                    if (this.waitChangeQueue.offer(e)) break;
                    log.warn("Waiting changes capacity exceeded; not adding {} to queue", (Object)e);
                    break;
                }
                ++j;
            }
            log.trace("end separate waitChange check");
        });
        this.startWait();
        try {
            PropertyChangeEvent prompt = maxDelay < 0 ? this.waitChangeQueue.take() : this.waitChangeQueue.poll(maxDelay, TimeUnit.MILLISECONDS);
            if (prompt != null) {
                log.trace("waitChange continues from {}", prompt.getSource());
            } else {
                log.trace("waitChange continues");
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            log.warn("AbstractAutomaton {} waitChange interrupted", (Object)this.getName());
        }
        i = 0;
        while (i < mInputs.length) {
            mInputs[i].removePropertyChangeListener(listeners[i]);
            ++i;
        }
        log.trace("waitChange[] listeners removed");
        this.endWait();
    }

    public void waitChangePrecheck(NamedBean[] mInputs) {
        this.waitChangePrecheckBeans = new NamedBean[mInputs.length];
        this.waitChangePrecheckStates = new int[mInputs.length];
        int i = 0;
        while (i < mInputs.length) {
            this.waitChangePrecheckBeans[i] = mInputs[i];
            this.waitChangePrecheckStates[i] = mInputs[i].getState();
            ++i;
        }
    }

    public void waitChange(NamedBean[] mInputs) {
        this.waitChange(mInputs, -1);
    }

    public void waitSensorChange(Sensor[] mSensors) {
        this.waitChange(mSensors);
    }

    private boolean checkForState(Sensor[] mSensors, int state) {
        Sensor[] sensorArray = mSensors;
        int n = mSensors.length;
        int n2 = 0;
        while (n2 < n) {
            Sensor mSensor = sensorArray[n2];
            if (mSensor.getKnownState() == state) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean checkForConsistent(Turnout[] mTurnouts) {
        int i = 0;
        while (i < mTurnouts.length) {
            if (!mTurnouts[i].isConsistentState()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public DccThrottle getThrottle(int address, boolean longAddress, int waitSecs) {
        log.debug("requesting DccThrottle for addr {}", (Object)address);
        if (!this.inThread) {
            log.warn("getThrottle invoked from invalid context");
        }
        this.throttle = null;
        ThrottleListener throttleListener = new ThrottleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyThrottleFound(DccThrottle t) {
                AbstractAutomaton.this.throttle = t;
                AbstractAutomaton abstractAutomaton = AbstractAutomaton.this.self;
                synchronized (abstractAutomaton) {
                    AbstractAutomaton.this.self.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
                log.error("Throttle request failed for {} because {}", (Object)address, (Object)reason);
                AbstractAutomaton.this.failedThrottleRequest = true;
                AbstractAutomaton abstractAutomaton = AbstractAutomaton.this.self;
                synchronized (abstractAutomaton) {
                    AbstractAutomaton.this.self.notifyAll();
                }
            }

            @Override
            public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
            }
        };
        boolean ok = InstanceManager.getDefault(ThrottleManager.class).requestThrottle(new DccLocoAddress(address, longAddress), throttleListener, false);
        if (!ok) {
            log.info("Throttle for loco {} not available", (Object)address);
            InstanceManager.getDefault(ThrottleManager.class).cancelThrottleRequest(new DccLocoAddress(address, longAddress), throttleListener);
            return null;
        }
        int waited = 0;
        while (this.throttle == null && !this.failedThrottleRequest && waited <= waitSecs) {
            log.debug("waiting for throttle");
            this.wait(1000);
            ++waited;
            if (this.throttle != null) continue;
            log.warn("Still waiting for throttle {}!", (Object)address);
        }
        if (this.throttle == null) {
            log.debug("canceling request for Throttle {}", (Object)address);
            InstanceManager.getDefault(ThrottleManager.class).cancelThrottleRequest(new DccLocoAddress(address, longAddress), throttleListener);
        }
        return this.throttle;
    }

    public DccThrottle getThrottle(int address, boolean longAddress) {
        return this.getThrottle(address, longAddress, 30);
    }

    public DccThrottle getThrottle(BasicRosterEntry re, int waitSecs) {
        log.debug("requesting DccThrottle for rosterEntry {}", (Object)re.getId());
        if (!this.inThread) {
            log.warn("getThrottle invoked from invalid context");
        }
        this.throttle = null;
        ThrottleListener throttleListener = new ThrottleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyThrottleFound(DccThrottle t) {
                AbstractAutomaton.this.throttle = t;
                AbstractAutomaton abstractAutomaton = AbstractAutomaton.this.self;
                synchronized (abstractAutomaton) {
                    AbstractAutomaton.this.self.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
                log.error("Throttle request failed for {} because {}", (Object)address, (Object)reason);
                AbstractAutomaton.this.failedThrottleRequest = true;
                AbstractAutomaton abstractAutomaton = AbstractAutomaton.this.self;
                synchronized (abstractAutomaton) {
                    AbstractAutomaton.this.self.notifyAll();
                }
            }

            @Override
            public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
            }
        };
        boolean ok = InstanceManager.getDefault(ThrottleManager.class).requestThrottle(re, throttleListener, false);
        if (!ok) {
            log.info("Throttle for loco {} not available", (Object)re.getId());
            InstanceManager.getDefault(ThrottleManager.class).cancelThrottleRequest(re.getDccLocoAddress(), throttleListener);
            return null;
        }
        int waited = 0;
        while (this.throttle == null && !this.failedThrottleRequest && waited <= waitSecs) {
            log.debug("waiting for throttle");
            this.wait(1000);
            ++waited;
            if (this.throttle != null) continue;
            log.warn("Still waiting for throttle {}!", (Object)re.getId());
        }
        if (this.throttle == null) {
            log.debug("canceling request for Throttle {}", (Object)re.getId());
            InstanceManager.getDefault(ThrottleManager.class).cancelThrottleRequest(re.getDccLocoAddress(), throttleListener);
        }
        return this.throttle;
    }

    public DccThrottle getThrottle(BasicRosterEntry re) {
        return this.getThrottle(re, 30);
    }

    public boolean writeServiceModeCV(String CV, int value) {
        Programmer programmer = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer();
        if (programmer == null) {
            log.error("No programmer available as JMRI is currently configured");
            return false;
        }
        try {
            programmer.writeCV(CV, value, (value1, status) -> {
                AbstractAutomaton abstractAutomaton = this.self;
                synchronized (abstractAutomaton) {
                    this.self.notifyAll();
                }
            });
        }
        catch (ProgrammerException e) {
            log.warn("Exception during writeServiceModeCV: {}", (Throwable)e);
            return false;
        }
        this.wait(-1);
        return true;
    }

    public int readServiceModeCV(String CV) {
        Programmer programmer = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer();
        if (programmer == null) {
            log.error("No programmer available as JMRI is currently configured");
            return -1;
        }
        this.cvReturnValue = -1;
        try {
            programmer.readCV(CV, (value, status) -> {
                this.cvReturnValue = value;
                AbstractAutomaton abstractAutomaton = this.self;
                synchronized (abstractAutomaton) {
                    this.self.notifyAll();
                }
            });
        }
        catch (ProgrammerException e) {
            log.warn("Exception during writeServiceModeCV: {}", (Throwable)e);
            return -1;
        }
        this.wait(-1);
        return this.cvReturnValue;
    }

    public boolean writeOpsModeCV(String CV, int value, boolean longAddress, int loco) {
        AddressedProgrammer programmer = InstanceManager.getDefault(AddressedProgrammerManager.class).getAddressedProgrammer(longAddress, loco);
        if (programmer == null) {
            log.error("No programmer available as JMRI is currently configured");
            return false;
        }
        try {
            programmer.writeCV(CV, value, (value1, status) -> {
                AbstractAutomaton abstractAutomaton = this.self;
                synchronized (abstractAutomaton) {
                    this.self.notifyAll();
                }
            });
        }
        catch (ProgrammerException e) {
            log.warn("Exception during writeServiceModeCV: {}", (Throwable)e);
            return false;
        }
        this.wait(-1);
        return true;
    }

    private void debuggingWait() {
        Runnable r = () -> {
            if (this.debugWaitFrame == null) {
                this.debugWaitFrame = new JFrame("Automaton paused");
                JButton b = new JButton("Continue");
                this.debugWaitFrame.getContentPane().add(b);
                b.addActionListener(e -> {
                    AbstractAutomaton abstractAutomaton = this.self;
                    synchronized (abstractAutomaton) {
                        this.self.notifyAll();
                    }
                    this.debugWaitFrame.setVisible(false);
                });
                this.debugWaitFrame.pack();
            }
            this.debugWaitFrame.setVisible(true);
        };
        SwingUtilities.invokeLater(r);
        try {
            super.wait();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted during debugging wait, not expected");
        }
    }

    public class MsgFrame
    implements Runnable {
        String mMessage;
        boolean mPause;
        boolean mShow;
        JFrame mFrame = null;
        JButton mButton;
        JTextArea mArea;

        public void hide() {
            this.mShow = false;
            SwingUtilities.invokeLater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void show(String pMessage, boolean pPause) {
            this.mMessage = pMessage;
            this.mPause = pPause;
            this.mShow = true;
            SwingUtilities.invokeLater(this);
            if (this.mPause) {
                AbstractAutomaton abstractAutomaton = AbstractAutomaton.this.self;
                synchronized (abstractAutomaton) {
                    new WaitHandler(this);
                }
            }
        }

        @Override
        public void run() {
            if (this.mFrame == null) {
                this.mFrame = new JFrame("");
                this.mArea = new JTextArea();
                this.mArea.setEditable(false);
                this.mArea.setLineWrap(false);
                this.mArea.setWrapStyleWord(true);
                this.mButton = new JButton("Continue");
                this.mFrame.getContentPane().setLayout(new BorderLayout());
                this.mFrame.getContentPane().add((Component)this.mArea, "Center");
                this.mFrame.getContentPane().add((Component)this.mButton, "South");
                this.mButton.addActionListener(e -> {
                    AbstractAutomaton abstractAutomaton = AbstractAutomaton.this.self;
                    synchronized (abstractAutomaton) {
                        AbstractAutomaton.this.self.notifyAll();
                    }
                    this.mFrame.setVisible(false);
                });
                this.mFrame.pack();
            }
            if (this.mShow) {
                this.mArea.setText(this.mMessage);
                if (this.mPause) {
                    this.mButton.setVisible(true);
                } else {
                    this.mButton.setVisible(false);
                }
                this.format();
                this.mFrame.pack();
                Dimension screen = this.mFrame.getContentPane().getToolkit().getScreenSize();
                Dimension size = this.mFrame.getSize();
                this.mFrame.setLocation((screen.width - size.width) / 2, (screen.height - size.height) / 2);
                this.mFrame.setVisible(true);
            } else {
                this.mFrame.setVisible(false);
            }
        }

        protected void format() {
        }
    }
}

