/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio.swing;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.vecmath.Vector3f;
import jmri.Audio;
import jmri.AudioException;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.audio.swing.AbstractAudioFrame;
import jmri.jmrit.audio.swing.Bundle;
import jmri.jmrit.beantable.AudioTableAction;

public class AudioSourceFrame
extends AbstractAudioFrame {
    private static int counter = 1;
    private boolean newSource;
    private final Object lock = new Object();
    JLabel assignedBufferLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelAssignedBuffer")));
    JComboBox<String> assignedBuffer = new JComboBox();
    JLabel loopMinLabel = new JLabel(Bundle.getMessage("LabelLoopMin"));
    JSpinner loopMin = new JSpinner();
    JLabel loopMaxLabel = new JLabel(Bundle.getMessage("LabelLoopMax"));
    JSpinner loopMax = new JSpinner();
    JCheckBox loopInfinite = new JCheckBox(Bundle.getMessage("LabelLoopInfinite"));
    AbstractAudioFrame.JPanelVector3f position = new AbstractAudioFrame.JPanelVector3f("", Bundle.getMessage("UnitUnits"));
    JCheckBox positionRelative = new JCheckBox(Bundle.getMessage("LabelPositionRelative"));
    AbstractAudioFrame.JPanelVector3f velocity = new AbstractAudioFrame.JPanelVector3f(Bundle.getMessage("LabelVelocity"), Bundle.getMessage("UnitU/S"));
    AbstractAudioFrame.JPanelSliderf gain = new AbstractAudioFrame.JPanelSliderf(Bundle.getMessage("LabelGain"), Float.valueOf(0.0f), Float.valueOf(1.0f), 5, 4);
    AbstractAudioFrame.JPanelSliderf pitch = new AbstractAudioFrame.JPanelSliderf(Bundle.getMessage("LabelPitch"), Float.valueOf(0.5f), Float.valueOf(2.0f), 6, 5);
    JLabel refDistanceLabel = new JLabel(Bundle.getMessage("LabelReferenceDistance"));
    JSpinner refDistance = new JSpinner();
    JLabel maxDistanceLabel = new JLabel(Bundle.getMessage("LabelMaximumDistance"));
    JSpinner maxDistance = new JSpinner();
    JLabel distancesLabel = new JLabel(Bundle.getMessage("UnitUnits"));
    JLabel rollOffFactorLabel = new JLabel(Bundle.getMessage("LabelRollOffFactor"));
    JSpinner rollOffFactor = new JSpinner();
    JLabel fadeInTimeLabel = new JLabel(Bundle.getMessage("LabelFadeIn"));
    JSpinner fadeInTime = new JSpinner();
    JLabel fadeOutTimeLabel = new JLabel(Bundle.getMessage("LabelFadeOut"));
    JSpinner fadeOutTime = new JSpinner();
    JLabel fadeTimeUnitsLabel = new JLabel(Bundle.getMessage("UnitMS"));
    private static final String PREFIX = "IAS";

    public AudioSourceFrame(String title, AudioTableAction.AudioTableDataModel model) {
        super(title, model);
        this.layoutFrame();
    }

    @Override
    public void layoutFrame() {
        super.layoutFrame();
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(this.assignedBufferLabel);
        p.add(this.assignedBuffer);
        this.main.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LabelLoop")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        p.add(this.loopMinLabel);
        this.loopMin.setPreferredSize(new JTextField(8).getPreferredSize());
        this.loopMin.setModel(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this.loopMin.addChangeListener(e -> this.loopMax.setValue((Integer)this.loopMin.getValue() < (Integer)this.loopMax.getValue() ? this.loopMax.getValue() : this.loopMin.getValue()));
        p.add(this.loopMin);
        p.add(this.loopMaxLabel);
        this.loopMax.setPreferredSize(new JTextField(8).getPreferredSize());
        this.loopMax.setModel(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this.loopMax.addChangeListener(e -> this.loopMin.setValue((Integer)this.loopMax.getValue() < (Integer)this.loopMin.getValue() ? this.loopMax.getValue() : this.loopMin.getValue()));
        p.add(this.loopMax);
        this.loopInfinite.addChangeListener(e -> {
            this.loopMin.setEnabled(!this.loopInfinite.isSelected());
            this.loopMax.setEnabled(!this.loopInfinite.isSelected());
        });
        p.add(this.loopInfinite);
        this.main.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LabelPosition")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        p.add(this.position);
        p.add(this.positionRelative);
        this.main.add(p);
        this.main.add(this.velocity);
        this.main.add(this.gain);
        this.main.add(this.pitch);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LabelDistances")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout());
        p2.add(this.refDistanceLabel);
        this.refDistance.setPreferredSize(new JTextField(8).getPreferredSize());
        this.refDistance.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(9999.99f), Float.valueOf(FLT_PRECISION)));
        this.refDistance.setEditor(new JSpinner.NumberEditor(this.refDistance, "0.00"));
        this.refDistance.addChangeListener(e -> this.maxDistance.setValue(((Float)this.refDistance.getValue()).floatValue() < ((Float)this.maxDistance.getValue()).floatValue() ? this.maxDistance.getValue() : this.refDistance.getValue()));
        p2.add(this.refDistance);
        p2.add(this.maxDistanceLabel);
        this.maxDistance.setPreferredSize(new JTextField(8).getPreferredSize());
        this.maxDistance.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(9999.99f), Float.valueOf(FLT_PRECISION)));
        this.maxDistance.setEditor(new JSpinner.NumberEditor(this.maxDistance, "0.00"));
        this.maxDistance.addChangeListener(e -> this.refDistance.setValue(((Float)this.maxDistance.getValue()).floatValue() < ((Float)this.refDistance.getValue()).floatValue() ? this.maxDistance.getValue() : this.refDistance.getValue()));
        p2.add(this.maxDistance);
        p2.add(this.distancesLabel);
        p.add(p2);
        p2 = new JPanel();
        p2.setLayout(new FlowLayout());
        p2.add(this.rollOffFactorLabel);
        this.rollOffFactor.setPreferredSize(new JTextField(8).getPreferredSize());
        this.rollOffFactor.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(9999.99f), Float.valueOf(FLT_PRECISION)));
        this.rollOffFactor.setEditor(new JSpinner.NumberEditor(this.rollOffFactor, "0.00"));
        p2.add(this.rollOffFactor);
        p.add(p2);
        this.main.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LabelFadeTimes")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        p.add(this.fadeInTimeLabel);
        this.fadeInTime.setPreferredSize(new JTextField(8).getPreferredSize());
        this.fadeInTime.setModel(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        p.add(this.fadeInTime);
        p.add(this.fadeOutTimeLabel);
        this.fadeOutTime.setPreferredSize(new JTextField(8).getPreferredSize());
        this.fadeOutTime.setModel(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        p.add(this.fadeOutTime);
        p.add(this.fadeTimeUnitsLabel);
        this.main.add(p);
        p = new JPanel();
        JButton apply = new JButton(Bundle.getMessage("ButtonApply"));
        p.add(apply);
        apply.addActionListener(e -> this.applyPressed(e));
        JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
        p.add(ok);
        ok.addActionListener(e -> {
            this.applyPressed(e);
            this.frame.dispose();
        });
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        p.add(cancel);
        cancel.addActionListener(e -> this.frame.dispose());
        this.frame.getContentPane().add(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetFrame() {
        Object object = this.lock;
        synchronized (object) {
            this.sysName.setText(PREFIX + AudioSourceFrame.nextCounter());
        }
        this.userName.setText(null);
        this.assignedBuffer.setSelectedIndex(0);
        this.loopInfinite.setSelected(false);
        this.loopMin.setValue(0);
        this.loopMax.setValue(0);
        this.position.setValue(new Vector3f(0.0f, 0.0f, 0.0f));
        this.positionRelative.setSelected(false);
        this.velocity.setValue(new Vector3f(0.0f, 0.0f, 0.0f));
        this.gain.setValue(1.0f);
        this.pitch.setValue(1.0f);
        this.refDistance.setValue(Float.valueOf(1.0f));
        this.maxDistance.setValue(Float.valueOf(9999.99f));
        this.rollOffFactor.setValue(Float.valueOf(1.0f));
        this.fadeInTime.setValue(1000);
        this.fadeOutTime.setValue(1000);
        this.newSource = true;
    }

    @Override
    public void populateFrame(Audio a) {
        if (!(a instanceof AudioSource)) {
            throw new IllegalArgumentException(String.valueOf(a.getSystemName()) + " is not an AudioSource object");
        }
        super.populateFrame(a);
        AudioSource s = (AudioSource)a;
        AudioManager am = InstanceManager.getDefault(AudioManager.class);
        String ab = s.getAssignedBufferName();
        Audio b = am.getAudio(ab);
        if (b != null) {
            this.assignedBuffer.setSelectedItem(b.getUserName() == null ? ab : b.getUserName());
        }
        this.loopInfinite.setSelected(s.getMinLoops() == -1);
        this.loopMin.setValue(this.loopInfinite.isSelected() ? 0 : s.getMinLoops());
        this.loopMax.setValue(this.loopInfinite.isSelected() ? 0 : s.getMaxLoops());
        this.position.setValue(s.getPosition());
        this.positionRelative.setSelected(s.isPositionRelative());
        this.velocity.setValue(s.getVelocity());
        this.gain.setValue(s.getGain());
        this.pitch.setValue(s.getPitch());
        this.refDistance.setValue(Float.valueOf(s.getReferenceDistance()));
        this.maxDistance.setValue(Float.valueOf(s.getMaximumDistance()));
        this.rollOffFactor.setValue(Float.valueOf(s.getRollOffFactor()));
        this.fadeInTime.setValue(s.getFadeIn());
        this.fadeOutTime.setValue(s.getFadeOut());
        this.newSource = false;
    }

    public void updateBufferList() {
        AudioManager am = InstanceManager.getDefault(AudioManager.class);
        this.assignedBuffer.removeAllItems();
        this.assignedBuffer.addItem(Bundle.getMessage("SelectBufferFromList"));
        am.getNamedBeanSet('B').stream().forEach(s -> {
            Audio a = am.getAudio(s.getSystemName());
            if (a != null) {
                String u = a.getUserName();
                if (u != null) {
                    this.assignedBuffer.addItem(u);
                } else {
                    this.assignedBuffer.addItem(s.getSystemName());
                }
            } else {
                this.assignedBuffer.addItem(s.getSystemName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPressed(ActionEvent e) {
        String sName = this.sysName.getText();
        if (this.entryError(sName, PREFIX, "" + counter)) {
            return;
        }
        String user = this.userName.getText();
        if (user.equals("")) {
            user = null;
        }
        try {
            Audio a;
            String sel;
            AudioSource s;
            AudioManager am = InstanceManager.getDefault(AudioManager.class);
            try {
                s = (AudioSource)am.provideAudio(sName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AudioException("Problem creating source");
            }
            if (user != null && this.newSource && am.getByUserName(user) != null) {
                am.deregister(s);
                Object object = this.lock;
                synchronized (object) {
                    AudioSourceFrame.prevCounter();
                }
                throw new AudioException("Duplicate user name - please modify");
            }
            s.setUserName(user);
            if (this.assignedBuffer.getSelectedIndex() > 0 && (sel = (String)this.assignedBuffer.getSelectedItem()) != null && (a = am.getAudio(sel)) != null) {
                s.setAssignedBuffer(a.getSystemName());
            }
            s.setMinLoops(this.loopInfinite.isSelected() ? -1 : (Integer)this.loopMin.getValue());
            s.setMaxLoops(this.loopInfinite.isSelected() ? -1 : (Integer)this.loopMax.getValue());
            s.setPosition(this.position.getValue());
            s.setPositionRelative(this.positionRelative.isSelected());
            s.setVelocity(this.velocity.getValue());
            s.setGain(this.gain.getValue());
            s.setPitch(this.pitch.getValue());
            s.setReferenceDistance(((Float)this.refDistance.getValue()).floatValue());
            s.setMaximumDistance(((Float)this.maxDistance.getValue()).floatValue());
            s.setRollOffFactor(((Float)this.rollOffFactor.getValue()).floatValue());
            s.setFadeIn((Integer)this.fadeInTime.getValue());
            s.setFadeOut((Integer)this.fadeOutTime.getValue());
            this.model.fireTableDataChanged();
        }
        catch (AudioException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), Bundle.getMessage("AudioCreateErrorTitle"), 0);
        }
    }

    private static int nextCounter() {
        return counter++;
    }

    private static void prevCounter() {
        --counter;
    }
}

