/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import javax.vecmath.Vector3f;
import jmri.jmrit.audio.AbstractAudioSource;
import jmri.jmrit.audio.AudioBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullAudioSource
extends AbstractAudioSource {
    private boolean initialised = false;
    private static final Logger log = LoggerFactory.getLogger(NullAudioSource.class);

    public NullAudioSource(String systemName) {
        this(systemName, null);
    }

    public NullAudioSource(String systemName, String userName) {
        super(systemName, userName);
        log.debug("New NullAudioSource: {} ({})", (Object)userName, (Object)systemName);
        this.initialised = this.init();
    }

    @Override
    boolean bindAudioBuffer(AudioBuffer audioBuffer) {
        log.debug("Bind NullAudioSource ({}) to NullAudioBuffer ({})", (Object)this.getSystemName(), (Object)audioBuffer.getSystemName());
        return true;
    }

    private boolean init() {
        return true;
    }

    @Override
    protected void changePosition(Vector3f pos) {
    }

    @Override
    protected void doPlay() {
        log.debug("Play NullAudioSource ({})", (Object)this.getSystemName());
        if (this.initialised && this.isBound()) {
            this.doRewind();
            this.doResume();
        }
    }

    @Override
    protected void doStop() {
        log.debug("Stop NullAudioSource ({})", (Object)this.getSystemName());
        if (this.initialised && this.isBound()) {
            this.doRewind();
        }
    }

    @Override
    protected void doPause() {
        log.debug("Pause NullAudioSource ({})", (Object)this.getSystemName());
        this.setState(16);
    }

    @Override
    protected void doResume() {
        log.debug("Resume NullAudioSource ({})", (Object)this.getSystemName());
        this.setState(17);
    }

    @Override
    protected void doRewind() {
        log.debug("Rewind NullAudioSource ({})", (Object)this.getSystemName());
        this.setState(16);
    }

    @Override
    protected void doFadeIn() {
        log.debug("Fade-in JoalAudioSource ({})", (Object)this.getSystemName());
        if (this.initialised && this.isBound()) {
            this.doPlay();
        }
    }

    @Override
    protected void doFadeOut() {
        log.debug("Fade-out JoalAudioSource ({})", (Object)this.getSystemName());
        if (this.initialised && this.isBound()) {
            this.doStop();
        }
    }

    @Override
    protected void cleanup() {
        log.debug("Cleanup NullAudioSource ({})", (Object)this.getSystemName());
    }

    @Override
    protected void calculateGain() {
    }
}

