/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jmri.jmrit.audio.AbstractAudioBuffer;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSoundAudioBuffer
extends AbstractAudioBuffer {
    private transient AudioFormat audioFormat;
    private byte[] dataStorageBuffer;
    private int freq;
    private long size;
    private transient AudioInputStream audioInputStream;
    private boolean initialised = false;
    private static final Logger log = LoggerFactory.getLogger(JavaSoundAudioBuffer.class);

    public JavaSoundAudioBuffer(String systemName) {
        super(systemName);
        if (log.isDebugEnabled()) {
            log.debug("New JavaSoundAudioBuffer: {}", (Object)systemName);
        }
        this.initialised = this.init();
    }

    public JavaSoundAudioBuffer(String systemName, String userName) {
        super(systemName, userName);
        if (log.isDebugEnabled()) {
            log.debug("New JavaSoundAudioBuffer: {} ({})", (Object)userName, (Object)systemName);
        }
        this.initialised = this.init();
    }

    private boolean init() {
        this.audioFormat = null;
        this.dataStorageBuffer = null;
        this.freq = 0;
        this.size = 0L;
        this.setStartLoopPoint(0L, false);
        this.setEndLoopPoint(0L, false);
        this.setState(32);
        return true;
    }

    protected byte[] getDataStorageBuffer() {
        return this.dataStorageBuffer;
    }

    protected AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    @Override
    protected boolean loadBuffer(InputStream stream) {
        if (!this.initialised) {
            return false;
        }
        this.init();
        try {
            this.audioInputStream = AudioSystem.getAudioInputStream(stream);
        }
        catch (UnsupportedAudioFileException ex) {
            log.error("Unsupported audio file format when loading buffer:{}", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error("Error loading buffer:{}", (Throwable)ex);
            return false;
        }
        return this.processBuffer();
    }

    @Override
    protected boolean loadBuffer() {
        if (!this.initialised) {
            return false;
        }
        this.init();
        File file = new File(FileUtil.getExternalFilename(this.getURL()));
        try {
            this.audioInputStream = AudioSystem.getAudioInputStream(file);
        }
        catch (UnsupportedAudioFileException ex) {
            log.error("Unsupported audio file format when loading buffer:{}", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error("Error loading buffer:{}", (Throwable)ex);
            return false;
        }
        return this.processBuffer();
    }

    private boolean processBuffer() {
        byte[] buffer;
        this.audioFormat = this.audioInputStream.getFormat();
        this.freq = (int)this.audioFormat.getSampleRate();
        int dataSize = this.audioFormat.getChannels() * (int)this.audioInputStream.getFrameLength() * this.audioFormat.getSampleSizeInBits() / 8;
        if (log.isDebugEnabled()) {
            log.debug("Size of JavaSoundAudioBuffer ({}) = {}", (Object)this.getSystemName(), (Object)dataSize);
        }
        if (dataSize > 0) {
            buffer = new byte[dataSize];
            int totalBytesRead = 0;
            try {
                int bytesRead;
                log.debug("Start to load JavaSoundBuffer...");
                while ((bytesRead = this.audioInputStream.read(buffer, totalBytesRead, buffer.length - totalBytesRead)) != -1 && totalBytesRead < buffer.length) {
                    log.debug("read {} bytes of total {}", (Object)bytesRead, (Object)dataSize);
                    totalBytesRead += bytesRead;
                }
            }
            catch (IOException ex) {
                log.error("Error when reading JavaSoundAudioBuffer ({}) {}", (Object)this.getSystemName(), (Object)ex);
                return false;
            }
        } else {
            log.warn("Unable to determine length of JavaSoundAudioBuffer ({})", (Object)this.getSystemName());
            log.warn(" - buffer has not been loaded.");
            return false;
        }
        log.debug("...finished loading JavaSoundBuffer");
        this.dataStorageBuffer = JavaSoundAudioBuffer.convertAudioEndianness(buffer, this.audioFormat.getSampleSizeInBits() == 16);
        this.setStartLoopPoint(0L, false);
        this.setEndLoopPoint(this.audioInputStream.getFrameLength(), false);
        this.generateLoopBuffers(3);
        this.size = this.audioInputStream.getFrameLength();
        this.setState(33);
        if (log.isDebugEnabled()) {
            log.debug("Loaded buffer: {}", (Object)this.getSystemName());
            log.debug(" from file: {}", (Object)this.getURL());
            log.debug(" format: {}, {} Hz", (Object)this.parseFormat(), (Object)this.freq);
            log.debug(" length: {}", (Object)this.audioInputStream.getFrameLength());
        }
        return true;
    }

    @Override
    protected void generateLoopBuffers(int which) {
        if (log.isDebugEnabled()) {
            log.debug("Method generateLoopBuffers() called for JavaSoundAudioBuffer {}", (Object)this.getSystemName());
        }
    }

    @Override
    protected boolean generateStreamingBuffers() {
        if (log.isDebugEnabled()) {
            log.debug("Method generateStreamingBuffers() called for JavaSoundAudioBuffer {}", (Object)this.getSystemName());
        }
        return true;
    }

    @Override
    protected void removeStreamingBuffers() {
        if (log.isDebugEnabled()) {
            log.debug("Method removeStreamingBuffers() called for JavaSoundAudioBuffer {}", (Object)this.getSystemName());
        }
    }

    @Override
    public int getFormat() {
        if (this.audioFormat != null) {
            if (this.audioFormat.getChannels() == 1 && this.audioFormat.getSampleSizeInBits() == 8) {
                return 17;
            }
            if (this.audioFormat.getChannels() == 1 && this.audioFormat.getSampleSizeInBits() == 16) {
                return 18;
            }
            if (this.audioFormat.getChannels() == 2 && this.audioFormat.getSampleSizeInBits() == 8) {
                return 33;
            }
            if (this.audioFormat.getChannels() == 2 && this.audioFormat.getSampleSizeInBits() == 16) {
                return 34;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public long getLength() {
        return this.size;
    }

    @Override
    public int getFrequency() {
        return this.freq;
    }

    private String parseFormat() {
        switch (this.getFormat()) {
            case 17: {
                return "8-bit mono";
            }
            case 18: {
                return "16-bit mono";
            }
            case 33: {
                return "8-bit stereo";
            }
            case 34: {
                return "16-bit stereo";
            }
        }
        return "unknown format";
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] convertAudioEndianness(byte[] audioData, boolean twoByteSamples) {
        block3: {
            out = ByteBuffer.allocate(audioData.length);
            out.order(ByteOrder.nativeOrder());
            in = ByteBuffer.wrap(audioData);
            in.order(ByteOrder.LITTLE_ENDIAN);
            if (!twoByteSamples) ** GOTO lbl17
            outShort = out.asShortBuffer();
            inShort = in.asShortBuffer();
            while (inShort.hasRemaining()) {
                outShort.put(inShort.get());
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                out.put(in.get());
lbl17:
                // 2 sources

                ** while (in.hasRemaining())
            }
        }
        out.rewind();
        if (!out.hasArray()) {
            array = new byte[out.capacity()];
            out.get(array);
            out.clear();
            return array;
        }
        return out.array();
    }

    @Override
    protected void cleanup() {
        if (log.isDebugEnabled()) {
            log.debug("Cleanup JavaSoundAudioBuffer ({})", (Object)this.getSystemName());
        }
    }
}

