/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import jmri.Audio;
import jmri.AudioException;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.jmrit.audio.AudioFactory;
import jmri.jmrit.audio.JavaSoundAudioFactory;
import jmri.jmrit.audio.JoalAudioFactory;
import jmri.jmrit.audio.NullAudioFactory;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractAudioManager;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAudioManager
extends AbstractAudioManager {
    private static int countListeners = 0;
    private static int countSources = 0;
    private static int countBuffers = 0;
    private static AudioFactory activeAudioFactory = null;
    private static boolean initialised = false;
    private final TreeSet<Audio> listeners = new TreeSet(new NamedBeanComparator());
    private final TreeSet<Audio> buffers = new TreeSet(new NamedBeanComparator());
    private final TreeSet<Audio> sources = new TreeSet(new NamedBeanComparator());
    public final Runnable audioShutDownTask = this::cleanup;
    private static final Logger log = LoggerFactory.getLogger(DefaultAudioManager.class);

    public DefaultAudioManager(InternalSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public int getXMLOrder() {
        return 250;
    }

    @Override
    protected synchronized Audio createNewAudio(@Nonnull String systemName, String userName) throws AudioException {
        if (activeAudioFactory == null) {
            log.debug("Initialise in createNewAudio");
            this.init();
        }
        Audio a = null;
        log.debug("sysName: {} userName: {}", (Object)systemName, (Object)userName);
        if (userName != null && this._tuser.containsKey(userName)) {
            throw new AudioException("Duplicate name");
        }
        switch (systemName.charAt(2)) {
            case 'B': {
                if (countBuffers >= 255) {
                    log.error("Maximum number of buffers reached ({}) 255", (Object)countBuffers);
                    throw new AudioException("Maximum number of buffers reached (" + countBuffers + ") " + 255);
                }
                ++countBuffers;
                a = activeAudioFactory.createNewBuffer(systemName, userName);
                this.buffers.add(a);
                break;
            }
            case 'L': {
                if (countListeners >= 1) {
                    log.error("Maximum number of Listeners reached ({}) 1", (Object)countListeners);
                    throw new AudioException("Maximum number of Listeners reached (" + countListeners + ") " + 1);
                }
                ++countListeners;
                a = activeAudioFactory.createNewListener(systemName, userName);
                this.listeners.add(a);
                break;
            }
            case 'S': {
                if (countSources >= 255) {
                    log.error("Maximum number of Sources reached ({}) 255", (Object)countSources);
                    throw new AudioException("Maximum number of Sources reached (" + countSources + ") " + 255);
                }
                ++countSources;
                a = activeAudioFactory.createNewSource(systemName, userName);
                this.sources.add(a);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return a;
    }

    @Override
    @Deprecated
    @Nonnull
    public List<String> getSystemNameList(char subType) {
        SortedSet tempSet = this.getNamedBeanSet();
        ArrayList<String> out = new ArrayList<String>();
        tempSet.stream().forEach(audio -> {
            if (audio.getSubType() == subType) {
                out.add(audio.getSystemName());
            }
        });
        return out;
    }

    @Override
    @Nonnull
    public SortedSet<Audio> getNamedBeanSet(char subType) {
        switch (subType) {
            case 'B': {
                return Collections.unmodifiableSortedSet(this.buffers);
            }
            case 'L': {
                return Collections.unmodifiableSortedSet(this.listeners);
            }
            case 'S': {
                return Collections.unmodifiableSortedSet(this.sources);
            }
        }
        throw new IllegalArgumentException();
    }

    private void createFactory() {
        String className = System.getProperty("jmri.jmrit.audio.DefaultAudioManager.implementation");
        if (className != null) {
            log.debug("Try to initialise {} from property", (Object)className);
            try {
                Class<?> c = Class.forName(className);
                if (AudioFactory.class.isAssignableFrom(c)) {
                    activeAudioFactory = (AudioFactory)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (activeAudioFactory.init()) {
                        return;
                    }
                    log.error("Specified jmri.jmrit.audio.DefaultAudioManager.implementation value {} did not initialize, continuing", (Object)className);
                } else {
                    log.error("Specified jmri.jmrit.audio.DefaultAudioManager.implementation value {} is not a jmri.AudioFactory subclass, continuing", (Object)className);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                log.error("Unable to instantiate AudioFactory class {} with default constructor", (Object)className);
            }
        }
        log.debug("Try to initialise JoalAudioFactory");
        activeAudioFactory = new JoalAudioFactory();
        if (activeAudioFactory.init()) {
            return;
        }
        log.debug("Try to initialise JavaSoundAudioFactory");
        activeAudioFactory = new JavaSoundAudioFactory();
        if (activeAudioFactory.init()) {
            return;
        }
        log.debug("Try to initialise NullAudioFactory");
        activeAudioFactory = new NullAudioFactory();
        activeAudioFactory.init();
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public synchronized void init() {
        if (!initialised) {
            this.createFactory();
            try {
                Audio s = this.createNewAudio("IAL$", "Default Audio Listener");
                this.register(s);
            }
            catch (AudioException ex) {
                log.error("Error creating Default Audio Listener: {}", (Throwable)ex);
            }
            InstanceManager.getDefault(ShutDownManager.class).register(this.audioShutDownTask);
            initialised = true;
            if (log.isDebugEnabled()) {
                log.debug("Initialised AudioFactory type: {}", (Object)activeAudioFactory.getClass().getSimpleName());
            }
        }
    }

    @Override
    public boolean isInitialised() {
        return initialised;
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Synchronized method to ensure correct counter manipulation")
    public synchronized void deregister(@Nonnull Audio s) {
        switch (s.getSubType()) {
            case 'B': {
                this.buffers.remove(s);
                log.debug("Remove buffer; count: {}", (Object)(--countBuffers));
                break;
            }
            case 'S': {
                this.sources.remove(s);
                log.debug("Remove source; count: {}", (Object)(--countSources));
                break;
            }
            case 'L': {
                this.listeners.remove(s);
                log.debug("Remove listener; count: {}", (Object)(--countListeners));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        super.deregister(s);
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="OK to write to static variables to record static library status")
    public void cleanup() {
        log.info("Shutting down active AudioFactory");
        InstanceManager.getDefault(ShutDownManager.class).deregister(this.audioShutDownTask);
        if (activeAudioFactory != null) {
            activeAudioFactory.cleanup();
        }
        countBuffers = 0;
        countSources = 0;
        countListeners = 0;
        initialised = false;
    }

    @Override
    public void dispose() {
        this.buffers.clear();
        this.sources.clear();
        this.listeners.clear();
        super.dispose();
    }

    @Override
    public AudioFactory getActiveAudioFactory() {
        return activeAudioFactory;
    }

    @Deprecated
    public static DefaultAudioManager instance() {
        return InstanceManager.getDefault(DefaultAudioManager.class);
    }
}

