/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import jmri.jmrit.audio.AbstractAudioThread;
import jmri.jmrit.audio.AudioFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioCommandThread
extends AbstractAudioThread {
    private AudioFactory activeAudioFactory;
    private static final Logger log = LoggerFactory.getLogger(AudioCommandThread.class);

    public AudioCommandThread(AudioFactory activeAudioFactory) {
        this.setName("command-" + super.getName());
        this.activeAudioFactory = activeAudioFactory;
        if (log.isDebugEnabled()) {
            log.debug("Created AudioThread for AudioFactory {}", (Object)activeAudioFactory.toString());
        }
    }

    @Override
    public void run() {
        AudioCommandThread.snooze(300000L);
        while (!this.dying()) {
            this.activeAudioFactory.audioCommandQueue(null);
            if (this.dying()) continue;
            AudioCommandThread.snooze(300000L);
        }
        if (log.isDebugEnabled()) {
            log.debug("Clean up thread {}", (Object)this.getName());
        }
        this.cleanup();
    }

    @Override
    protected void cleanup() {
        this.die();
        this.activeAudioFactory = null;
        super.cleanup();
    }
}

