/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.implementation.AbstractAudio;
import jmri.jmrit.audio.AbstractAudioThread;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.audio.AudioCommand;
import jmri.jmrit.audio.AudioFactory;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.audio.AudioThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAudioSource
extends AbstractAudio
implements AudioSource {
    private Vector3f position = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f currentPosition = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f velocity = new Vector3f(0.0f, 0.0f, 0.0f);
    private float gain = 1.0f;
    private float pitch = 1.0f;
    private float referenceDistance = 1.0f;
    private float maximumDistance = 9999.99f;
    private float rollOffFactor = 1.0f;
    private int minLoops = 0;
    private int maxLoops = 0;
    private int numLoops = 0;
    private int fadeInTime = 1000;
    private int fadeOutTime = 1000;
    private float fadeGain = 1.0f;
    private long timeOfLastFadeCheck = 0L;
    private long timeOfLastPositionCheck = 0L;
    private int fading = 0;
    private boolean bound = false;
    private boolean positionRelative = false;
    private boolean queued = false;
    private long offset = 0L;
    private AudioBuffer buffer;
    private LinkedList<AudioBuffer> pendingBufferQueue = new LinkedList();
    private static final AudioFactory activeAudioFactory = InstanceManager.getDefault(AudioManager.class).getActiveAudioFactory();
    private static float metersPerUnit;
    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(AbstractAudioSource.class);
    }

    public AbstractAudioSource(String systemName) {
        super(systemName);
        AudioListener al = activeAudioFactory.getActiveAudioListener();
        if (al != null) {
            AbstractAudioSource.storeMetersPerUnit(al.getMetersPerUnit());
        }
    }

    public AbstractAudioSource(String systemName, String userName) {
        super(systemName, userName);
        AudioListener al = activeAudioFactory.getActiveAudioListener();
        if (al != null) {
            AbstractAudioSource.storeMetersPerUnit(al.getMetersPerUnit());
        }
    }

    private static void storeMetersPerUnit(float newVal) {
        metersPerUnit = newVal;
    }

    public boolean isAudioAlive() {
        return ((AudioThread)((Object)activeAudioFactory.getCommandThread())).alive();
    }

    @Override
    public char getSubType() {
        return 'S';
    }

    @Override
    public boolean queueBuffers(Queue<AudioBuffer> audioBuffers) {
        if (!this.bound) {
            this.pendingBufferQueue = new LinkedList<AudioBuffer>(audioBuffers);
            activeAudioFactory.audioCommandQueue(new AudioCommand(this, 49));
            activeAudioFactory.getCommandThread().interrupt();
            if (log.isDebugEnabled() && audioBuffers.peek() != null) {
                log.debug("Queued Buffer {} to Source {}", (Object)audioBuffers.peek().getSystemName(), (Object)this.getSystemName());
            }
            return true;
        }
        if (audioBuffers.peek() != null) {
            log.error("Attempted to queue buffers {} (etc) to Bound Source {}", (Object)audioBuffers.peek().getSystemName(), (Object)this.getSystemName());
        }
        return false;
    }

    @Override
    public boolean queueBuffer(AudioBuffer audioBuffer) {
        if (!this.bound) {
            this.pendingBufferQueue.add(audioBuffer);
            activeAudioFactory.audioCommandQueue(new AudioCommand(this, 49));
            activeAudioFactory.getCommandThread().interrupt();
            if (log.isDebugEnabled()) {
                log.debug("Queued Buffer {} to Source {}", (Object)audioBuffer.getSystemName(), (Object)this.getSystemName());
            }
            return true;
        }
        log.error("Attempted to queue buffer {} to Bound Source {}", (Object)audioBuffer.getSystemName(), (Object)this.getSystemName());
        return false;
    }

    @Override
    public boolean unqueueBuffers() {
        if (this.bound) {
            log.error("Attempted to unqueue buffers on Bound Source {}", (Object)this.getSystemName());
            return false;
        }
        if (this.queued) {
            activeAudioFactory.audioCommandQueue(new AudioCommand(this, 50));
            activeAudioFactory.getCommandThread().interrupt();
            if (log.isDebugEnabled()) {
                log.debug("Unqueued Processed Buffers on Source {}", (Object)this.getSystemName());
            }
            return true;
        }
        log.debug("Source neither queued nor bound. Not an error. {}", (Object)this.getSystemName());
        return false;
    }

    public Queue<AudioBuffer> getQueuedBuffers() {
        return this.pendingBufferQueue;
    }

    @Override
    public void setAssignedBuffer(AudioBuffer audioBuffer) {
        if (!this.queued) {
            this.buffer = audioBuffer;
            this.stop(false);
            activeAudioFactory.audioCommandQueue(new AudioCommand(this, 48));
            activeAudioFactory.getCommandThread().interrupt();
            if (log.isDebugEnabled()) {
                log.debug("Assigned Buffer {} to Source {}", (Object)audioBuffer.getSystemName(), (Object)this.getSystemName());
            }
        } else {
            log.error("Attempted to assign buffer {} to Queued Source {}", (Object)audioBuffer.getSystemName(), (Object)this.getSystemName());
        }
    }

    @Override
    public void setAssignedBuffer(String bufferSystemName) {
        if (!this.queued) {
            AudioManager am = InstanceManager.getDefault(AudioManager.class);
            Audio a = am.getBySystemName(bufferSystemName);
            if (a != null && a.getSubType() == 'B') {
                this.setAssignedBuffer((AudioBuffer)a);
            } else {
                log.warn("Attempt to assign incorrect object type to buffer - AudioBuffer expected.");
                this.buffer = null;
                this.bound = false;
            }
        } else {
            log.error("Attempted to assign buffer {} to Queued Source {}", (Object)bufferSystemName, (Object)this.getSystemName());
        }
    }

    @Override
    public AudioBuffer getAssignedBuffer() {
        return this.buffer;
    }

    @Override
    public String getAssignedBufferName() {
        return this.buffer != null ? this.buffer.getSystemName() : "[none]";
    }

    @Override
    public void setPosition(Vector3f pos) {
        this.position = pos;
        this.currentPosition = pos;
        this.changePosition(pos);
        if (log.isDebugEnabled()) {
            log.debug("Set position of Source {} to {}", (Object)this.getSystemName(), (Object)pos);
        }
    }

    @Override
    public void setPosition(float x, float y, float z) {
        this.setPosition(new Vector3f(x, y, z));
    }

    @Override
    public void setPosition(float x, float y) {
        this.setPosition(new Vector3f(x, y, 0.0f));
    }

    @Override
    public Vector3f getPosition() {
        return this.position;
    }

    @Override
    public Vector3f getCurrentPosition() {
        return this.currentPosition;
    }

    @Override
    public void setPositionRelative(boolean relative) {
        this.positionRelative = relative;
    }

    @Override
    public boolean isPositionRelative() {
        return this.positionRelative;
    }

    @Override
    public void setVelocity(Vector3f vel) {
        this.velocity = vel;
        if (log.isDebugEnabled()) {
            log.debug("Set velocity of Source {} to {}", (Object)this.getSystemName(), (Object)vel);
        }
    }

    @Override
    public Vector3f getVelocity() {
        return this.velocity;
    }

    protected void calculateCurrentPosition() {
        long currentTime = System.currentTimeMillis();
        float timePassed = currentTime - this.timeOfLastPositionCheck;
        this.timeOfLastPositionCheck = currentTime;
        log.debug("timePassed = {} metersPerUnit = {} source = {} state = {}", new Object[]{Float.valueOf(timePassed), Float.valueOf(metersPerUnit), this.getSystemName(), this.getState()});
        if (this.velocity.length() != 0.0f) {
            this.currentPosition.scaleAdd(timePassed / 1000.0f * metersPerUnit, (Tuple3f)this.velocity, (Tuple3f)this.currentPosition);
            this.changePosition(this.currentPosition);
            if (log.isDebugEnabled()) {
                log.debug("Set current position of Source {} to {}", (Object)this.getSystemName(), (Object)this.currentPosition);
            }
        }
    }

    @Override
    public void resetCurrentPosition() {
        activeAudioFactory.audioCommandQueue(new AudioCommand(this, 73));
        activeAudioFactory.getCommandThread().interrupt();
    }

    protected void doResetCurrentPosition() {
        this.currentPosition = this.position;
    }

    protected abstract void changePosition(Vector3f var1);

    @Override
    public void setGain(float gain) {
        this.gain = gain;
        if (log.isDebugEnabled()) {
            log.debug("Set gain of Source {} to {}", (Object)this.getSystemName(), (Object)Float.valueOf(gain));
        }
    }

    @Override
    public float getGain() {
        return this.gain;
    }

    protected abstract void calculateGain();

    @Override
    public void setPitch(float pitch) {
        if (pitch < 0.5f) {
            pitch = 0.5f;
        }
        if (pitch > 2.0f) {
            pitch = 2.0f;
        }
        this.pitch = pitch;
        if (log.isDebugEnabled()) {
            log.debug("Set pitch of Source {} to {}", (Object)this.getSystemName(), (Object)Float.valueOf(pitch));
        }
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    public void setReferenceDistance(float referenceDistance) {
        if (referenceDistance < 0.0f) {
            referenceDistance = 0.0f;
        }
        this.referenceDistance = referenceDistance;
        if (log.isDebugEnabled()) {
            log.debug("Set reference distance of Source {} to {}", (Object)this.getSystemName(), (Object)Float.valueOf(referenceDistance));
        }
    }

    @Override
    public float getReferenceDistance() {
        return this.referenceDistance;
    }

    @Override
    public void setOffset(long offset) {
        if (offset < 0L) {
            offset = 0L;
        }
        if (offset > this.buffer.getLength()) {
            offset = this.buffer.getLength();
        }
        this.offset = offset;
        if (log.isDebugEnabled()) {
            log.debug("Set byte offset of Source {}to {}", (Object)this.getSystemName(), (Object)offset);
        }
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void setMaximumDistance(float maximumDistance) {
        if (maximumDistance < 0.0f) {
            maximumDistance = 0.0f;
        }
        this.maximumDistance = maximumDistance;
        if (log.isDebugEnabled()) {
            log.debug("Set maximum distance of Source {} to {}", (Object)this.getSystemName(), (Object)Float.valueOf(maximumDistance));
        }
    }

    @Override
    public float getMaximumDistance() {
        return this.maximumDistance;
    }

    @Override
    public void setRollOffFactor(float rollOffFactor) {
        this.rollOffFactor = rollOffFactor;
        if (log.isDebugEnabled()) {
            log.debug("Set roll-off factor of Source {} to {}", (Object)this.getSystemName(), (Object)Float.valueOf(rollOffFactor));
        }
    }

    @Override
    public float getRollOffFactor() {
        return this.rollOffFactor;
    }

    @Override
    public void setLooped(boolean loop) {
        if (loop) {
            this.minLoops = -1;
            this.maxLoops = -1;
        } else {
            this.minLoops = 0;
            this.maxLoops = 0;
        }
        this.calculateLoops();
    }

    @Override
    public boolean isLooped() {
        return this.minLoops != 0 || this.maxLoops != 0;
    }

    @Override
    public void setMinLoops(int loops) {
        if (this.maxLoops < loops) {
            this.maxLoops = loops;
        }
        this.minLoops = loops;
        this.calculateLoops();
    }

    @Override
    public int getMinLoops() {
        return this.minLoops;
    }

    @Override
    public void setMaxLoops(int loops) {
        if (this.minLoops > loops) {
            this.minLoops = loops;
        }
        this.maxLoops = loops;
        this.calculateLoops();
    }

    protected void calculateLoops() {
        this.numLoops = this.minLoops != this.maxLoops ? this.minLoops + ThreadLocalRandom.current().nextInt(this.maxLoops - this.minLoops) : this.minLoops;
    }

    @Override
    public int getMaxLoops() {
        return this.maxLoops;
    }

    @Override
    public int getNumLoops() {
        this.calculateLoops();
        return this.numLoops;
    }

    @Override
    public void setFadeIn(int fadeInTime) {
        this.fadeInTime = fadeInTime;
    }

    @Override
    public int getFadeIn() {
        return this.fadeInTime;
    }

    @Override
    public void setFadeOut(int fadeOutTime) {
        this.fadeOutTime = fadeOutTime;
    }

    @Override
    public int getFadeOut() {
        return this.fadeOutTime;
    }

    protected float getFadeGain() {
        return this.fadeGain;
    }

    protected void calculateFades() {
        long currentTime = System.currentTimeMillis();
        long timePassed = currentTime - this.timeOfLastFadeCheck;
        this.timeOfLastFadeCheck = currentTime;
        switch (this.fading) {
            case 0: {
                this.fadeGain = 1.0f;
                break;
            }
            case 1: {
                this.fadeGain -= AbstractAudioSource.roundDecimal(timePassed) / (float)this.getFadeOut();
                if (this.fadeGain < 0.0f) {
                    this.fadeGain = 0.0f;
                    this.fading = 0;
                }
                if (!log.isDebugEnabled()) break;
                log.debug("Set fade out gain of AudioSource {} to {}", (Object)this.getSystemName(), (Object)Float.valueOf(this.fadeGain));
                break;
            }
            case 2: {
                this.fadeGain += AbstractAudioSource.roundDecimal(timePassed) / (float)this.getFadeIn();
                if (this.fadeGain >= 1.0f) {
                    this.fadeGain = 1.0f;
                    this.fading = 0;
                }
                if (!log.isDebugEnabled()) break;
                log.debug("Set fade in gain of AudioSource {} to {}", (Object)this.getSystemName(), (Object)Float.valueOf(this.fadeGain));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean queueAudioBuffers(Queue<AudioBuffer> audioBuffers) {
        log.debug("Abstract queueAudioBuffers() called.");
        return false;
    }

    public boolean queueAudioBuffer(AudioBuffer audioBuffer) {
        return false;
    }

    public boolean unqueueAudioBuffers() {
        return false;
    }

    @Override
    public int numQueuedBuffers() {
        return 0;
    }

    @Override
    public int numProcessedBuffers() {
        return 0;
    }

    abstract boolean bindAudioBuffer(AudioBuffer var1);

    protected void setBound(boolean bound) {
        this.bound = bound;
    }

    protected void setQueued(boolean queued) {
        this.queued = queued;
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    @Override
    public boolean isQueued() {
        return this.queued;
    }

    @Override
    public void stateChanged(int oldState) {
        int i = this.getState();
        if (i != oldState && i == 17) {
            this.timeOfLastPositionCheck = System.currentTimeMillis();
            AudioSourceMoveThread asmt = new AudioSourceMoveThread(this);
            asmt.start();
        }
    }

    @Override
    public void play() {
        this.fading = 0;
        if (this.getState() != 17) {
            this.setState(17);
            activeAudioFactory.audioCommandQueue(new AudioCommand(this, 64));
            activeAudioFactory.getCommandThread().interrupt();
        }
    }

    protected abstract void doPlay();

    @Override
    public void stop() {
        this.stop(true);
    }

    private void stop(boolean interruptThread) {
        this.fading = 0;
        this.setState(16);
        activeAudioFactory.audioCommandQueue(new AudioCommand(this, 65));
        if (interruptThread) {
            activeAudioFactory.getCommandThread().interrupt();
        }
    }

    protected abstract void doStop();

    @Override
    public void togglePlay() {
        this.fading = 0;
        activeAudioFactory.audioCommandQueue(new AudioCommand(this, 66));
        activeAudioFactory.getCommandThread().interrupt();
    }

    protected void doTogglePlay() {
        if (this.getState() == 17) {
            this.stop();
        } else {
            this.play();
        }
    }

    @Override
    public void pause() {
        this.fading = 0;
        this.setState(16);
        activeAudioFactory.audioCommandQueue(new AudioCommand(this, 67));
        activeAudioFactory.getCommandThread().interrupt();
    }

    protected abstract void doPause();

    @Override
    public void resume() {
        this.fading = 0;
        this.setState(17);
        activeAudioFactory.audioCommandQueue(new AudioCommand(this, 68));
        activeAudioFactory.getCommandThread().interrupt();
    }

    protected abstract void doResume();

    @Override
    public void togglePause() {
        this.fading = 0;
        activeAudioFactory.audioCommandQueue(new AudioCommand(this, 69));
        activeAudioFactory.getCommandThread().interrupt();
    }

    protected void doTogglePause() {
        if (this.getState() == 17) {
            this.pause();
        } else {
            this.resume();
        }
    }

    @Override
    public void rewind() {
        this.fading = 0;
        this.setState(16);
        activeAudioFactory.audioCommandQueue(new AudioCommand(this, 70));
        activeAudioFactory.getCommandThread().interrupt();
    }

    protected abstract void doRewind();

    @Override
    public void fadeIn() {
        if (this.getState() != 17 && this.fading != 2) {
            this.fading = 2;
            this.fadeGain = 0.0f;
            this.timeOfLastFadeCheck = System.currentTimeMillis();
            this.setState(17);
            activeAudioFactory.audioCommandQueue(new AudioCommand(this, 71));
            activeAudioFactory.getCommandThread().interrupt();
        }
    }

    protected abstract void doFadeIn();

    @Override
    public void fadeOut() {
        if (this.getState() == 17 && this.fading != 1) {
            this.fading = 1;
            this.fadeGain = 1.0f;
            this.timeOfLastFadeCheck = System.currentTimeMillis();
            this.setState(17);
            activeAudioFactory.audioCommandQueue(new AudioCommand(this, 72));
            activeAudioFactory.getCommandThread().interrupt();
        }
    }

    protected abstract void doFadeOut();

    protected int getFading() {
        return this.fading;
    }

    @Override
    @Nonnull
    public String getDebugString() {
        return "Pos: " + this.getPosition().toString() + ", bound to: " + this.getAssignedBufferName() + ", loops: " + (this.getMinLoops() == -1 ? "infinite" : (!this.isLooped() ? "none" : "(min=" + this.getMinLoops() + " max=" + this.getMaxLoops() + ")"));
    }

    protected static class AudioSourceFadeThread
    extends AbstractAudioThread {
        private AbstractAudioSource audioSource;
        private final int fadeDirection;

        AudioSourceFadeThread(AbstractAudioSource audioSource) {
            this.setName("fadesrc-" + super.getName());
            this.audioSource = audioSource;
            this.fadeDirection = audioSource.getFading();
            if (log.isDebugEnabled()) {
                log.debug("Created AudioSourceFadeThread for AudioSource {}", (Object)audioSource.getSystemName());
            }
        }

        @Override
        public void run() {
            while (!this.dying()) {
                this.audioSource.calculateFades();
                this.audioSource.calculateGain();
                if (this.audioSource.getFading() == 0) {
                    this.die();
                }
                AudioSourceFadeThread.snooze(20L);
            }
            this.audioSource.calculateFades();
            if (this.fadeDirection == 1) {
                this.audioSource.doStop();
            } else {
                this.audioSource.calculateGain();
            }
            if (log.isDebugEnabled()) {
                log.debug("Clean up thread {}", (Object)this.getName());
            }
            this.cleanup();
        }

        @Override
        protected void cleanup() {
            this.die();
            this.audioSource = null;
            super.cleanup();
        }
    }

    protected static class AudioSourceMoveThread
    extends AbstractAudioThread {
        private AbstractAudioSource audioSource;

        AudioSourceMoveThread(AbstractAudioSource audioSource) {
            this.setName("movesrc-" + super.getName());
            this.audioSource = audioSource;
            if (log.isDebugEnabled()) {
                log.debug("Created AudioSourceMoveThread for AudioSource {}", (Object)audioSource.getSystemName());
            }
        }

        @Override
        public void run() {
            while (!this.dying()) {
                this.audioSource.calculateCurrentPosition();
                if (this.audioSource.getState() != 17) {
                    this.die();
                }
                AudioSourceMoveThread.snooze(100L);
            }
            if (log.isDebugEnabled()) {
                log.debug("Clean up thread {}", (Object)this.getName());
            }
            this.cleanup();
        }

        @Override
        protected void cleanup() {
            this.die();
            this.audioSource = null;
            super.cleanup();
        }
    }
}

