/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.implementation.AbstractAudio;
import jmri.jmrit.audio.AbstractAudioThread;
import jmri.jmrit.audio.AudioCommand;
import jmri.jmrit.audio.AudioFactory;
import jmri.jmrit.audio.AudioListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAudioListener
extends AbstractAudio
implements AudioListener {
    private Vector3f position = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f currentPosition = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f velocity = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f orientationAt = new Vector3f(0.0f, 1.0f, 0.0f);
    private Vector3f orientationUp = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f currentOriAt = new Vector3f(0.0f, 1.0f, 0.0f);
    private Vector3f currentOriUp = new Vector3f(0.0f, 0.0f, 1.0f);
    private float gain = 1.0f;
    private float metersPerUnit = 1.0f;
    private long timeOfLastPositionCheck = 0L;
    private static final AudioFactory activeAudioFactory = InstanceManager.getDefault(AudioManager.class).getActiveAudioFactory();
    private static final Logger log = LoggerFactory.getLogger(AbstractAudioListener.class);

    public AbstractAudioListener(String systemName) {
        super(systemName);
        this.setState(48);
    }

    public AbstractAudioListener(String systemName, String userName) {
        super(systemName, userName);
        this.setState(48);
    }

    @Override
    public char getSubType() {
        return 'L';
    }

    @Override
    public void setPosition(Vector3f pos) {
        this.position = pos;
        this.changePosition(pos);
        if (log.isDebugEnabled()) {
            log.debug("Set position of Listener {} to {}", (Object)this.getSystemName(), (Object)pos);
        }
    }

    @Override
    public void setPosition(float x, float y, float z) {
        this.setPosition(new Vector3f(x, y, z));
    }

    @Override
    public void setPosition(float x, float y) {
        this.setPosition(new Vector3f(x, y, 0.0f));
    }

    @Override
    public Vector3f getPosition() {
        return this.position;
    }

    @Override
    public Vector3f getCurrentPosition() {
        return this.currentPosition;
    }

    @Override
    public void setVelocity(Vector3f vel) {
        this.velocity = vel;
        this.setState(vel.length() != 0.0f ? 49 : 48);
        if (log.isDebugEnabled()) {
            log.debug("Set velocity of Listener {} to {}", (Object)this.getSystemName(), (Object)vel);
        }
    }

    @Override
    public Vector3f getVelocity() {
        return this.velocity;
    }

    protected void calculateCurrentPosition() {
        long currentTime = System.currentTimeMillis();
        long timePassed = (currentTime - this.timeOfLastPositionCheck) / 1000L;
        this.timeOfLastPositionCheck = currentTime;
        if (this.velocity.length() != 0.0f) {
            this.currentPosition.scaleAdd((float)timePassed * this.metersPerUnit, (Tuple3f)this.velocity, (Tuple3f)this.currentPosition);
            this.currentOriAt.scaleAdd((float)timePassed * this.metersPerUnit, (Tuple3f)this.velocity, (Tuple3f)this.currentOriAt);
            this.currentOriUp.scaleAdd((float)timePassed * this.metersPerUnit, (Tuple3f)this.velocity, (Tuple3f)this.currentOriUp);
        }
    }

    @Override
    public void resetCurrentPosition() {
        activeAudioFactory.audioCommandQueue(new AudioCommand(this, 73));
        activeAudioFactory.getCommandThread().interrupt();
    }

    protected void doResetCurrentPosition() {
        this.currentPosition = this.position;
    }

    protected abstract void changePosition(Vector3f var1);

    @Override
    public void setOrientation(Vector3f at, Vector3f up) {
        this.orientationAt = at;
        this.orientationUp = up;
        if (log.isDebugEnabled()) {
            log.debug("Set orientation of Listener {} to (at) {} (up) {}", new Object[]{this.getSystemName(), at, up});
        }
    }

    @Override
    public Vector3f getOrientation(int which) {
        Vector3f orientation = null;
        switch (which) {
            case 1: {
                orientation = this.orientationAt;
                break;
            }
            case 2: {
                orientation = this.orientationUp;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return orientation;
    }

    @Override
    public Vector3f getCurrentOrientation(int which) {
        Vector3f orientation = null;
        switch (which) {
            case 1: {
                orientation = this.currentOriAt;
                break;
            }
            case 2: {
                orientation = this.currentOriUp;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return orientation;
    }

    @Override
    public void setGain(float gain) {
        this.gain = gain;
        if (log.isDebugEnabled()) {
            log.debug("Set gain of Listener {} to {}", (Object)this.getSystemName(), (Object)Float.valueOf(gain));
        }
    }

    @Override
    public float getGain() {
        return this.gain;
    }

    @Override
    public void setMetersPerUnit(float metersPerUnit) {
        this.metersPerUnit = metersPerUnit;
        if (log.isDebugEnabled()) {
            log.debug("Set Meters per unit of Listener {} to {}", (Object)this.getSystemName(), (Object)Float.valueOf(metersPerUnit));
        }
    }

    @Override
    public float getMetersPerUnit() {
        return this.metersPerUnit;
    }

    @Override
    public void stateChanged(int oldState) {
    }

    protected static class AudioListenerMoveThread
    extends AbstractAudioThread {
        private AbstractAudioListener audioListener;

        AudioListenerMoveThread(AbstractAudioListener audioListener) {
            this.setName("movelis-" + super.getName());
            this.audioListener = audioListener;
            if (log.isDebugEnabled()) {
                log.debug("Created AudioListenerMoveThread for AudioListener {}", (Object)audioListener.getSystemName());
            }
        }

        @Override
        public void run() {
            while (!this.dying()) {
                this.audioListener.calculateCurrentPosition();
                if (this.audioListener.getState() != 49) {
                    this.die();
                }
                AudioListenerMoveThread.snooze(20L);
            }
            if (log.isDebugEnabled()) {
                log.debug("Clean up thread {}", (Object)this.getName());
            }
            this.cleanup();
        }

        @Override
        protected void cleanup() {
            this.die();
            this.audioListener = null;
            super.cleanup();
        }
    }
}

