/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedList;
import java.util.List;
import jmri.Audio;
import jmri.jmrit.audio.AbstractAudioBuffer;
import jmri.jmrit.audio.AbstractAudioListener;
import jmri.jmrit.audio.AbstractAudioSource;
import jmri.jmrit.audio.AbstractAudioThread;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.audio.AudioCommand;
import jmri.jmrit.audio.AudioCommandThread;
import jmri.jmrit.audio.AudioFactory;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.audio.AudioSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAudioFactory
implements AudioFactory {
    private static List<AudioCommand> commandQueue = null;
    private static boolean initialised = false;
    private static boolean distanceAttenuated = true;
    private static AbstractAudioThread audioCommandThread = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractAudioFactory.class);

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public boolean init() {
        if (initialised) {
            log.debug("Already initialised");
            return true;
        }
        commandQueue = new LinkedList<AudioCommand>();
        audioCommandThread = new AudioCommandThread(this);
        audioCommandThread.start();
        initialised = true;
        return true;
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="OK to write to static variables to record static library status")
    public void cleanup() {
        boolean dieException = false;
        try {
            audioCommandThread.die();
            audioCommandThread.interrupt();
        }
        catch (Exception exception) {
            dieException = true;
        }
        if (!dieException) {
            int i = 0;
            while (i < 50) {
                if (!audioCommandThread.alive()) break;
                AbstractAudioThread.snooze(100L);
                ++i;
            }
        }
        initialised = false;
    }

    @Override
    public synchronized boolean audioCommandQueue(AudioCommand queueAudioCommand) {
        if (queueAudioCommand == null) {
            log.debug("Processing command queue");
            while (commandQueue != null && commandQueue.size() > 0) {
                Audio audio;
                AudioCommand audioCommand = commandQueue.remove(0);
                if (audioCommand == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Process command: {} ({} remaining)", (Object)audioCommand.toString(), (Object)commandQueue.size());
                }
                if ((audio = audioCommand.getAudio()) instanceof AudioSource) {
                    AbstractAudioSource audioSource = (AbstractAudioSource)audio;
                    switch (audioCommand.getCommand()) {
                        case 48: {
                            audioSource.setBound(audioSource.bindAudioBuffer(audioSource.getAssignedBuffer()));
                            break;
                        }
                        case 49: {
                            audioSource.setQueued(audioSource.queueAudioBuffers(audioSource.getQueuedBuffers()));
                            break;
                        }
                        case 50: {
                            audioSource.setQueued(audioSource.unqueueAudioBuffers());
                            break;
                        }
                        case 64: {
                            audioSource.doPlay();
                            break;
                        }
                        case 65: {
                            audioSource.doStop();
                            break;
                        }
                        case 66: {
                            audioSource.doTogglePlay();
                            break;
                        }
                        case 67: {
                            audioSource.doPause();
                            break;
                        }
                        case 68: {
                            audioSource.doResume();
                            break;
                        }
                        case 69: {
                            audioSource.doTogglePause();
                            break;
                        }
                        case 70: {
                            audioSource.doRewind();
                            break;
                        }
                        case 71: {
                            audioSource.doFadeIn();
                            break;
                        }
                        case 72: {
                            audioSource.doFadeOut();
                            break;
                        }
                        case 73: {
                            audioSource.doResetCurrentPosition();
                            break;
                        }
                        default: {
                            log.warn("Command {} not suitable for AudioSource ({})", (Object)audioCommand.toString(), (Object)audioSource.getSystemName());
                            break;
                        }
                    }
                    continue;
                }
                if (audio instanceof AudioBuffer) {
                    AbstractAudioBuffer audioBuffer = (AbstractAudioBuffer)audio;
                    switch (audioCommand.getCommand()) {
                        case 32: {
                            audioBuffer.loadBuffer();
                            break;
                        }
                        default: {
                            log.warn("Command {} not suitable for AudioBuffer ({})", (Object)audioCommand.toString(), (Object)audioBuffer.getSystemName());
                            break;
                        }
                    }
                    continue;
                }
                if (!(audio instanceof AudioListener)) continue;
                AbstractAudioListener audioListener = (AbstractAudioListener)audio;
                switch (audioCommand.getCommand()) {
                    case 73: {
                        audioListener.doResetCurrentPosition();
                        break;
                    }
                    default: {
                        log.warn("Command {} not suitable for AudioListener ({})", (Object)audioCommand.toString(), (Object)audioListener.getSystemName());
                    }
                }
            }
            return commandQueue != null && commandQueue.size() > 0;
        }
        if (commandQueue == null) {
            log.warn("Audio commandQueue not initialised");
            return false;
        }
        commandQueue.add(queueAudioCommand);
        if (log.isDebugEnabled()) {
            log.debug("New audio command: {}", (Object)queueAudioCommand.toString());
        }
        return true;
    }

    @Override
    public Thread getCommandThread() {
        return audioCommandThread;
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void setDistanceAttenuated(boolean attenuated) {
        distanceAttenuated = attenuated;
    }

    @Override
    public boolean isDistanceAttenuated() {
        return distanceAttenuated;
    }
}

