/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jmri.jmrit.Bundle;
import jmri.jmrit.XmlFile;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlFileValidateAction
extends JmriAbstractAction {
    private JFileChooser fci;
    private Component _who;
    private XmlFile xmlfile = new XmlFile(){};
    private static final Logger log = LoggerFactory.getLogger(XmlFileValidateAction.class);

    public XmlFileValidateAction(String s, Component who) {
        super(s);
        this._who = who;
    }

    public XmlFileValidateAction(String s, WindowInterface wi) {
        this(s, wi != null ? wi.getFrame() : null);
    }

    public XmlFileValidateAction() {
        super(Bundle.getMessage("XmlFileValidateAction"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.fci == null) {
            this.fci = XmlFile.userFileChooser("XML files", "xml");
        }
        this.fci.rescanCurrentDirectory();
        int retVal = this.fci.showOpenDialog(this._who);
        if (retVal == 0) {
            this.processFile(this.fci.getSelectedFile());
        } else {
            log.debug("XmlFileValidateAction cancelled in open dialog");
        }
    }

    protected void processFile(File file) {
        log.debug("located file \"{}\" for XML processing", (Object)file);
        try {
            this.xmlfile.setValidate(XmlFile.Validate.CheckDtdThenSchema);
            this.readFile(file);
        }
        catch (Exception ex) {
            this.showFailResults(this._who, file.getName(), ex.getMessage());
            return;
        }
        this.showOkResults(this._who, Bundle.getMessage("ValidatedOk", file.getName()));
        log.debug("parsing xml complete");
    }

    protected void showOkResults(Component who, String text) {
        JOptionPane.showMessageDialog(who, text);
    }

    protected void showFailResults(Component who, String fileName, String text) {
        JOptionPane.showMessageDialog(who, String.format("<html><body style='width: %1spx'>%1s<br><br>%1s</body></html>", 300, Bundle.getMessage("ValidationErrorInFile", fileName), text));
    }

    void readFile(File file) throws JDOMException, IOException {
        this.xmlfile.rootFromFile(file);
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

