/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit;

import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jmri.jmrit.Bundle;
import jmri.jmrit.roster.Roster;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlFileLocationAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(XmlFileLocationAction.class);

    @Override
    public void actionPerformed(ActionEvent ev) {
        JmriJFrame frame = new JmriJFrame();
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        pane.add(buttons);
        JButton b = new JButton(Bundle.getMessage("ButtonOpenLocX", Bundle.getMessage("ButtonUserFilesLoc")));
        buttons.add(b);
        b.addActionListener(event -> {
            try {
                Desktop.getDesktop().open(new File(FileUtil.getUserFilesPath()));
            }
            catch (IOException | UnsupportedOperationException e) {
                log.error("Error when opening user files location: ", (Throwable)e);
            }
        });
        b = new JButton(Bundle.getMessage("ButtonOpenLocX", Bundle.getMessage("ButtonRosterLoc")));
        buttons.add(b);
        b.addActionListener(event -> {
            try {
                Desktop.getDesktop().open(new File(Roster.getDefault().getRosterLocation()));
            }
            catch (IOException | UnsupportedOperationException e) {
                log.error("Error when opening roster location: ", (Throwable)e);
            }
        });
        b = new JButton(Bundle.getMessage("ButtonOpenLocX", Bundle.getMessage("ButtonProfileLoc")));
        buttons.add(b);
        b.addActionListener(event -> {
            try {
                Desktop.getDesktop().open(new File(FileUtil.getProfilePath()));
            }
            catch (IOException | UnsupportedOperationException e) {
                log.error("Error when opening profile location: ", (Throwable)e);
            }
        });
        b = new JButton(Bundle.getMessage("ButtonOpenLocX", Bundle.getMessage("ButtonSettingsLoc")));
        buttons.add(b);
        b.addActionListener(event -> {
            try {
                Desktop.getDesktop().open(new File(FileUtil.getPreferencesPath()));
            }
            catch (IOException | UnsupportedOperationException e) {
                log.error("Error when opening settings location: ", (Throwable)e);
            }
        });
        b = new JButton(Bundle.getMessage("ButtonOpenLocX", Bundle.getMessage("ButtonScriptsLoc")));
        buttons.add(b);
        b.addActionListener(event -> {
            try {
                Desktop.getDesktop().open(new File(FileUtil.getScriptsPath()));
            }
            catch (IOException | UnsupportedOperationException e) {
                log.error("Error when opening scripts location: ", (Throwable)e);
            }
        });
        b = new JButton(Bundle.getMessage("ButtonOpenLocX", Bundle.getMessage("ButtonProgramLoc")));
        buttons.add(b);
        b.addActionListener(event -> {
            try {
                Desktop.getDesktop().open(new File(System.getProperty("user.dir")));
            }
            catch (IOException | UnsupportedOperationException e) {
                log.error("Error when opening program location: ", (Throwable)e);
            }
        });
        b = new JButton(Bundle.getMessage("ButtonOpenLocX", Bundle.getMessage("ButtonLogFilesLoc")));
        buttons.add(b);
        b.addActionListener(event -> {
            try {
                Desktop.getDesktop().open(new File(System.getProperty("jmri.log.path")));
            }
            catch (IOException | UnsupportedOperationException e) {
                log.error("Error when opening log files location: ", (Throwable)e);
            }
        });
        JScrollPane scroll = new JScrollPane(pane);
        frame.getContentPane().add(scroll);
        JTextArea textPane = new JTextArea();
        textPane.setEditable(false);
        pane.add(textPane);
        textPane.append(XmlFileLocationAction.getLocationsReport());
        ((Window)frame).pack();
        frame.setVisible(true);
    }

    public static String getLocationsReport() {
        String logDir = System.getProperty("jmri.log.path");
        String configName = System.getProperty("org.jmri.Apps.configFilename");
        if (!new File(configName).isAbsolute()) {
            configName = String.valueOf(FileUtil.getProfilePath()) + configName;
        }
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(Bundle.getMessage("ButtonUserFilesLoc")) + ": ").append(FileUtil.getUserFilesPath()).append("\n");
        s.append(String.valueOf(Bundle.getMessage("ButtonRosterLoc")) + ": ").append(Roster.getDefault().getRosterLocation()).append("\n");
        s.append(String.valueOf(Bundle.getMessage("ButtonProfileLoc")) + ": ").append(FileUtil.getProfilePath()).append("\n");
        s.append(String.valueOf(Bundle.getMessage("ButtonSettingsLoc")) + ": ").append(FileUtil.getPreferencesPath()).append("\n");
        s.append(Bundle.getMessage("CurrentConfig")).append(configName).append("\n");
        s.append(String.valueOf(Bundle.getMessage("ButtonScriptsLoc")) + ": ").append(FileUtil.getScriptsPath()).append("\n");
        s.append(String.valueOf(Bundle.getMessage("ButtonProgramLoc")) + ": ").append(System.getProperty("user.dir")).append("\n");
        s.append(Bundle.getMessage("TempFilesLoc")).append(System.getProperty("java.io.tmpdir")).append("\n");
        s.append(String.valueOf(Bundle.getMessage("ButtonLogFilesLoc")) + ": ").append(logDir).append("\n");
        File dir = new File(logDir);
        String[] files = dir.list();
        if (files != null) {
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (file.contains(".log")) {
                    s.append("  ").append(logDir).append(file).append("\n");
                }
                ++n2;
            }
        }
        return s.toString();
    }
}

