/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jmri.jmrit.XmlFile;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlFileCheckAction
extends JmriAbstractAction {
    JFileChooser fci;
    Component _who;
    XmlFile xmlfile = new XmlFile(){};
    private static final Logger log = LoggerFactory.getLogger(XmlFileCheckAction.class);

    public XmlFileCheckAction(String s, Component who) {
        super(s);
        this._who = who;
    }

    public XmlFileCheckAction(String s, WindowInterface wi) {
        this(s, wi != null ? wi.getFrame() : null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.fci == null) {
            this.fci = XmlFile.userFileChooser("XML files", "xml");
        }
        this.fci.rescanCurrentDirectory();
        int retVal = this.fci.showOpenDialog(this._who);
        if (retVal == 0) {
            File file = this.fci.getSelectedFile();
            log.debug("located file {} for XML processing", (Object)file);
            try {
                this.xmlfile.setValidate(XmlFile.Validate.None);
                this.readFile(file);
                JOptionPane.showMessageDialog(this._who, "OK");
            }
            catch (IOException | JDOMException ex) {
                JOptionPane.showMessageDialog(this._who, "Error: " + ex);
            }
            log.debug("parsing complete");
        } else {
            log.info("XmlFileCheckAction cancelled in open dialog");
        }
    }

    void readFile(File file) throws JDOMException, IOException {
        this.xmlfile.rootFromFile(file);
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

