/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.swing.JFileChooser;
import jmri.Version;
import jmri.util.FileUtil;
import jmri.util.JmriLocalEntityResolver;
import jmri.util.NoArchiveFileFilter;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.XSLTransformException;
import org.jdom2.transform.XSLTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public abstract class XmlFile {
    public static final String xsltLocation = "/xml/XSLT/";
    private static Validate defaultValidate = Validate.None;
    private Validate validate = defaultValidate;
    public static String defaultDtdLocation = "/xml/DTD/";
    public String dtdLocation = defaultDtdLocation;
    private static final Logger log = LoggerFactory.getLogger(XmlFile.class);

    public Element rootFromName(String name) throws JDOMException, IOException {
        File fp = this.findFile(name);
        if (fp != null && fp.exists() && fp.canRead()) {
            if (log.isDebugEnabled()) {
                log.debug("readFile: {} from {}", (Object)name, (Object)fp.getAbsolutePath());
            }
            return this.rootFromFile(fp);
        }
        URL resource = FileUtil.findURL(name);
        if (resource != null) {
            return this.rootFromURL(resource);
        }
        if (!name.startsWith("xml")) {
            return this.rootFromName("xml" + File.separator + name);
        }
        log.warn("Did not find file or resource {}", (Object)name);
        throw new FileNotFoundException("Did not find file or resource " + name);
    }

    public Element rootFromFile(File file) throws JDOMException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("reading xml from file: {}", (Object)file.getPath());
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream fs = new FileInputStream(file);){
            return this.getRoot(fs);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Element rootFromInputStream(InputStream stream) throws JDOMException, IOException {
        return this.getRoot(stream);
    }

    public Element rootFromURL(URL url) throws JDOMException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("reading xml from URL: {}", (Object)url.toString());
        }
        return this.getRoot(url.openConnection().getInputStream());
    }

    protected Element getRoot(InputStream stream) throws JDOMException, IOException {
        log.trace("getRoot from stream");
        SAXBuilder builder = XmlFile.getBuilder(this.getValidate());
        Document doc = builder.build((InputStream)new BufferedInputStream(stream));
        doc = this.processInstructions(doc);
        return doc.getRootElement();
    }

    public void writeXML(File file, Document doc) throws IOException, FileNotFoundException {
        if (file.getParent() != null) {
            FileUtil.createDirectory(file.getParent());
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream o = new FileOutputStream(file);){
            XMLOutputter fmt = new XMLOutputter();
            fmt.setFormat(Format.getPrettyFormat().setLineSeparator(System.getProperty("line.separator")).setTextMode(Format.TextMode.TRIM_FULL_WHITE));
            fmt.output(doc, (OutputStream)o);
            o.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected boolean checkFile(String name) {
        File fp = new File(name);
        if (fp.exists()) {
            return true;
        }
        fp = new File(String.valueOf(FileUtil.getUserFilesPath()) + name);
        if (fp.exists()) {
            return true;
        }
        File fx = new File(String.valueOf(XmlFile.xmlDir()) + name);
        return fx.exists();
    }

    protected File findFile(String name) {
        URL url = FileUtil.findURL(name, FileUtil.getUserFilesPath(), ".", FileUtil.getProgramPath(), XmlFile.xmlDir());
        if (url != null) {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return null;
    }

    public static void dumpElement(@Nonnull Element name) {
        name.getChildren().forEach(element -> System.out.println(" Element: " + element.getName() + " ns: " + element.getNamespace()));
    }

    public void makeBackupFile(String name) {
        File file = this.findFile(name);
        if (file == null) {
            log.info("No {} file to backup", (Object)name);
        } else if (file.canWrite()) {
            String backupName = this.backupFileName(file.getAbsolutePath());
            File backupFile = this.findFile(backupName);
            if (backupFile != null && backupFile.delete()) {
                log.debug("deleted backup file {}", (Object)backupName);
            }
            if (file.renameTo(new File(backupName))) {
                log.debug("created new backup file {}", (Object)backupName);
            } else {
                log.error("could not create backup file {}", (Object)backupName);
            }
        }
    }

    public boolean makeBackupFile(String directory, File file) {
        if (file == null) {
            log.info("No file to backup");
        } else if (file.canWrite()) {
            File parentDir;
            File backupFile;
            String backupFullName = String.valueOf(directory) + File.separator + this.createFileNameWithDate(file.getName());
            if (log.isDebugEnabled()) {
                log.debug("new backup file: {}", (Object)backupFullName);
            }
            if ((backupFile = this.findFile(backupFullName)) != null) {
                if (backupFile.delete() && log.isDebugEnabled()) {
                    log.debug("deleted backup file {}", (Object)backupFullName);
                }
            } else {
                backupFile = new File(backupFullName);
            }
            if (!(parentDir = backupFile.getParentFile()).exists()) {
                if (log.isDebugEnabled()) {
                    log.debug("creating backup directory: {}", (Object)parentDir.getName());
                }
                if (!parentDir.mkdirs()) {
                    log.error("backup directory not created");
                    return false;
                }
            }
            if (file.renameTo(new File(backupFullName))) {
                if (log.isDebugEnabled()) {
                    log.debug("created new backup file {}", (Object)backupFullName);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("could not create backup file {}", (Object)backupFullName);
                }
                return false;
            }
        }
        return true;
    }

    public void revertBackupFile(String name) {
        File file = this.findFile(name);
        if (file == null) {
            log.info("No {} file to revert", (Object)name);
        } else {
            String backupName = this.backupFileName(file.getAbsolutePath());
            File backupFile = this.findFile(backupName);
            if (backupFile != null) {
                log.info("No {} backup file to revert", (Object)backupName);
                if (file.delete()) {
                    log.debug("deleted original file {}", (Object)name);
                }
                if (backupFile.renameTo(new File(name))) {
                    log.debug("created original file {}", (Object)name);
                } else {
                    log.error("could not create original file {}", (Object)name);
                }
            }
        }
    }

    public String backupFileName(String name) {
        String f = String.valueOf(name) + ".bak";
        if (log.isDebugEnabled()) {
            log.debug("backup file name is: {}", (Object)f);
        }
        return f;
    }

    public String createFileNameWithDate(String name) {
        String[] fileName = name.split(".xml");
        String f = String.valueOf(fileName[0]) + "_" + this.getDate() + ".xml";
        if (log.isDebugEnabled()) {
            log.debug("backup file name is: {}", (Object)f);
        }
        return f;
    }

    private String getDate() {
        Calendar now = Calendar.getInstance();
        int month = now.get(2) + 1;
        String m = Integer.toString(month);
        if (month < 10) {
            m = "0" + Integer.toString(month);
        }
        int day = now.get(5);
        String d = Integer.toString(day);
        if (day < 10) {
            d = "0" + Integer.toString(day);
        }
        int hour = now.get(10);
        String h = Integer.toString(hour);
        if (hour < 10) {
            h = "0" + Integer.toString(hour);
        }
        int minute = now.get(12);
        String min = Integer.toString(minute);
        if (minute < 10) {
            min = "0" + Integer.toString(minute);
        }
        int second = now.get(13);
        String sec = Integer.toString(second);
        if (second < 10) {
            sec = "0" + Integer.toString(second);
        }
        String date = now.get(1) + m + d + h + min + sec;
        return date;
    }

    Document processInstructions(Document doc) {
        for (Content c : doc.cloneContent()) {
            if (!(c instanceof ProcessingInstruction)) continue;
            try {
                doc = this.processOneInstruction((ProcessingInstruction)c, doc);
            }
            catch (XSLTransformException ex) {
                log.error("XSLT error while transforming with {}, ignoring transform", (Object)c, (Object)ex);
            }
            catch (JDOMException ex) {
                log.error("JDOM error while transforming with {}, ignoring transform", (Object)c, (Object)ex);
            }
            catch (IOException ex) {
                log.error("IO error while transforming with {}, ignoring transform", (Object)c, (Object)ex);
            }
        }
        return doc;
    }

    Document processOneInstruction(ProcessingInstruction p, Document doc) throws XSLTransformException, JDOMException, IOException {
        log.trace("handling {}", (Object)p);
        String target = p.getTarget();
        if (!target.equals("transform-xslt")) {
            return doc;
        }
        String href = p.getPseudoAttributeValue("href");
        if (!href.startsWith("http://jmri.org/")) {
            return doc;
        }
        if ((href = href.substring(16)).startsWith("xml/")) {
            href = href.substring(4);
        }
        SAXBuilder builder = XmlFile.getBuilder(Validate.None);
        Document xdoc = builder.build((InputStream)new BufferedInputStream(new FileInputStream(this.findFile(href))));
        XSLTransformer transformer = new XSLTransformer(xdoc);
        return transformer.transform(doc);
    }

    public static Document newDocument(Element root, String dtd) {
        Document doc = new Document(root);
        doc.setDocType(new DocType(root.getName(), dtd));
        XmlFile.addDefaultInfo(root);
        return doc;
    }

    public static Document newDocument(Element root) {
        Document doc = new Document(root);
        XmlFile.addDefaultInfo(root);
        return doc;
    }

    public static void addDefaultInfo(Element root) {
        String content = "Written by JMRI version " + Version.name() + " on " + new Date().toString();
        Comment comment = new Comment(content);
        root.addContent((Content)comment);
    }

    public static String xmlDir() {
        return String.valueOf(FileUtil.getProgramPath()) + "xml" + File.separator;
    }

    public static Validate getDefaultValidate() {
        return defaultValidate;
    }

    public static void setDefaultValidate(Validate v) {
        defaultValidate = v;
    }

    public Validate getValidate() {
        return this.validate;
    }

    public void setValidate(Validate v) {
        this.validate = v;
    }

    public static String getDefaultDtdLocation() {
        return defaultDtdLocation;
    }

    public static void setDefaultDtdLocation(String v) {
        defaultDtdLocation = v;
    }

    public String getDtdLocation() {
        return this.dtdLocation;
    }

    public void setDtdLocation(String v) {
        this.dtdLocation = v;
    }

    public static JFileChooser userFileChooser(String filter, String ... suffix) {
        JFileChooser fc = new JFileChooser(FileUtil.getUserFilesPath());
        fc.setFileFilter(new NoArchiveFileFilter(filter, suffix));
        return fc;
    }

    public static JFileChooser userFileChooser() {
        JFileChooser fc = new JFileChooser(FileUtil.getUserFilesPath());
        fc.setFileFilter(new NoArchiveFileFilter());
        return fc;
    }

    public static SAXBuilder getBuilder(Validate validate) {
        boolean verifyDTD = validate == Validate.CheckDtd || validate == Validate.CheckDtdThenSchema;
        boolean verifySchema = validate == Validate.RequireSchema || validate == Validate.CheckDtdThenSchema;
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", verifyDTD);
        builder.setEntityResolver((EntityResolver)new JmriLocalEntityResolver());
        builder.setFeature("http://apache.org/xml/features/xinclude", true);
        builder.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
        builder.setFeature("http://apache.org/xml/features/validation/dynamic", verifyDTD && !verifySchema);
        builder.setFeature("http://apache.org/xml/features/validation/schema", verifySchema);
        builder.setFeature("http://apache.org/xml/features/validation/schema-full-checking", verifySchema);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", verifyDTD);
        if (!verifyDTD) {
            builder.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", (Object)"http://www.w3.org/2001/XMLSchema");
        }
        builder.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        return builder;
    }

    public static enum Validate {
        None,
        RequireSchema,
        CheckDtd,
        CheckDtdThenSchema;

    }
}

