/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.Bundle;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.roster.Roster;
import jmri.util.JmriJFrame;

public class MemoryFrameAction
extends AbstractAction {
    JTextField used1 = new JTextField(15);
    JTextField used2 = new JTextField(15);
    JTextField used3 = new JTextField(15);
    JTextField free1 = new JTextField(15);
    JTextField free2 = new JTextField(15);
    JTextField free3 = new JTextField(15);
    JTextField total1 = new JTextField(15);
    JTextField total2 = new JTextField(15);
    JTextField total3 = new JTextField(15);
    JButton updateButton = new JButton(Bundle.getMessage("Update"));
    JButton gcButton = new JButton(Bundle.getMessage("Collect_Memory"));
    JButton testButton = new JButton(Bundle.getMessage("Test"));
    NumberFormat nf;

    public MemoryFrameAction(String s) {
        super(s);
    }

    public MemoryFrameAction() {
        this(Bundle.getMessage("Memory_Usage_Monitor"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.nf = NumberFormat.getInstance();
        this.nf.setMinimumFractionDigits(3);
        this.nf.setMaximumFractionDigits(3);
        this.nf.setGroupingUsed(false);
        JmriJFrame f = new JmriJFrame(Bundle.getMessage("Memory_Usage_Monitor"));
        Container p = f.getContentPane();
        p.setLayout(new GridLayout(5, 3));
        p.add(new JLabel(Bundle.getMessage("used_(MB)")));
        p.add(new JLabel(Bundle.getMessage("free_(MB)")));
        p.add(new JLabel(String.valueOf(Bundle.getMessage("total_(MB,_of_")) + " " + this.nf.format((double)Runtime.getRuntime().maxMemory() / 1048576.0) + "MB)"));
        p.add(this.used3);
        p.add(this.free3);
        p.add(this.total3);
        p.add(this.used2);
        p.add(this.free2);
        p.add(this.total2);
        p.add(this.used1);
        p.add(this.free1);
        p.add(this.total1);
        p.add(this.updateButton);
        p.add(this.gcButton);
        p.add(this.testButton);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MemoryFrameAction.this.updateDisplay();
            }
        });
        this.gcButton.addActionListener(new ActionListener(){

            @Override
            @SuppressFBWarnings(value={"DM_GC"})
            public void actionPerformed(ActionEvent event) {
                Runtime.getRuntime().gc();
                MemoryFrameAction.this.updateDisplay();
            }
        });
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Roster.getDefault();
                InstanceManager.getDefault(DecoderIndexFile.class);
                MemoryFrameAction.this.updateDisplay();
            }
        });
        f.addHelpMenu("package.jmri.jmrit.MemoryFrameAction", true);
        f.pack();
        f.setVisible(true);
    }

    void updateDisplay() {
        this.used3.setText(this.used2.getText());
        this.free3.setText(this.free2.getText());
        this.total3.setText(this.total2.getText());
        this.used2.setText(this.used1.getText());
        this.free2.setText(this.free1.getText());
        this.total2.setText(this.total1.getText());
        double free = (double)Runtime.getRuntime().freeMemory() / 1048576.0;
        double total = (double)Runtime.getRuntime().totalMemory() / 1048576.0;
        this.used1.setText(this.nf.format(total - free));
        this.free1.setText(this.nf.format(free));
        this.total1.setText(this.nf.format(total));
    }
}

