/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import jmri.JmriException;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryContents {
    private static final int DEFAULT_MEM_VALUE = -1;
    private static final int PAGESIZE = 65536;
    private static final int PAGES = 256;
    private static final int RECTYP_DATA_RECORD = 0;
    private static final String STRING_DATA_RECTYP = StringUtil.twoHexFromInt(0);
    private static final int RECTYP_EXTENDED_SEGMENT_ADDRESS_RECORD = 2;
    private static final int RECTYP_EXTENDED_LINEAR_ADDRESS_RECORD = 4;
    private static final int RECTYP_EOF_RECORD = 1;
    private static final int CHARS_IN_RECORD_MARK = 1;
    private static final int CHARS_IN_RECORD_LENGTH = 2;
    private static final int CHARS_IN_RECORD_TYPE = 2;
    private static final int CHARS_IN_EACH_DATA_BYTE = 2;
    private static final int CHARS_IN_CHECKSUM = 2;
    private static final int CHARS_IN_24_BIT_ADDRESS = 6;
    private static final int CHARS_IN_16_BIT_ADDRESS = 4;
    private static final char LEADING_CHAR_COMMENT = '#';
    private static final char LEADING_CHAR_KEY_VALUE = '!';
    private static final char LEADING_CHAR_RECORD_MARK = ':';
    private final int[][] pageArray;
    private int currentPage = -1;
    private int lineNum;
    private boolean hasData = false;
    private int curExtLinAddr = 0;
    private int curExtSegAddr = 0;
    private ArrayList<String> keyValComments = new ArrayList(1);
    private LoadOffsetFieldType loadOffsetFieldType = LoadOffsetFieldType.UNDEFINED;
    private static final Logger log = LoggerFactory.getLogger(MemoryContents.class);

    public MemoryContents() {
        this.pageArray = new int[256][];
        this.keyValComments = new ArrayList(1);
    }

    private boolean isPageInitialized(int page) {
        return this.pageArray[page] != null;
    }

    private void initPage(int page) {
        if (this.pageArray[page] != null) {
            if (log.isDebugEnabled()) {
                log.debug("Method initPage was previously invoked for page {}", (Object)page);
            }
            return;
        }
        int[] largeArray = new int[65536];
        int i = 0;
        while (i < 65536) {
            largeArray[i] = -1;
            ++i;
        }
        this.pageArray[page] = largeArray;
    }

    public void readHex(String filename) throws FileNotFoundException, MemoryFileRecordLengthException, MemoryFileChecksumException, MemoryFileUnknownRecordType, MemoryFileRecordContentException, MemoryFileNoDataRecordsException, MemoryFileNoEOFRecordException, MemoryFileRecordFoundAfterEOFRecord, MemoryFileAddressingRangeException, IOException {
        this.readHex(new File(filename));
    }

    public void readHex(File file) throws FileNotFoundException, MemoryFileRecordLengthException, MemoryFileChecksumException, MemoryFileUnknownRecordType, MemoryFileRecordContentException, MemoryFileNoDataRecordsException, MemoryFileNoEOFRecordException, MemoryFileRecordFoundAfterEOFRecord, MemoryFileAddressingRangeException, IOException {
        boolean foundEOFRecord;
        boolean foundDataRecords;
        block41: {
            BufferedReader fileStream;
            try {
                fileStream = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            }
            catch (IOException ex) {
                throw new FileNotFoundException(ex.toString());
            }
            this.clear();
            this.currentPage = 0;
            this.loadOffsetFieldType = LoadOffsetFieldType.UNDEFINED;
            foundDataRecords = false;
            foundEOFRecord = false;
            this.keyValComments.clear();
            this.lineNum = 0;
            try {
                try {
                    String line;
                    while ((line = fileStream.readLine()) != null) {
                        ++this.lineNum;
                        int len = line.length();
                        if (len < 1 || line.charAt(0) == '#') continue;
                        if (line.charAt(0) == '!') {
                            this.keyValComments.add(line);
                            continue;
                        }
                        if (line.charAt(0) == ':') {
                            int startpoint;
                            int datacount;
                            int indexOfLastAddressCharacter;
                            if (this.loadOffsetFieldType == LoadOffsetFieldType.UNDEFINED) {
                                this.loadOffsetFieldType = this.inferRecordAddressType(line);
                                if (this.isLoadOffsetType16Bits() && this.isLoadOffsetType24Bits()) {
                                    String message = "Could not infer addressing type from line " + this.lineNum + ".";
                                    log.error(message);
                                    throw new MemoryFileRecordContentException(message);
                                }
                            }
                            if ((indexOfLastAddressCharacter = this.charsInAddress() + 2) < 0) {
                                String message = "Fell thru with unknown loadOffsetFieldType value " + (Object)((Object)this.loadOffsetFieldType) + " for line" + this.lineNum + ".";
                                log.error(message);
                                throw new MemoryFileAddressingRangeException(message);
                            }
                            int recordType = Integer.valueOf(line.substring(indexOfLastAddressCharacter + 1, indexOfLastAddressCharacter + 3), 16);
                            if (log.isDebugEnabled()) {
                                log.debug("RECTYP = 0x{}", (Object)Integer.toHexString(recordType));
                            }
                            int count = this.extractRecLen(line);
                            if (len != 3 + this.charsInAddress() + 2 + count * 2 + 2) {
                                String message = "Data record line length is incorrect for inferred addressing type and for data count field in line " + this.lineNum;
                                log.error(message);
                                throw new MemoryFileRecordLengthException(message);
                            }
                            int computedChecksum = this.calculate8BitChecksum(line.substring(1));
                            if (computedChecksum != 0) {
                                computedChecksum = this.calculate8BitChecksum(line.substring(1, line.length() - 1 - 2 + 1));
                                int expectedChecksum = Integer.parseInt(line.substring(line.length() - 2), 16);
                                String message = "Record checksum error in line " + this.lineNum + " - computed checksum = 0x" + Integer.toHexString(computedChecksum) + ", expected checksum = 0x" + Integer.toHexString(expectedChecksum) + ".";
                                log.error(message);
                                throw new MemoryFileChecksumException(message);
                            }
                            if (recordType == 0) {
                                if (foundEOFRecord) {
                                    String message = "Found a Data record in line " + this.lineNum + " after the EOF record";
                                    log.error(message);
                                    throw new MemoryFileRecordFoundAfterEOFRecord(message);
                                }
                                int recordAddress = this.extractLoadOffset(line);
                                int effectiveAddress = (recordAddress &= this.isLoadOffsetType24Bits() ? 0xFFFFFF : 65535) + this.curExtLinAddr + this.curExtSegAddr;
                                if (!this.addressAndCountIsOk(effectiveAddress, count)) {
                                    String message = "Data crosses boundary which could lead to  mis-interpretation.  Aborting read at line " + line;
                                    log.error(message);
                                    throw new MemoryFileAddressingRangeException(message);
                                }
                                int effectivePage = effectiveAddress / 65536;
                                if (!this.isPageInitialized(effectivePage)) {
                                    this.initPage(effectivePage);
                                    log.debug("effective address 0x{} is causing change to segment 0x{}", (Object)Integer.toHexString(effectiveAddress), (Object)Integer.toHexString(effectivePage));
                                }
                                int effectiveOffset = effectiveAddress % 65536;
                                log.debug("Effective address 0x{}, effective page 0x{}, effective offset 0x{}", new Object[]{Integer.toHexString(effectiveAddress), Integer.toHexString(effectivePage), Integer.toHexString(effectiveOffset)});
                                int i = 0;
                                while (i < count) {
                                    int startIndex = indexOfLastAddressCharacter + 3 + i * 2;
                                    int ival = Integer.valueOf(line.substring(startIndex, startIndex + 2), 16);
                                    this.pageArray[effectivePage][effectiveOffset++] = ival;
                                    this.hasData = true;
                                    ++i;
                                }
                                foundDataRecords = true;
                                continue;
                            }
                            if (recordType == 2) {
                                if (foundEOFRecord) {
                                    String message = "Found a Extended Segment Address record in line " + this.lineNum + " after the EOF record";
                                    log.error(message);
                                    throw new MemoryFileRecordFoundAfterEOFRecord(message);
                                }
                                datacount = this.extractRecLen(line);
                                if (datacount != 2) {
                                    String message = "Extended Segment Address record did not have 16 bits of data content." + this.lineNum;
                                    log.error(message);
                                    throw new MemoryFileRecordContentException(message);
                                }
                                startpoint = indexOfLastAddressCharacter + 3;
                                int newPage = 16 * Integer.valueOf(line.substring(startpoint, startpoint + 2 * datacount), 16);
                                if (newPage != 0) {
                                    String message = "Unsupported Extended Segment Address Record data value 0x" + Integer.toHexString(newPage) + " in line " + this.lineNum;
                                    log.error(message);
                                    throw new MemoryFileAddressingRangeException(message);
                                }
                                this.curExtLinAddr = 0;
                                this.curExtSegAddr = newPage;
                                if (newPage == this.currentPage) continue;
                                this.currentPage = newPage;
                                this.initPage(this.currentPage);
                                continue;
                            }
                            if (recordType == 4) {
                                if (foundEOFRecord) {
                                    String message = "Found a Extended Linear Address record in line " + this.lineNum + " after the EOF record";
                                    log.error(message);
                                    throw new MemoryFileRecordFoundAfterEOFRecord(message);
                                }
                                if (this.extractLoadOffset(line) != 0) {
                                    String message = "Extended Linear Address record has non-zero LOAD OFFSET field." + this.lineNum;
                                    log.error(message);
                                    throw new MemoryFileRecordContentException(message);
                                }
                                datacount = this.extractRecLen(line);
                                if (datacount != 2) {
                                    String message = "Expect data payload length of 2, found RECLEN value of " + this.extractRecLen(line) + " in line " + this.lineNum;
                                    log.error(message);
                                    throw new MemoryFileRecordContentException(message);
                                }
                                startpoint = indexOfLastAddressCharacter + 3;
                                int tempPage = Integer.valueOf(line.substring(startpoint, startpoint + 2 * datacount), 16);
                                if (tempPage != 0 && this.isLoadOffsetType24Bits()) {
                                    String message = "Extended Linear Address record with non-zerodata field in line " + this.lineNum + " is not allowed in files using " + "24-bit LOAD OFFSET field.";
                                    log.error(message);
                                    throw new MemoryFileRecordContentException(message);
                                }
                                if (tempPage < 256) {
                                    this.curExtLinAddr = tempPage * 65536;
                                    this.curExtSegAddr = 0;
                                    this.currentPage = tempPage;
                                    this.initPage(this.currentPage);
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug("New page 0x{}", (Object)Integer.toHexString(this.currentPage));
                                    continue;
                                }
                                String message = "Page number 0x" + Integer.toHexString(tempPage) + " specified in line number " + this.lineNum + " is beyond the supported 24-bit address range.";
                                log.error(message);
                                throw new MemoryFileAddressingRangeException(message);
                            }
                            if (recordType == 1) {
                                if (this.extractRecLen(line) != 0 || this.extractLoadOffset(line) != 0) {
                                    String message = "Illegal EOF record form in line " + this.lineNum;
                                    log.error(message);
                                    throw new MemoryFileRecordContentException(message);
                                }
                                foundEOFRecord = true;
                                continue;
                            }
                            String message = "Unknown RECTYP 0x" + Integer.toHexString(recordType) + " was found in line " + this.lineNum + ".  Aborting file read.";
                            log.error(message);
                            throw new MemoryFileUnknownRecordType(message);
                        }
                        String message = "Unknown line type in line " + this.lineNum + ".";
                        log.error(message);
                        throw new MemoryFileUnknownRecordType(message);
                    }
                }
                catch (IOException e) {
                    log.error("Exception reading file", (Throwable)e);
                    try {
                        fileStream.close();
                    }
                    catch (IOException e2) {
                        log.error("Exception closing file", (Throwable)e2);
                    }
                    break block41;
                }
            }
            catch (Throwable throwable) {
                try {
                    fileStream.close();
                }
                catch (IOException e2) {
                    log.error("Exception closing file", (Throwable)e2);
                }
                throw throwable;
            }
            try {
                fileStream.close();
            }
            catch (IOException e2) {
                log.error("Exception closing file", (Throwable)e2);
            }
        }
        if (!foundDataRecords) {
            String message = "No Data Records found in file - aborting.";
            log.error(message);
            throw new MemoryFileNoDataRecordsException(message);
        }
        if (!foundEOFRecord) {
            String message = "No EOF Record found in file - aborting.";
            log.error(message);
            throw new MemoryFileNoEOFRecordException(message);
        }
    }

    public void writeHex(Writer w) throws IOException, MemoryFileAddressingFormatException {
        this.writeHex(w, 16);
    }

    public void writeHex(Writer writer, boolean writeKeyVals, int blockSize) throws IOException, MemoryFileAddressingFormatException {
        if (writeKeyVals) {
            this.writeComments(writer);
        }
        this.writeHex(writer, blockSize);
    }

    private void writeHex(Writer writer, int blockSize) throws IOException, MemoryFileAddressingFormatException {
        int blocksize = blockSize;
        if (!this.isLoadOffsetType16Bits() && !this.isLoadOffsetType24Bits()) {
            String message = "Invalid loadOffsetFieldType at writeHex invocation";
            log.error(message);
            throw new MemoryFileAddressingFormatException(message);
        }
        int segment = 0;
        while (segment < 256) {
            if (this.pageArray[segment] != null) {
                if (segment != 0 && this.isLoadOffsetType16Bits()) {
                    StringBuffer output = new StringBuffer(":0200000400");
                    output.append(StringUtil.twoHexFromInt(segment));
                    int checksum = this.calculate8BitChecksum(output.substring(1));
                    output.append(StringUtil.twoHexFromInt(checksum));
                    output.append("\n");
                    writer.write(output.toString());
                }
                int i = 0;
                while (i < this.pageArray[segment].length - blocksize + 1) {
                    if (log.isDebugEnabled()) {
                        log.debug("write at 0x{}", (Object)Integer.toHexString(i));
                    }
                    boolean write = false;
                    int startOffset = -1;
                    int j = i;
                    while (j < i + blocksize - (i + blocksize) % blocksize) {
                        if (this.pageArray[segment][j] >= 0) {
                            write = true;
                            if (startOffset < 0) {
                                startOffset = j;
                                if (log.isDebugEnabled()) {
                                    log.debug("startOffset = 0x{}", (Object)Integer.toHexString(startOffset));
                                }
                            }
                        }
                        if (write && j == i + (blocksize - 1) || write && this.pageArray[segment][j] < 0) {
                            int addressForAddressField = startOffset;
                            if (this.isLoadOffsetType24Bits()) {
                                addressForAddressField += segment * 65536;
                            }
                            int addrMostSByte = addressForAddressField / 65536;
                            int addrMidSByte = (addressForAddressField - 65536 * addrMostSByte) / 256;
                            int addrLeastSByte = addressForAddressField - 256 * addrMidSByte - 65536 * addrMostSByte;
                            int count = j - startOffset;
                            if (j == i + (blocksize - 1)) {
                                ++count;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("Writing Address {} ({}bit Address) count {}", new Object[]{startOffset, this.isLoadOffsetType24Bits() ? "24" : "16", count});
                            }
                            StringBuffer output = new StringBuffer(":");
                            output.append(StringUtil.twoHexFromInt(count));
                            if (this.isLoadOffsetType24Bits()) {
                                output.append(StringUtil.twoHexFromInt(addrMostSByte));
                            }
                            output.append(StringUtil.twoHexFromInt(addrMidSByte));
                            output.append(StringUtil.twoHexFromInt(addrLeastSByte));
                            output.append(STRING_DATA_RECTYP);
                            int k = 0;
                            while (k < count) {
                                int val = this.pageArray[segment][startOffset + k];
                                output.append(StringUtil.twoHexFromInt(val));
                                ++k;
                            }
                            int checksum = this.calculate8BitChecksum(output.substring(1));
                            output.append(StringUtil.twoHexFromInt(checksum));
                            output.append("\n");
                            writer.write(output.toString());
                            write = false;
                            startOffset = -1;
                        }
                        ++j;
                    }
                    if (!write) {
                        // empty if block
                    }
                    i += blocksize;
                }
            }
            ++segment;
        }
        writer.write(this.isLoadOffsetType24Bits() ? ":0000000001FF\n" : ":00000001FF\n");
        writer.flush();
    }

    public int nextContent(int location) {
        this.currentPage = location / 65536;
        int offset = location % 65536;
        while (this.currentPage < 256) {
            if (this.pageArray[this.currentPage] != null) {
                while (offset < this.pageArray[this.currentPage].length) {
                    if (this.pageArray[this.currentPage][offset] != -1) {
                        return offset + this.currentPage * 65536;
                    }
                    ++offset;
                }
            }
            offset = 0;
            ++this.currentPage;
        }
        return -1;
    }

    public void setLocation(int location, int value) {
        this.currentPage = location / 65536;
        this.pageArray[this.currentPage][location % 65536] = value;
        this.hasData = true;
    }

    public boolean locationInUse(int location) {
        this.currentPage = location / 65536;
        if (this.pageArray[this.currentPage] == null) {
            return false;
        }
        try {
            return this.pageArray[this.currentPage][location % 65536] != -1;
        }
        catch (Exception e) {
            log.error("error in locationInUse {} {}", new Object[]{this.currentPage, location, e});
            return false;
        }
    }

    public int getLocation(int location) {
        this.currentPage = location / 65536;
        if (this.pageArray[this.currentPage] == null) {
            log.error("Error in getLocation(0x{}): accessed uninitialized page {}", (Object)Integer.toHexString(location), (Object)this.currentPage);
            return -1;
        }
        try {
            return this.pageArray[this.currentPage][location % 65536];
        }
        catch (Exception e) {
            log.error("Error in getLocation(0x{}); computed (current page 0x{}): exception ", new Object[]{Integer.toHexString(location), Integer.toHexString(this.currentPage), e});
            return 0;
        }
    }

    public boolean isEmpty() {
        return !this.hasData;
    }

    private LoadOffsetFieldType inferRecordAddressType(String recordString) {
        if (recordString.charAt(0) != ':') {
            log.error("Cannot infer record addressing type because line {} is not a record.", (Object)this.lineNum);
            return LoadOffsetFieldType.ADDRESSFIELDSIZEUNKNOWN;
        }
        String r = recordString.substring(1);
        int len = r.length();
        if ((len + 1) / 2 != len / 2) {
            log.error("Cannot infer record addressing type because line {} does not have the correct number of characters.", (Object)this.lineNum);
            return LoadOffsetFieldType.ADDRESSFIELDSIZEUNKNOWN;
        }
        int datalen = Integer.parseInt(r.substring(0, 2), 16);
        int checksumInRecord = Integer.parseInt(r.substring(len - 2, len), 16);
        int calculatedChecksum = this.calculate8BitChecksum(recordString.substring(1, recordString.length() - 2));
        if (calculatedChecksum != checksumInRecord) {
            log.error("Cannot infer record addressing type because line {} does not have the correct checksum (expect 0x{}, found CHKSUM = 0x{})", new Object[]{this.lineNum, Integer.toHexString(calculatedChecksum), Integer.toHexString(checksumInRecord)});
            return LoadOffsetFieldType.ADDRESSFIELDSIZEUNKNOWN;
        }
        int computedLenIf16Bit = 8 + datalen * 2 + 2;
        int computedLenIf24Bit = computedLenIf16Bit + 2;
        if (computedLenIf16Bit == len) {
            if (this.isSupportedRecordType(Integer.parseInt(r.substring(6, 8), 16))) {
                return LoadOffsetFieldType.ADDRESSFIELDSIZE16BITS;
            }
            log.error("Cannot infer record addressing type in line {} because record type is an unsupported record type.", (Object)this.lineNum);
            return LoadOffsetFieldType.ADDRESSFIELDSIZEUNKNOWN;
        }
        if (computedLenIf24Bit == len) {
            if (this.isSupportedRecordType(Integer.parseInt(r.substring(8, 10), 16))) {
                return LoadOffsetFieldType.ADDRESSFIELDSIZE24BITS;
            }
            log.error("Cannot infer record addressing type in line {} because record type is an unsupported record type.", (Object)this.lineNum);
            return LoadOffsetFieldType.ADDRESSFIELDSIZEUNKNOWN;
        }
        return LoadOffsetFieldType.ADDRESSFIELDSIZEUNKNOWN;
    }

    private int calculate8BitChecksum(String infoString) {
        int len = infoString.length();
        if ((len + 1) / 2 != len / 2) {
            return -1;
        }
        int calculatedChecksum = 0;
        int i = 0;
        while (i < len) {
            calculatedChecksum += Integer.parseInt(infoString.substring(i, i + 2), 16);
            i += 2;
        }
        return 0xFF & 256 - (calculatedChecksum & 0xFF);
    }

    private boolean addressAndCountIsOk(int addr, int count) {
        int beginPage = addr / 65536;
        int endPage = (addr + count - 1) / 65536;
        log.debug("Effective Record Addr = 0x{} count = {} BeginPage = {} endpage = {}", new Object[]{Integer.toHexString(addr), count, beginPage, endPage});
        return beginPage == endPage;
    }

    public String extractValueOfKey(String keyName) {
        int i = 0;
        while (i < this.keyValComments.size()) {
            String targetedKey;
            String t = this.keyValComments.get(i);
            if (t.startsWith(targetedKey = "! " + keyName + ": ")) {
                int f = t.indexOf(": ");
                String value = t.substring(f + 2, t.length());
                if (log.isDebugEnabled()) {
                    log.debug("Key {} was found in firmware image with value '{}'", (Object)keyName, (Object)value);
                }
                return value;
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug("Key {} is not defined in firmware image", (Object)keyName);
        }
        return null;
    }

    private int findKeyCommentIndex(String keyName) {
        int i = 0;
        while (i < this.keyValComments.size()) {
            String targetedKey;
            String t = this.keyValComments.get(i);
            if (t.startsWith(targetedKey = "! " + keyName + ": ")) {
                return i;
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug("Did not find key {}", (Object)keyName);
        }
        return -1;
    }

    public void addKeyValueComment(String keyName, String value) {
        int keyIndex = this.findKeyCommentIndex(keyName);
        if (keyIndex < 0) {
            this.keyValComments.add("! " + keyName + ": " + value + "\n");
            return;
        }
        log.warn("Key {} already exists in key/value set.  Overriding previous value!", (Object)keyName);
        this.keyValComments.set(keyIndex, "! " + keyName + ": " + value + "\n");
    }

    public void setAddressFormat(LoadOffsetFieldType addressingType) {
        this.loadOffsetFieldType = addressingType;
    }

    public LoadOffsetFieldType getCurrentAddressFormat() {
        return this.loadOffsetFieldType;
    }

    public void writeComments(Writer writer) throws IOException {
        for (String s : this.keyValComments) {
            writer.write(s);
        }
    }

    private boolean isLoadOffsetType24Bits() {
        return this.loadOffsetFieldType == LoadOffsetFieldType.ADDRESSFIELDSIZE24BITS;
    }

    private boolean isLoadOffsetType16Bits() {
        return this.loadOffsetFieldType == LoadOffsetFieldType.ADDRESSFIELDSIZE16BITS;
    }

    private boolean isSupportedRecordType(int recordType) {
        switch (recordType) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private int extractRecLen(String line) {
        return Integer.valueOf(line.substring(1, 3), 16);
    }

    private int charsInAddress() {
        if (this.isLoadOffsetType24Bits()) {
            return 6;
        }
        if (this.isLoadOffsetType16Bits()) {
            return 4;
        }
        return -999;
    }

    private int extractLoadOffset(String line) {
        return Integer.parseInt(line.substring(3, 3 + this.charsInAddress()), 16);
    }

    public String toString() {
        StringBuffer retval = new StringBuffer("Pages occupied: ");
        int page = 0;
        while (page < 256) {
            if (this.isPageInitialized(page)) {
                retval.append(page);
                retval.append(" ");
            }
            ++page;
        }
        return new String(retval);
    }

    public void clear() {
        log.info("Clearing a MemoryContents object by program request.");
        this.currentPage = -1;
        this.hasData = false;
        this.curExtLinAddr = 0;
        this.curExtSegAddr = 0;
        this.keyValComments = new ArrayList(1);
        int i = 0;
        while (i < this.pageArray.length) {
            this.pageArray[i] = null;
            ++i;
        }
    }

    public static enum LoadOffsetFieldType {
        UNDEFINED,
        ADDRESSFIELDSIZE16BITS,
        ADDRESSFIELDSIZE24BITS,
        ADDRESSFIELDSIZEUNKNOWN;

    }

    public class MemoryFileAddressingFormatException
    extends MemoryFileException {
        public MemoryFileAddressingFormatException() {
        }

        public MemoryFileAddressingFormatException(String s) {
            super(s);
        }
    }

    public class MemoryFileAddressingRangeException
    extends MemoryFileException {
        public MemoryFileAddressingRangeException() {
        }

        public MemoryFileAddressingRangeException(String s) {
            super(s);
        }
    }

    public class MemoryFileChecksumException
    extends MemoryFileException {
        public MemoryFileChecksumException() {
        }

        public MemoryFileChecksumException(String s) {
            super(s);
        }
    }

    public class MemoryFileException
    extends JmriException {
        public MemoryFileException() {
        }

        public MemoryFileException(String s) {
            super(s);
        }
    }

    public class MemoryFileNoDataRecordsException
    extends MemoryFileException {
        public MemoryFileNoDataRecordsException() {
        }

        public MemoryFileNoDataRecordsException(String s) {
            super(s);
        }
    }

    public class MemoryFileNoEOFRecordException
    extends MemoryFileException {
        public MemoryFileNoEOFRecordException() {
        }

        public MemoryFileNoEOFRecordException(String s) {
            super(s);
        }
    }

    public class MemoryFileRecordContentException
    extends MemoryFileException {
        public MemoryFileRecordContentException() {
        }

        public MemoryFileRecordContentException(String s) {
            super(s);
        }
    }

    public class MemoryFileRecordFoundAfterEOFRecord
    extends MemoryFileException {
        public MemoryFileRecordFoundAfterEOFRecord() {
        }

        public MemoryFileRecordFoundAfterEOFRecord(String s) {
            super(s);
        }
    }

    public class MemoryFileRecordLengthException
    extends MemoryFileException {
        public MemoryFileRecordLengthException() {
        }

        public MemoryFileRecordLengthException(String s) {
            super(s);
        }
    }

    public class MemoryFileUnknownRecordType
    extends MemoryFileException {
        public MemoryFileUnknownRecordType() {
        }

        public MemoryFileUnknownRecordType(String s) {
            super(s);
        }
    }
}

