/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit;

import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIdentify
implements ProgListener {
    static final int RETRY_COUNT = 2;
    Programmer programmer;
    ProgrammingMode savedMode;
    int state = 0;
    int retry = 0;
    int lastValue = 0;
    boolean optionalCv = false;
    String cvToRead;
    String cvToWrite;
    private static final Logger log = LoggerFactory.getLogger(AbstractIdentify.class);

    public abstract boolean test1();

    public abstract boolean test2(int var1);

    public abstract boolean test3(int var1);

    public abstract boolean test4(int var1);

    public abstract boolean test5(int var1);

    public abstract boolean test6(int var1);

    public abstract boolean test7(int var1);

    public abstract boolean test8(int var1);

    public abstract boolean test9(int var1);

    protected AbstractIdentify(Programmer p) {
        this.programmer = p;
    }

    protected abstract void statusUpdate(String var1);

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug("identify begins");
        }
        if (this.state != 0) {
            log.error("start with state {}, should have been zero", (Object)this.state);
        }
        if (this.programmer != null) {
            this.savedMode = this.programmer.getMode();
        }
        this.state = 1;
        this.retry = 0;
        this.lastValue = -1;
        this.setOptionalCv(false);
        this.test1();
    }

    protected void identifyDone() {
        if (log.isDebugEnabled()) {
            log.debug("identifyDone ends in state {}", (Object)this.state);
        }
        this.statusUpdate("Done");
        this.state = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void programmingOpReply(int value, int status) {
        block19: {
            block20: {
                if (this.programmer == null) {
                    log.warn("No programmer connected");
                    this.statusUpdate("No programmer connected");
                    this.state = 0;
                    this.retry = 0;
                    this.error();
                    return;
                }
                log.debug("Entering programmingOpReply, state {}, isOptionalCv {},retry {}, value {}, status {}", new Object[]{this.state, this.isOptionalCv(), this.retry, value, this.programmer.decodeErrorCode(status)});
                if (status == 0) break block20;
                if (this.retry < 2) {
                    this.statusUpdate("Programmer error: " + this.programmer.decodeErrorCode(status));
                    --this.state;
                    ++this.retry;
                    value = this.lastValue;
                    break block19;
                } else if (this.state == 1 && this.programmer.getMode() != ProgrammingMode.PAGEMODE && this.programmer.getSupportedModes().contains(ProgrammingMode.PAGEMODE)) {
                    this.programmer.setMode(ProgrammingMode.PAGEMODE);
                    this.retry = 0;
                    --this.state;
                    value = this.lastValue;
                    log.warn("{} readng CV {}, trying {} mode", new Object[]{this.programmer.decodeErrorCode(status), this.cvToRead, this.programmer.getMode().toString()});
                    break block19;
                } else {
                    this.retry = 0;
                    if (this.programmer.getMode() != this.savedMode) {
                        log.warn("Restoring {} mode", (Object)this.savedMode.toString());
                        this.programmer.setMode(this.savedMode);
                    }
                    if (!this.isOptionalCv()) {
                        log.warn("Stopping due to error: {}", (Object)this.programmer.decodeErrorCode(status));
                        this.statusUpdate("Stopping due to error: " + this.programmer.decodeErrorCode(status));
                        this.state = 0;
                        this.error();
                        return;
                    }
                    log.warn("CV {} is optional. Will assume not present...", (Object)this.cvToRead);
                    this.statusUpdate("CV " + this.cvToRead + " is optional. Will assume not present...");
                }
                break block19;
            }
            this.retry = 0;
            this.lastValue = value;
            this.setOptionalCv(false);
        }
        log.debug("Was state {}, switching to state {}, test{}, isOptionalCv {},retry {}, value {}, status {}", new Object[]{this.state, this.state + 1, this.state + 1, this.isOptionalCv(), this.retry, value, this.programmer.decodeErrorCode(status)});
        switch (this.state) {
            case 0: {
                this.state = 1;
                if (!this.test1()) return;
                this.identifyDone();
                return;
            }
            case 1: {
                this.state = 2;
                if (!this.test2(value)) return;
                this.identifyDone();
                return;
            }
            case 2: {
                this.state = 3;
                if (!this.test3(value)) return;
                this.identifyDone();
                return;
            }
            case 3: {
                this.state = 4;
                if (!this.test4(value)) return;
                this.identifyDone();
                return;
            }
            case 4: {
                this.state = 5;
                if (!this.test5(value)) return;
                this.identifyDone();
                return;
            }
            case 5: {
                this.state = 6;
                if (!this.test6(value)) return;
                this.identifyDone();
                return;
            }
            case 6: {
                this.state = 7;
                if (!this.test7(value)) return;
                this.identifyDone();
                return;
            }
            case 7: {
                this.state = 8;
                if (!this.test8(value)) return;
                this.identifyDone();
                return;
            }
            case 8: {
                this.state = 9;
                if (this.test9(value)) {
                    this.identifyDone();
                    return;
                }
                log.error("test9 with value = {} returned false, but there is no next step", (Object)value);
                return;
            }
        }
        log.error("unexpected state in normal operation: {} value: {}, ending identification", (Object)this.state, (Object)value);
        this.identifyDone();
    }

    protected abstract void error();

    public boolean isRunning() {
        return this.state != 0;
    }

    protected void readCV(String cv) {
        if (this.programmer == null) {
            this.statusUpdate("No programmer connected");
        } else {
            this.cvToRead = cv;
            log.debug("Invoking readCV {}", (Object)this.cvToRead);
            try {
                this.programmer.readCV(cv, this);
            }
            catch (ProgrammerException ex) {
                this.statusUpdate("" + ex);
            }
        }
    }

    protected void writeCV(String cv, int value) {
        if (this.programmer == null) {
            this.statusUpdate("No programmer connected");
        } else {
            this.cvToWrite = cv;
            log.debug("Invoking writeCV {}", (Object)this.cvToWrite);
            try {
                this.programmer.writeCV(cv, value, this);
            }
            catch (ProgrammerException ex) {
                this.statusUpdate("" + ex);
            }
        }
    }

    public boolean isOptionalCv() {
        return this.optionalCv;
    }

    public void setOptionalCv(boolean flag) {
        this.optionalCv = flag;
    }
}

