/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.srcp.parser;

import java.io.IOException;
import java.util.ArrayList;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.ProgrammingMode;
import jmri.SensorManager;
import jmri.SystemConnectionMemo;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmris.ServiceHandler;
import jmri.jmris.srcp.JmriSRCPProgrammerServer;
import jmri.jmris.srcp.JmriSRCPSensorServer;
import jmri.jmris.srcp.JmriSRCPServiceHandler;
import jmri.jmris.srcp.JmriSRCPThrottleServer;
import jmri.jmris.srcp.JmriSRCPTimeServer;
import jmri.jmris.srcp.JmriSRCPTurnoutServer;
import jmri.jmris.srcp.parser.ASTconnectionlitteral;
import jmri.jmris.srcp.parser.ASTcv;
import jmri.jmris.srcp.parser.ASTcvbit;
import jmri.jmris.srcp.parser.ASTget;
import jmri.jmris.srcp.parser.ASTgo;
import jmri.jmris.srcp.parser.ASThandshake_set;
import jmri.jmris.srcp.parser.ASTinit;
import jmri.jmris.srcp.parser.ASTprotocollitteral;
import jmri.jmris.srcp.parser.ASTreset;
import jmri.jmris.srcp.parser.ASTset;
import jmri.jmris.srcp.parser.ASTterm;
import jmri.jmris.srcp.parser.ASTwait_cmd;
import jmri.jmris.srcp.parser.SRCPParserDefaultVisitor;
import jmri.jmris.srcp.parser.SimpleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRCPVisitor
extends SRCPParserDefaultVisitor {
    private String outputString = null;
    private static final Logger log = LoggerFactory.getLogger(SRCPVisitor.class);

    public String getOutputString() {
        return this.outputString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSupported(int bus, String devicegroup) {
        try {
            SystemConnectionMemo memo = InstanceManager.getList(SystemConnectionMemo.class).get(bus - 1);
            if (memo == null) {
                this.outputString = "416 ERROR no data";
                return false;
            }
            log.debug("devicegroup {}", (Object)devicegroup);
            if (devicegroup.equals("FB")) {
                if (memo.provides(SensorManager.class)) {
                    return true;
                }
                this.outputString = "422 ERROR unsupported device group";
                return false;
            }
            if (devicegroup.equals("GA")) {
                if (memo.provides(TurnoutManager.class)) {
                    return true;
                }
                this.outputString = "422 ERROR unsupported device group";
                return false;
            }
            if (devicegroup.equals("GL")) {
                if (memo.provides(ThrottleManager.class)) {
                    return true;
                }
                this.outputString = "422 ERROR unsupported device group";
                return false;
            }
            if (devicegroup.equals("POWER")) {
                if (memo.provides(PowerManager.class)) {
                    return true;
                }
                this.outputString = "422 ERROR unsupported device group";
                return false;
            }
            if (!devicegroup.equals("SM")) {
                this.outputString = "422 ERROR unsupported device group";
                return false;
            }
            if (memo.provides(GlobalProgrammerManager.class)) {
                return true;
            }
            this.outputString = "422 ERROR unsupported device group";
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.outputString = "412 ERROR wrong value";
        }
        return false;
    }

    @Override
    public Object visit(ASTgo node, Object data) {
        log.debug("Go {}", node.jjtGetValue());
        JmriSRCPServiceHandler handle = (JmriSRCPServiceHandler)data;
        if (handle.getClientVersion().startsWith("0.8")) {
            handle.setRunMode();
            this.outputString = "200 OK GO " + ((JmriSRCPServiceHandler)data).getSessionNumber();
        } else {
            this.outputString = "402 ERROR insufficient data";
        }
        return data;
    }

    @Override
    public Object visit(ASThandshake_set node, Object data) {
        log.debug("Handshake Mode SET ");
        JmriSRCPServiceHandler handle = (JmriSRCPServiceHandler)data;
        if (node.jjtGetChild(0).getClass() == ASTprotocollitteral.class) {
            String version = (String)((SimpleNode)node.jjtGetChild(1)).jjtGetValue();
            if (version.startsWith("0.8")) {
                handle.setClientVersion(version);
                this.outputString = "201 OK PROTOCOL SRCP";
            } else {
                this.outputString = "400 ERROR unsupported protocol";
            }
        } else if (node.jjtGetChild(0).getClass() == ASTconnectionlitteral.class) {
            String mode = (String)((SimpleNode)node.jjtGetChild(1)).jjtGetValue();
            this.outputString = "202 OK CONNECTIONMODEOK";
            if (mode.equals("COMMAND")) {
                handle.setCommandMode(true);
            } else if (mode.equals("INFO")) {
                handle.setCommandMode(false);
            } else {
                this.outputString = "401 ERROR unsupported connection mode";
            }
        } else {
            this.outputString = "500 ERROR out of resources";
        }
        return data;
    }

    @Override
    public Object visit(ASTget node, Object data) {
        block61: {
            log.debug("Get {}", ((SimpleNode)node.jjtGetChild(1)).jjtGetValue());
            int bus = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(0)).jjtGetValue());
            if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("POWER") && this.isSupported(bus, "POWER")) {
                try {
                    ((ServiceHandler)data).getPowerServer().sendStatus(InstanceManager.getDefault(PowerManager.class).getPower());
                }
                catch (IOException iOException) {}
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("GA") && this.isSupported(bus, "GA")) {
                int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
                try {
                    ((JmriSRCPTurnoutServer)((ServiceHandler)data).getTurnoutServer()).sendStatus(bus, address);
                }
                catch (IOException iOException) {}
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("FB") && this.isSupported(bus, "FB")) {
                int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
                try {
                    ((JmriSRCPSensorServer)((ServiceHandler)data).getSensorServer()).sendStatus(bus, address);
                }
                catch (IOException iOException) {}
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("SM") && this.isSupported(bus, "SM")) {
                ProgrammingMode modeno = ProgrammingMode.REGISTERMODE;
                if (node.jjtGetChild(3).getClass() == ASTcv.class) {
                    modeno = ProgrammingMode.DIRECTBYTEMODE;
                } else if (node.jjtGetChild(3).getClass() == ASTcvbit.class) {
                    modeno = ProgrammingMode.DIRECTBITMODE;
                }
                int cv = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(4)).jjtGetValue());
                ((JmriSRCPProgrammerServer)((ServiceHandler)data).getProgrammerServer()).readCV(modeno, cv);
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("GL") && this.isSupported(bus, "GL")) {
                int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
                try {
                    ((JmriSRCPThrottleServer)((ServiceHandler)data).getThrottleServer()).sendStatus(bus, address);
                }
                catch (IOException iOException) {}
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("TIME")) {
                try {
                    ((ServiceHandler)data).getTimeServer().sendTime();
                }
                catch (IOException iOException) {}
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("SERVER")) {
                this.outputString = "100 INFO 0 SERVER RUNNING";
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("DESCRIPTION")) {
                SimpleNode descriptionnode = (SimpleNode)node.jjtGetChild(1);
                int children = descriptionnode.jjtGetNumChildren();
                if (children == 0) {
                    if (bus == 0) {
                        this.outputString = "100 INFO 0 DESCRIPTION SERVER SESSION TIME";
                    } else {
                        this.outputString = "100 INFO " + bus;
                        try {
                            SystemConnectionMemo memo = InstanceManager.getList(SystemConnectionMemo.class).get(bus - 1);
                            if (memo != null) {
                                this.outputString = String.valueOf(this.outputString) + " DESCRIPTION";
                                if (memo.provides(SensorManager.class)) {
                                    this.outputString = String.valueOf(this.outputString) + " FB";
                                }
                                if (memo.provides(TurnoutManager.class)) {
                                    this.outputString = String.valueOf(this.outputString) + " GA";
                                }
                                if (memo.provides(ThrottleManager.class)) {
                                    this.outputString = String.valueOf(this.outputString) + " GL";
                                }
                                if (memo.provides(PowerManager.class)) {
                                    this.outputString = String.valueOf(this.outputString) + " POWER";
                                }
                                if (memo.provides(GlobalProgrammerManager.class)) {
                                    this.outputString = String.valueOf(this.outputString) + " SM";
                                }
                                break block61;
                            }
                            this.outputString = "416 ERROR no data";
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            this.outputString = "412 ERROR wrong value";
                        }
                    }
                } else if (children == 1) {
                    String devicegroup = (String)((SimpleNode)descriptionnode.jjtGetChild(0)).jjtGetValue();
                    this.outputString = "100 INFO " + bus;
                    log.debug("devicegroup {}", (Object)devicegroup);
                    this.outputString = devicegroup.equals("FB") && this.isSupported(bus, devicegroup) ? "419 ERROR list too short" : (devicegroup.equals("GA") && this.isSupported(bus, devicegroup) ? "419 ERROR list too short" : (devicegroup.equals("GL") && this.isSupported(bus, devicegroup) ? "419 ERROR list too short" : (devicegroup.equals("POWER") && this.isSupported(bus, devicegroup) ? String.valueOf(this.outputString) + " POWER" : (devicegroup.equals("SM") && this.isSupported(bus, devicegroup) ? "419 ERROR list too short" : "422 ERROR unsupported device group"))));
                } else if (children == 2) {
                    this.outputString = "100 INFO " + bus;
                    SystemConnectionMemo memo = InstanceManager.getList(SystemConnectionMemo.class).get(bus - 1);
                    if (memo != null) {
                        String devicegroup = (String)((SimpleNode)descriptionnode.jjtGetChild(0)).jjtGetValue();
                        String address = (String)((SimpleNode)descriptionnode.jjtGetChild(1)).jjtGetValue();
                        if (devicegroup.equals("FB") && this.isSupported(bus, devicegroup)) {
                            SensorManager mgr = (SensorManager)memo.get(SensorManager.class);
                            try {
                                String searchName = mgr.createSystemName(address, memo.getSystemPrefix());
                                if (mgr.getBySystemName(searchName) != null) {
                                    this.outputString = String.valueOf(this.outputString) + " FB " + address;
                                    break block61;
                                }
                                this.outputString = "412 ERROR wrong value";
                            }
                            catch (JmriException jmriException) {
                                this.outputString = "412 ERROR wrong value";
                            }
                        } else if (devicegroup.equals("GA") && this.isSupported(bus, devicegroup)) {
                            TurnoutManager mgr = (TurnoutManager)memo.get(TurnoutManager.class);
                            try {
                                String searchName = mgr.createSystemName(address, memo.getSystemPrefix());
                                if (mgr.getBySystemName(searchName) != null) {
                                    this.outputString = String.valueOf(this.outputString) + " GA " + address + " N";
                                    break block61;
                                }
                                this.outputString = "412 ERROR wrong value";
                            }
                            catch (JmriException jmriException) {
                                this.outputString = "412 ERROR wrong value";
                            }
                        } else if (devicegroup.equals("GL") && this.isSupported(bus, devicegroup)) {
                            this.outputString = "416 ERROR no data";
                        } else if (devicegroup.equals("POWER") && this.isSupported(bus, devicegroup)) {
                            this.outputString = "418 ERROR list too long";
                        } else if (devicegroup.equals("SM") && this.isSupported(bus, devicegroup)) {
                            this.outputString = "416 ERROR no data";
                        }
                    }
                } else {
                    this.outputString = "418 ERROR list too long";
                }
            } else {
                this.outputString = "422 ERROR unsupported device group";
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTset node, Object data) {
        SimpleNode target = (SimpleNode)node.jjtGetChild(1);
        log.debug("Set {}", target.jjtGetValue());
        int bus = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(0)).jjtGetValue());
        if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("POWER") && this.isSupported(bus, "POWER")) {
            try {
                ((ServiceHandler)data).getPowerServer().parseStatus((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            }
            catch (IOException iOException) {
            }
            catch (JmriException jmriException) {}
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("GA") && this.isSupported(bus, "GA")) {
            int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            int port = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(3)).jjtGetValue());
            try {
                ((JmriSRCPTurnoutServer)((ServiceHandler)data).getTurnoutServer()).parseStatus(bus, address, port);
            }
            catch (JmriException jmriException) {
            }
            catch (IOException iOException) {}
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("FB") && this.isSupported(bus, "FB")) {
            int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            int value = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(3)).jjtGetValue());
            try {
                ((JmriSRCPSensorServer)((ServiceHandler)data).getSensorServer()).parseStatus(bus, address, value);
            }
            catch (IOException iOException) {}
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("SM") && this.isSupported(bus, "SM")) {
            ProgrammingMode modeno = ProgrammingMode.REGISTERMODE;
            if (node.jjtGetChild(3).getClass() == ASTcv.class) {
                modeno = ProgrammingMode.DIRECTBYTEMODE;
            } else if (node.jjtGetChild(3).getClass() == ASTcvbit.class) {
                modeno = ProgrammingMode.DIRECTBITMODE;
            }
            int cv = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(4)).jjtGetValue());
            int value = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(5)).jjtGetValue());
            ((JmriSRCPProgrammerServer)((ServiceHandler)data).getProgrammerServer()).writeCV(modeno, cv, value);
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("GL") && this.isSupported(bus, "GL")) {
            int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            String drivemode = (String)((SimpleNode)node.jjtGetChild(3)).jjtGetValue();
            int speedstep = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(4)).jjtGetValue());
            int maxspeedstep = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(5)).jjtGetValue());
            ((JmriSRCPThrottleServer)((ServiceHandler)data).getThrottleServer()).setThrottleSpeedAndDirection(bus, address, (float)speedstep / (float)maxspeedstep, drivemode.equals("0"));
            int numFunctions = node.jjtGetNumChildren() - 6;
            ArrayList<Boolean> functionList = new ArrayList<Boolean>();
            int i = 0;
            while (i < numFunctions) {
                String functionMode = (String)((SimpleNode)node.jjtGetChild(i + 6)).jjtGetValue();
                functionList.add(functionMode.equals("1"));
                ++i;
            }
            ((JmriSRCPThrottleServer)((ServiceHandler)data).getThrottleServer()).setThrottleFunctions(bus, address, functionList);
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("TIME")) {
            try {
                JmriSRCPTimeServer ts = (JmriSRCPTimeServer)((ServiceHandler)data).getTimeServer();
                int julDay = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
                int hour = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(3)).jjtGetValue());
                int minute = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(4)).jjtGetValue());
                int second = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(4)).jjtGetValue());
                ts.parseTime(julDay, hour, minute, second);
                ts.startTime();
                ts.sendTime();
            }
            catch (IOException iOException) {}
        } else {
            this.outputString = "422 ERROR unsupported device group";
        }
        return data;
    }

    @Override
    public Object visit(ASTterm node, Object data) {
        SimpleNode target = (SimpleNode)node.jjtGetChild(1);
        int bus = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(0)).jjtGetValue());
        log.debug("TERM {} {}", (Object)bus, target.jjtGetValue());
        if (target.jjtGetValue().equals("SERVER")) {
            this.outputString = "200 OK";
            return data;
        }
        if (target.jjtGetValue().equals("SESSION")) {
            this.outputString = "102 INFO " + bus + " SESSION " + ((JmriSRCPServiceHandler)data).getSessionNumber();
            return data;
        }
        if (target.jjtGetValue().equals("GL")) {
            int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            try {
                ((JmriSRCPThrottleServer)((ServiceHandler)data).getThrottleServer()).releaseThrottle(bus, address);
            }
            catch (IOException iOException) {
                log.error("Error writing to network port");
            }
            return data;
        }
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTreset node, Object data) {
        log.debug("RESET {}", ((SimpleNode)node.jjtGetChild(1)).jjtGetValue());
        if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("SERVER")) {
            this.outputString = "413 ERROR temporarily prohibited";
            return data;
        }
        this.outputString = "422 ERROR unsupported device group";
        return node.childrenAccept(this, data);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object visit(ASTinit node, Object data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[13] lbl87 : CaseStatement: default:\u000a, @NONE, blocks:[13] lbl87 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Object visit(ASTwait_cmd node, Object data) {
        log.debug("Received WAIT CMD {}", node.jjtGetValue());
        if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("TIME")) {
            long julday = Long.parseLong((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            int Hour = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(3)).jjtGetValue());
            int Minute = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(4)).jjtGetValue());
            int Second = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(5)).jjtGetValue());
            ((JmriSRCPTimeServer)((ServiceHandler)data).getTimeServer()).setAlarm(julday, Hour, Minute, Second);
        } else {
            this.outputString = ((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("FB") ? "425 ERROR not supported" : "423 ERROR unsupported operation";
        }
        return data;
    }
}

