/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.srcp;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import jmri.JmriException;
import jmri.TimebaseRateException;
import jmri.jmris.AbstractTimeServer;
import jmri.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriSRCPTimeServer
extends AbstractTimeServer {
    private final OutputStream output;
    private int modelrate = 1;
    private int realrate = 1;
    private ArrayList<GregorianCalendar> alarmList = null;
    private static final Logger log = LoggerFactory.getLogger(JmriSRCPTimeServer.class);

    public JmriSRCPTimeServer(OutputStream outStream) {
        this.output = outStream;
    }

    @Override
    public void sendTime() throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("HH mm ss");
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.timebase.getTime());
        long day = DateUtil.julianDayFromCalendar(cal);
        this.output.write(("100 INFO 0 TIME " + day + " " + sdf.format(this.timebase.getTime()) + "\n\r").getBytes());
    }

    @Override
    public void sendRate() throws IOException {
        this.output.write(("101 INFO 0 TIME " + this.modelrate + " " + this.realrate + "\n\r").getBytes());
    }

    @Override
    public void sendStatus() throws IOException {
    }

    @Override
    public void sendErrorStatus() throws IOException {
    }

    @Override
    public void parseTime(String statusString) throws JmriException, IOException {
    }

    public void parseTime(long JulDay, int Hour, int Minute, int Second) {
        GregorianCalendar cal = DateUtil.calFromJulianDate(JulDay);
        cal.set(10, Hour);
        cal.set(12, Minute);
        cal.set(13, Second);
        this.timebase.userSetTime(cal.getTime());
    }

    @Override
    public void parseRate(String statusString) throws JmriException, IOException {
    }

    public void parseRate(int modelRate, int realRate) {
        this.modelrate = modelRate;
        this.realrate = realRate;
        try {
            this.timebase.userSetRate((double)modelRate / (double)realRate);
        }
        catch (TimebaseRateException ex) {
            log.error("Something went wrong", (Throwable)ex);
        }
    }

    @Override
    public void stopTime() {
        super.stopTime();
    }

    public void setAlarm(long JulDay, int Hour, int Minute, int Second) {
        if (log.isDebugEnabled()) {
            log.debug("setting alarm for {} {}:{}:{}", new Object[]{JulDay, Hour, Minute, Second});
        }
        GregorianCalendar cal = DateUtil.calFromJulianDate(JulDay);
        cal.set(10, Hour);
        cal.set(12, Minute);
        cal.set(13, Second);
        GregorianCalendar now = new GregorianCalendar();
        now.setTime(this.timebase.getTime());
        if (now.after(cal)) {
            try {
                this.sendTime();
            }
            catch (IOException ex) {
                log.warn("Unable to send message to client: {}", (Object)ex.getMessage());
            }
        } else {
            if (this.alarmList == null) {
                this.alarmList = new ArrayList();
            }
            this.alarmList.add(cal);
            this.listenToTimebase(true);
            try {
                this.output.write("200 Ok\n\r".getBytes());
            }
            catch (IOException ie) {
                log.warn("Unable to send message to client: {}", (Object)ie.getMessage());
            }
        }
    }

    private void checkAlarmList() throws IOException {
        if (this.alarmList == null) {
            return;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.timebase.getTime());
        if (log.isDebugEnabled()) {
            log.debug("checking alarms at {} {}:{}:{}", new Object[]{DateUtil.julianDayFromCalendar(cal), cal.get(11), cal.get(12), cal.get(13)});
        }
        Iterator<GregorianCalendar> alarm = this.alarmList.iterator();
        while (alarm.hasNext()) {
            if (!cal.after(alarm.next())) continue;
            this.sendTime();
            alarm.remove();
        }
    }

    @Override
    public void listenToTimebase(boolean listen) {
        if (!listen && this.timeListener == null) {
            return;
        }
        if (this.timeListener == null) {
            this.timeListener = evt -> {
                try {
                    if (evt.getPropertyName().equals("minutes")) {
                        this.checkAlarmList();
                    }
                }
                catch (IOException ex) {
                    log.warn("Unable to send message to client: {}", (Object)ex.getMessage());
                    this.timebase.removeMinuteChangeListener(this.timeListener);
                }
            };
        }
        if (listen) {
            this.timebase.addMinuteChangeListener(this.timeListener);
        } else {
            this.timebase.removeMinuteChangeListener(this.timeListener);
        }
    }
}

