/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.srcp;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.SystemConnectionMemo;
import jmri.Throttle;
import jmri.ThrottleListener;
import jmri.ThrottleManager;
import jmri.jmris.AbstractThrottleServer;
import jmri.jmris.srcp.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriSRCPThrottleServer
extends AbstractThrottleServer {
    private static final Logger log = LoggerFactory.getLogger(JmriSRCPThrottleServer.class);
    private final OutputStream output;
    private final ArrayList<Integer> busList = new ArrayList();
    private final ArrayList<LocoAddress> addressList = new ArrayList();

    public JmriSRCPThrottleServer(DataInputStream inStream, OutputStream outStream) {
        this.output = outStream;
    }

    @Override
    public void sendStatus(LocoAddress l) throws IOException {
        this.output.write(Bundle.getMessage("Error499").getBytes());
    }

    public void sendStatus(int bus, int address) throws IOException {
        SystemConnectionMemo memo;
        log.debug("send Status called with bus {} and address {}", (Object)bus, (Object)address);
        List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
        try {
            memo = list.get(bus - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.output.write(Bundle.getMessage("Error412").getBytes());
            return;
        }
        if (memo.provides(ThrottleManager.class)) {
            ThrottleManager t = (ThrottleManager)memo.get(ThrottleManager.class);
            DccLocoAddress addr = new DccLocoAddress(address, !t.canBeShortAddress(address));
            Boolean isForward = (Boolean)t.getThrottleInfo(addr, "IsForward");
            Float speedSetting = (Float)t.getThrottleInfo(addr, "SpeedSetting");
            SpeedStepMode speedStepMode = (SpeedStepMode)((Object)t.getThrottleInfo(addr, "SpeedStepsMode"));
            Boolean f0 = (Boolean)t.getThrottleInfo(addr, "F0");
            Boolean f1 = (Boolean)t.getThrottleInfo(addr, "F1");
            Boolean f2 = (Boolean)t.getThrottleInfo(addr, "F2");
            Boolean f3 = (Boolean)t.getThrottleInfo(addr, "F3");
            Boolean f4 = (Boolean)t.getThrottleInfo(addr, "F4");
            Boolean f5 = (Boolean)t.getThrottleInfo(addr, "F5");
            Boolean f6 = (Boolean)t.getThrottleInfo(addr, "F6");
            Boolean f7 = (Boolean)t.getThrottleInfo(addr, "F7");
            Boolean f8 = (Boolean)t.getThrottleInfo(addr, "F8");
            Boolean f9 = (Boolean)t.getThrottleInfo(addr, "F9");
            Boolean f10 = (Boolean)t.getThrottleInfo(addr, "F10");
            Boolean f11 = (Boolean)t.getThrottleInfo(addr, "F11");
            Boolean f12 = (Boolean)t.getThrottleInfo(addr, "F12");
            Boolean f13 = (Boolean)t.getThrottleInfo(addr, "F13");
            Boolean f14 = (Boolean)t.getThrottleInfo(addr, "F14");
            Boolean f15 = (Boolean)t.getThrottleInfo(addr, "F15");
            Boolean f16 = (Boolean)t.getThrottleInfo(addr, "F16");
            Boolean f17 = (Boolean)t.getThrottleInfo(addr, "F17");
            Boolean f18 = (Boolean)t.getThrottleInfo(addr, "F18");
            Boolean f19 = (Boolean)t.getThrottleInfo(addr, "F19");
            Boolean f20 = (Boolean)t.getThrottleInfo(addr, "F20");
            Boolean f21 = (Boolean)t.getThrottleInfo(addr, "F21");
            Boolean f22 = (Boolean)t.getThrottleInfo(addr, "F22");
            Boolean f23 = (Boolean)t.getThrottleInfo(addr, "F23");
            Boolean f24 = (Boolean)t.getThrottleInfo(addr, "F24");
            Boolean f25 = (Boolean)t.getThrottleInfo(addr, "F25");
            Boolean f26 = (Boolean)t.getThrottleInfo(addr, "F26");
            Boolean f27 = (Boolean)t.getThrottleInfo(addr, "F27");
            Boolean f28 = (Boolean)t.getThrottleInfo(addr, "F28");
            String StatusString = "100 INFO " + bus + " GL " + address + " ";
            StatusString = String.valueOf(StatusString) + (isForward != false ? "1 " : "0 ");
            int numSteps = 100;
            switch (speedStepMode) {
                case NMRA_DCC_128: 
                case NMRA_DCC_28: 
                case NMRA_DCC_27: 
                case NMRA_DCC_14: {
                    numSteps = speedStepMode.numSteps;
                    break;
                }
                default: {
                    numSteps = 100;
                }
            }
            StatusString = String.valueOf(StatusString) + (int)Math.ceil(speedSetting.floatValue() * (float)numSteps) + " " + numSteps;
            StatusString = String.valueOf(StatusString) + (f0 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f1 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f2 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f3 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f4 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f5 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f6 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f7 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f8 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f9 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f10 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f11 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f12 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f13 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f14 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f15 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f16 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f17 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f18 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f19 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f20 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f21 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f22 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f23 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f24 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f25 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f26 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f27 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + (f28 != false ? " 1" : " 0");
            StatusString = String.valueOf(StatusString) + "\n\r";
            this.output.write(StatusString.getBytes());
        } else {
            this.output.write(Bundle.getMessage("Error412").getBytes());
        }
    }

    @Override
    public void sendErrorStatus() throws IOException {
        this.output.write(Bundle.getMessage("Error499").getBytes());
    }

    @Override
    public void parsecommand(String statusString) throws JmriException, IOException {
    }

    @Override
    public void sendThrottleFound(LocoAddress address) throws IOException {
        if (!this.addressList.contains(address)) {
            return;
        }
        Integer bus = this.busList.get(this.addressList.indexOf(address));
        String StatusString = "101 INFO " + bus + " GL " + address.getNumber() + " ";
        StatusString = String.valueOf(StatusString) + (address.getProtocol() == LocoAddress.Protocol.DCC_SHORT ? "N 1 28" : "N 2 28");
        StatusString = String.valueOf(StatusString) + "\n\r";
        this.output.write(StatusString.getBytes());
    }

    @Override
    public void sendThrottleReleased(LocoAddress address) throws IOException {
        if (!this.addressList.contains(address)) {
            return;
        }
        Integer bus = this.busList.get(this.addressList.indexOf(address));
        String StatusString = "102 INFO " + bus + " GL " + address.getNumber();
        StatusString = String.valueOf(StatusString) + (address.getProtocol() == LocoAddress.Protocol.DCC_SHORT ? "N 1 28" : "N 2 28");
        StatusString = String.valueOf(StatusString) + "\n\r";
        this.output.write(StatusString.getBytes());
    }

    public void initThrottle(int bus, int address, boolean isLong, int speedsteps, int functions) throws IOException {
        SystemConnectionMemo memo;
        log.debug("initThrottle called with bus {} and address {}", (Object)bus, (Object)address);
        List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
        try {
            memo = list.get(bus - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.output.write(Bundle.getMessage("Error412").getBytes());
            return;
        }
        if (memo.provides(ThrottleManager.class)) {
            ThrottleManager t = (ThrottleManager)memo.get(ThrottleManager.class);
            DccLocoAddress addr = new DccLocoAddress(address, isLong);
            this.busList.add(bus);
            this.addressList.add(addr);
            t.requestThrottle(addr, (ThrottleListener)this, false);
        }
    }

    public void releaseThrottle(int bus, int address) throws IOException {
        SystemConnectionMemo memo;
        log.debug("releaseThrottle called with bus {} and address {}", (Object)bus, (Object)address);
        List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
        try {
            memo = list.get(bus - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.output.write(Bundle.getMessage("Error412").getBytes());
            return;
        }
        if (memo.provides(ThrottleManager.class)) {
            ThrottleManager t = (ThrottleManager)memo.get(ThrottleManager.class);
            DccLocoAddress addr = new DccLocoAddress(address, t.canBeLongAddress(address));
            t.releaseThrottle((DccThrottle)this.throttleList.get(this.addressList.indexOf(addr)), this);
            this.throttleList.remove(this.addressList.indexOf(addr));
            this.sendThrottleReleased(addr);
            this.busList.remove(this.addressList.indexOf(addr));
            this.addressList.remove(addr);
        }
    }

    public void setThrottleSpeedAndDirection(int bus, int address, float speed, boolean isForward) {
        ThrottleManager tm;
        DccLocoAddress addr;
        SystemConnectionMemo memo;
        log.debug("Setting Speed for address {} bus {} to {} with direction {}", new Object[]{address, bus, Float.valueOf(speed), isForward ? "forward" : "reverse"});
        List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
        try {
            memo = list.get(bus - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            try {
                this.output.write(Bundle.getMessage("Error412").getBytes());
            }
            catch (IOException iOException) {
                log.error("Error writing to network port");
            }
            return;
        }
        if (memo.provides(ThrottleManager.class) && this.addressList.contains(addr = new DccLocoAddress(address, (tm = (ThrottleManager)memo.get(ThrottleManager.class)).canBeLongAddress(address)))) {
            log.debug("Throttle in throttle list");
            Throttle t = (Throttle)this.throttleList.get(this.addressList.indexOf(addr));
            t.setSpeedSetting(speed);
            t.setIsForward(isForward);
        }
    }

    public void setThrottleFunctions(int bus, int address, ArrayList<Boolean> fList) {
        ThrottleManager tm;
        DccLocoAddress addr;
        SystemConnectionMemo memo;
        log.debug("Setting Functions for address {} bus {}", (Object)address, (Object)bus);
        List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
        try {
            memo = list.get(bus - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            try {
                this.output.write(Bundle.getMessage("Error412").getBytes());
            }
            catch (IOException iOException) {
                log.error("Error writing to network port");
            }
            return;
        }
        if (memo.provides(ThrottleManager.class) && this.addressList.contains(addr = new DccLocoAddress(address, (tm = (ThrottleManager)memo.get(ThrottleManager.class)).canBeLongAddress(address)))) {
            log.debug("Throttle in throttle list");
            Throttle t = (Throttle)this.throttleList.get(this.addressList.indexOf(addr));
            this.setFunctionsByThrottle(t, fList);
        }
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        log.debug("notified throttle found");
        this.throttleList.add(t);
        try {
            this.sendThrottleFound(t.getLocoAddress());
            t.addPropertyChangeListener(new SRCPThrottlePropertyChangeListener(this, t, this.busList.get(this.addressList.indexOf(t.getLocoAddress()))));
        }
        catch (IOException iOException) {}
    }

    static class SRCPThrottlePropertyChangeListener
    implements PropertyChangeListener {
        int bus;
        int address;
        JmriSRCPThrottleServer clientServer = null;

        SRCPThrottlePropertyChangeListener(JmriSRCPThrottleServer ts, Throttle t, int bus) {
            log.debug("property change listener created");
            this.clientServer = ts;
            this.bus = bus;
            this.address = t.getLocoAddress().getNumber();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (log.isDebugEnabled()) {
                log.debug("Property change event received {} / {}", (Object)e.getPropertyName(), e.getNewValue());
            }
            block8 : switch (e.getPropertyName()) {
                case "SpeedSteps": 
                case "SpeedSetting": 
                case "IsForward": {
                    try {
                        this.clientServer.sendStatus(this.bus, this.address);
                    }
                    catch (IOException iOException) {
                        log.error("Error writing to network port");
                    }
                    break;
                }
                default: {
                    int i = 0;
                    while (i <= 28) {
                        if (e.getPropertyName().equals("F" + i)) {
                            try {
                                this.clientServer.sendStatus(this.bus, this.address);
                            }
                            catch (IOException iOException) {
                                log.error("Error writing to network port");
                            }
                            break block8;
                        }
                        if (e.getPropertyName().equals("F" + i + "Momentary")) {
                            try {
                                this.clientServer.sendStatus(this.bus, this.address);
                            }
                            catch (IOException iOException) {
                                log.error("Error writing to network port");
                            }
                            break block8;
                        }
                        ++i;
                    }
                    break block8;
                }
            }
        }
    }
}

