/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.srcp;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SystemConnectionMemo;
import jmri.jmris.AbstractSensorServer;
import jmri.jmris.srcp.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriSRCPSensorServer
extends AbstractSensorServer
implements PropertyChangeListener {
    private static final String ERROR = "Error499";
    private OutputStream output;
    private static final Logger log = LoggerFactory.getLogger(JmriSRCPSensorServer.class);

    public JmriSRCPSensorServer(DataInputStream inStream, OutputStream outStream) {
        this.output = outStream;
    }

    @Override
    public void sendStatus(String sensorName, int Status2) throws IOException {
        int bus = 0;
        int address = 0;
        List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
        for (SystemConnectionMemo memo : list) {
            String prefix = memo.getSystemPrefix();
            if (sensorName.startsWith(prefix)) {
                try {
                    address = Integer.parseInt(sensorName.substring(prefix.length() + 1));
                    break;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++bus;
        }
        if (bus > list.size()) {
            this.output.write(Bundle.getMessage(ERROR).getBytes());
            return;
        }
        if (Status2 == 2) {
            this.output.write(("100 INFO " + bus + " FB " + address + " 1\n\r").getBytes());
        } else if (Status2 == 4) {
            this.output.write(("100 INFO " + bus + " FB " + address + " 0\n\r").getBytes());
        } else {
            this.output.write(Bundle.getMessage("Error411").getBytes());
        }
    }

    public void sendStatus(int bus, int address) throws IOException {
        SystemConnectionMemo memo;
        log.debug("send Status called with bus {} and address {}", (Object)bus, (Object)address);
        List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
        try {
            memo = list.get(bus);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.output.write(Bundle.getMessage("Error412").getBytes());
            return;
        }
        String sensorName = String.valueOf(memo.getSystemPrefix()) + "S" + address;
        try {
            int Status2 = InstanceManager.getDefault(SensorManager.class).provideSensor(sensorName).getKnownState();
            if (Status2 == 2) {
                this.output.write(("100 INFO " + bus + " FB " + address + " 1\n\r").getBytes());
            } else if (Status2 == 4) {
                this.output.write(("100 INFO " + bus + " FB " + address + " 0\n\r").getBytes());
            } else {
                this.output.write(Bundle.getMessage("Error411").getBytes());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Failed to provide Sensor \"{}\" in sendStatus", (Object)sensorName);
        }
    }

    @Override
    public void sendErrorStatus(String sensorName) throws IOException {
        this.output.write(Bundle.getMessage(ERROR).getBytes());
    }

    @Override
    public void parseStatus(String statusString) throws JmriException, IOException {
        this.output.write(Bundle.getMessage(ERROR).getBytes());
    }

    public void parseStatus(int bus, int address, int value) throws IOException {
        SystemConnectionMemo memo;
        log.debug("parse Status called with bus {} address {} and value {}", new Object[]{bus, address, value});
        List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
        try {
            memo = list.get(bus - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.output.write("412 ERROR wrong value\n\r".getBytes());
            return;
        }
        String sensorName = String.valueOf(memo.getSystemPrefix()) + "S" + address;
        this.initSensor(sensorName);
        if (value == 0) {
            if (log.isDebugEnabled()) {
                log.debug("Setting Sensor INACTIVE");
            }
            this.setSensorInactive(sensorName);
        } else if (value == 1) {
            if (log.isDebugEnabled()) {
                log.debug("Setting Sensor ACTIVE");
            }
            this.setSensorActive(sensorName);
        }
    }

    @Override
    protected synchronized void addSensorToList(String sensorName) {
        Sensor s = InstanceManager.getDefault(SensorManager.class).getSensor(sensorName);
        if (s != null) {
            s.addPropertyChangeListener(this);
        }
    }

    @Override
    protected synchronized void removeSensorFromList(String sensorName) {
        Sensor s = InstanceManager.getDefault(SensorManager.class).getSensor(sensorName);
        if (s != null) {
            s.removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("KnownState")) {
            try {
                String Name2 = ((Sensor)e.getSource()).getSystemName();
                List<SystemConnectionMemo> memoList = InstanceManager.getList(SystemConnectionMemo.class);
                int i = 0;
                for (SystemConnectionMemo memo : memoList) {
                    String prefix = memo.getSystemPrefix();
                    if (Name2.startsWith(prefix)) {
                        int address = Integer.parseInt(Name2.substring(prefix.length() + 1));
                        this.sendStatus(i, address);
                        break;
                    }
                    ++i;
                }
            }
            catch (IOException iOException) {
                log.error("Error Sending Status");
            }
        }
    }
}

