/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.srcp;

import java.io.IOException;
import java.io.OutputStream;
import jmri.JmriException;
import jmri.jmris.AbstractProgrammerServer;
import jmri.jmris.srcp.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriSRCPProgrammerServer
extends AbstractProgrammerServer {
    private OutputStream output;
    private static final Logger log = LoggerFactory.getLogger(JmriSRCPProgrammerServer.class);

    public JmriSRCPProgrammerServer(OutputStream outStream) {
        this.output = outStream;
    }

    @Override
    public void sendStatus(int CV, int value, int status) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("sendStatus called for CV {} with value {} and status {}", new Object[]{CV, value, status});
        }
        if (status == 0) {
            this.output.write(("100 INFO 1 SM " + CV + " CV " + value + "\n\r").getBytes());
        } else {
            this.output.write(Bundle.getMessage("Error416").getBytes());
        }
    }

    @Override
    public void sendNotAvailableStatus() throws IOException {
        this.output.write(Bundle.getMessage("Error499").getBytes());
    }

    @Override
    public void parseRequest(String statusString) throws JmriException, IOException {
    }
}

