/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.srcp;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.OutputStream;
import jmri.JmriException;
import jmri.jmris.AbstractPowerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriSRCPPowerServer
extends AbstractPowerServer {
    private OutputStream output;
    private static final Logger log = LoggerFactory.getLogger(JmriSRCPPowerServer.class);

    public JmriSRCPPowerServer(OutputStream outStream) {
        this.output = outStream;
        this.mgrOK();
    }

    @Override
    public void sendStatus(int Status2) throws IOException {
        if (Status2 == 2) {
            this.output.write("100 INFO 0 POWER ON\n\r".getBytes());
        } else if (Status2 == 4) {
            this.output.write("100 INFO 0 POWER OFF\n\r".getBytes());
        } else {
            this.output.write("411 ERROR unknown value\n\r".getBytes());
        }
    }

    @Override
    public void sendErrorStatus() throws IOException {
        this.output.write("499 ERROR unspecified error\n\r".getBytes());
    }

    @Override
    public void parseStatus(String statusString) throws JmriException {
        if (statusString.contains("ON")) {
            if (log.isDebugEnabled()) {
                log.debug("Setting Power ON");
            }
            this.setOnStatus();
        } else if (statusString.contains("OFF")) {
            if (log.isDebugEnabled()) {
                log.debug("Setting Power OFF");
            }
            this.setOffStatus();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        try {
            if (this.p.getPower() == 2 || this.p.getPower() == 4) {
                this.sendStatus(this.p.getPower());
            }
        }
        catch (IOException iOException) {}
    }
}

