/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.simpleserver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.jmris.AbstractSignalHeadServer;
import jmri.jmris.JmriConnection;

public class SimpleSignalHeadServer
extends AbstractSignalHeadServer {
    private DataOutputStream output;
    private JmriConnection connection;

    public SimpleSignalHeadServer(JmriConnection connection) {
        this.connection = connection;
    }

    public SimpleSignalHeadServer(DataInputStream inStream, DataOutputStream outStream) {
        this.output = outStream;
    }

    @Override
    public void sendStatus(String signalHeadName, int Status2) throws IOException {
        this.addSignalHeadToList(signalHeadName);
        this.sendMessage("SIGNALHEAD " + signalHeadName + " " + this.nameForAppearance(Status2) + "\n");
    }

    @Override
    public void sendErrorStatus(String signalHeadName) throws IOException {
        this.sendMessage("SIGNALHEAD ERROR\n");
    }

    @Override
    public void parseStatus(String statusString) throws JmriException, IOException {
        String[] status = statusString.split("\\s+");
        if (status.length == 3) {
            this.setSignalHeadAppearance(status[1], status[2]);
        } else {
            SignalHead signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(status[1]);
            if (signalHead != null) {
                this.sendStatus(signalHead.getSystemName(), signalHead.getAppearance());
            } else {
                this.sendErrorStatus(status[1]);
            }
        }
    }

    private void sendMessage(String message) throws IOException {
        if (this.output != null) {
            this.output.writeBytes(message);
        } else {
            this.connection.sendMessage(message);
        }
    }
}

