/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.simpleserver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmris.AbstractSensorServer;
import jmri.jmris.JmriConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSensorServer
extends AbstractSensorServer {
    private static final String SENSOR = "SENSOR ";
    private DataOutputStream output;
    private JmriConnection connection;
    private static final Logger log = LoggerFactory.getLogger(SimpleSensorServer.class);

    public SimpleSensorServer(JmriConnection connection) {
        this.connection = connection;
    }

    public SimpleSensorServer(DataInputStream inStream, DataOutputStream outStream) {
        this.output = outStream;
    }

    @Override
    public void sendStatus(String sensorName, int Status2) throws IOException {
        this.addSensorToList(sensorName);
        if (Status2 == 4) {
            this.sendMessage(SENSOR + sensorName + " INACTIVE\n");
        } else if (Status2 == 2) {
            this.sendMessage(SENSOR + sensorName + " ACTIVE\n");
        } else {
            this.sendMessage(SENSOR + sensorName + " UNKNOWN\n");
        }
    }

    @Override
    public void sendErrorStatus(String sensorName) throws IOException {
        this.sendMessage("SENSOR ERROR\n");
    }

    @Override
    public void parseStatus(String statusString) throws JmriException, IOException {
        int index = statusString.indexOf(32) + 1;
        if (statusString.contains("INACTIVE")) {
            if (log.isDebugEnabled()) {
                log.debug("Setting Sensor INACTIVE");
            }
            this.initSensor(statusString.substring(index, statusString.indexOf(32, index + 1)));
            this.setSensorInactive(statusString.substring(index, statusString.indexOf(32, index + 1)));
        } else if (statusString.contains("ACTIVE")) {
            if (log.isDebugEnabled()) {
                log.debug("Setting Sensor ACTIVE");
            }
            this.initSensor(statusString.substring(index, statusString.indexOf(32, index + 1)));
            this.setSensorActive(statusString.substring(index, statusString.indexOf(32, index + 1)));
        } else {
            String sensorName = statusString.substring(index);
            if (sensorName.contains("\n")) {
                sensorName = sensorName.substring(0, sensorName.indexOf(10));
            }
            if (sensorName.contains(" ")) {
                sensorName = sensorName.substring(0, sensorName.indexOf(32));
            }
            try {
                Sensor sensor = InstanceManager.getDefault(SensorManager.class).provideSensor(sensorName);
                this.sendStatus(sensorName, sensor.getKnownState());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn("Failed to provide Sensor \"{}\" in sendStatus", (Object)sensorName);
            }
        }
    }

    private void sendMessage(String message) throws IOException {
        if (this.output != null) {
            this.output.writeBytes(message);
        } else {
            this.connection.sendMessage(message);
        }
    }
}

