/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.simpleserver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jmri.JmriException;
import jmri.jmris.AbstractLightServer;
import jmri.jmris.JmriConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLightServer
extends AbstractLightServer {
    private static final String LIGHT = "LIGHT";
    private DataOutputStream output = null;
    private JmriConnection connection = null;
    private static final Logger log = LoggerFactory.getLogger(SimpleLightServer.class);

    public SimpleLightServer(JmriConnection connection) {
        this.connection = connection;
    }

    public SimpleLightServer(DataInputStream inStream, DataOutputStream outStream) {
        this.output = outStream;
    }

    @Override
    public void sendStatus(String lightName, int Status2) throws IOException {
        if (Status2 == 2) {
            this.sendMessage("LIGHT " + lightName + " ON\n");
        } else if (Status2 == 4) {
            this.sendMessage("LIGHT " + lightName + " OFF\n");
        } else {
            this.sendMessage("LIGHT " + lightName + " UNKNOWN\n");
        }
    }

    @Override
    public void sendErrorStatus(String lightName) throws IOException {
        this.sendMessage("LIGHT ERROR\n");
    }

    @Override
    public void parseStatus(String statusString) throws JmriException, IOException {
        int index = statusString.indexOf(32) + 1;
        if (statusString.contains("ON")) {
            if (log.isDebugEnabled()) {
                log.debug("Setting Light ON");
            }
            this.initLight(statusString.substring(index, statusString.indexOf(32, index + 1)));
            this.lightOn(statusString.substring(index, statusString.indexOf(32, index + 1)));
        } else if (statusString.contains("OFF")) {
            if (log.isDebugEnabled()) {
                log.debug("Setting Light OFF");
            }
            this.initLight(statusString.substring(index, statusString.indexOf(32, index + 1)));
            this.lightOff(statusString.substring(index, statusString.indexOf(32, index + 1)));
        }
    }

    private void sendMessage(String message) throws IOException {
        if (this.output != null) {
            this.output.writeBytes(message);
        } else {
            this.connection.sendMessage(message);
        }
    }
}

