/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Locale;
import jmri.JmriException;
import jmri.ProgrammingMode;
import jmri.jmris.AbstractProgrammerServer;
import jmri.jmris.JmriConnection;
import jmri.jmris.json.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JsonProgrammerServer
extends AbstractProgrammerServer {
    private final JmriConnection connection;
    private final ObjectMapper mapper;
    private static final Logger log = LoggerFactory.getLogger(JsonProgrammerServer.class);

    public JsonProgrammerServer(JmriConnection connection) {
        this.connection = connection;
        this.mapper = new ObjectMapper();
    }

    @Override
    public void sendStatus(int CV, int value, int status) throws IOException {
        log.debug("sendStatus called for CV {} with value {} and status {}", new Object[]{CV, value, status});
        if (status == 0) {
            ObjectNode root = this.mapper.createObjectNode();
            root.put("type", "programmer");
            ObjectNode data = root.putObject("data");
            data.put("CV", CV);
            data.put("value", value);
            data.put("state", status);
            this.connection.sendMessage(this.mapper.writeValueAsString((Object)root));
        } else {
            this.sendError(416, Bundle.getMessage(this.connection.getLocale(), "ErrorProgrammer416"));
        }
    }

    @Override
    public void sendNotAvailableStatus() throws IOException {
        this.sendError(499, Bundle.getMessage(this.connection.getLocale(), "ErrorProgrammer499"));
    }

    @Override
    public void parseRequest(String statusString) throws JmriException, IOException {
        this.parseRequest(Locale.getDefault(), this.mapper.readTree(statusString).path("data"));
    }

    public void parseRequest(Locale locale, JsonNode data) throws JmriException, IOException {
        ProgrammingMode mode = ProgrammingMode.REGISTERMODE;
        String requestMode = data.path("mode").asText();
        for (ProgrammingMode check : this.getProgrammer().getSupportedModes()) {
            if (requestMode.equals(check.toString())) {
                mode = check;
            }
            if (!requestMode.equals(check.getStandardName())) continue;
            mode = check;
        }
        int CV = data.path("CV").asInt();
        int value = data.path("value").asInt();
        if ("write".equals(data.path("mode").asText())) {
            this.writeCV(mode, CV, value);
        } else if ("read".equals(data.path("mode").asText())) {
            this.readCV(mode, CV);
        }
    }

    protected void sendError(int code, String message) throws IOException {
        ObjectNode root = this.mapper.createObjectNode();
        root.put("type", "error");
        ObjectNode data = root.putObject("error");
        data.put("type", "programmer");
        data.put("code", code);
        data.put("message", message);
        this.connection.sendMessage(this.mapper.writeValueAsString((Object)root));
    }
}

