/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Timebase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTimeServer {
    private static final Logger log = LoggerFactory.getLogger(AbstractTimeServer.class);
    protected PropertyChangeListener timeListener = null;
    protected Timebase timebase = null;

    public AbstractTimeServer() {
        this(InstanceManager.getDefault(Timebase.class));
    }

    public AbstractTimeServer(Timebase timebase) {
        this.timebase = timebase;
    }

    public abstract void sendTime() throws IOException;

    public abstract void sendRate() throws IOException;

    public abstract void sendStatus() throws IOException;

    public abstract void sendErrorStatus() throws IOException;

    public abstract void parseTime(String var1) throws JmriException, IOException;

    public abstract void parseRate(String var1) throws JmriException, IOException;

    public void startTime() {
        this.timebase.setRun(true);
    }

    public void stopTime() {
        this.timebase.setRun(false);
    }

    public void dispose() {
        if (this.timeListener != null) {
            this.timebase.removeMinuteChangeListener(this.timeListener);
            this.timeListener = null;
        }
        this.timebase = null;
    }

    public void listenToTimebase(boolean listen) {
        if (!listen && this.timeListener == null) {
            return;
        }
        if (this.timeListener == null) {
            this.timeListener = evt -> {
                try {
                    if (evt.getPropertyName().equals("minutes")) {
                        this.sendTime();
                    } else if (evt.getPropertyName().equals("run")) {
                        this.sendStatus();
                    } else {
                        this.sendRate();
                    }
                }
                catch (IOException ex) {
                    log.warn("Unable to send message to client: {}", (Object)ex.getMessage());
                    this.timebase.removeMinuteChangeListener(this.timeListener);
                }
            };
        }
        if (listen) {
            this.timebase.addMinuteChangeListener(this.timeListener);
        } else {
            this.timebase.removeMinuteChangeListener(this.timeListener);
        }
    }
}

