/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.server.json.JsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignalHeadServer {
    private final HashMap<String, SignalHeadListener> signalHeads = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(AbstractSignalHeadServer.class);

    public abstract void sendStatus(String var1, int var2) throws IOException;

    public abstract void sendErrorStatus(String var1) throws IOException;

    public abstract void parseStatus(String var1) throws JmriException, IOException, JsonException;

    protected synchronized void addSignalHeadToList(String signalHeadName) {
        SignalHead sh;
        if (!this.signalHeads.containsKey(signalHeadName) && (sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName)) != null) {
            SignalHeadListener shl = new SignalHeadListener(signalHeadName);
            sh.addPropertyChangeListener(shl);
            this.signalHeads.put(signalHeadName, shl);
            log.debug("Added listener to signalHead {}", (Object)signalHeadName);
        }
    }

    protected synchronized void removeSignalHeadFromList(String signalHeadName) {
        SignalHead sh;
        if (this.signalHeads.containsKey(signalHeadName) && (sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName)) != null) {
            sh.removePropertyChangeListener(this.signalHeads.get(signalHeadName));
            this.signalHeads.remove(signalHeadName);
        }
    }

    public void setSignalHeadAppearance(String signalHeadName, String signalHeadState) {
        this.setSignalHeadAppearance(signalHeadName, this.appearanceForName(signalHeadState));
    }

    protected void setSignalHeadAppearance(String signalHeadName, int signalHeadState) {
        try {
            this.addSignalHeadToList(signalHeadName);
            SignalHead signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName);
            if (signalHead == null) {
                log.error("SignalHead {} is not available.", (Object)signalHeadName);
            } else if (signalHead.getAppearance() != signalHeadState || signalHead.getHeld()) {
                if (signalHeadState == 256) {
                    signalHead.setHeld(true);
                } else {
                    if (signalHead.getHeld()) {
                        signalHead.setHeld(false);
                    }
                    signalHead.setAppearance(signalHeadState);
                }
            } else {
                try {
                    this.sendStatus(signalHeadName, signalHeadState);
                }
                catch (IOException ex) {
                    log.error("Error sending appearance", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            log.error("Exception setting signalHead {} appearance:", (Object)signalHeadName, (Object)ex);
        }
    }

    protected String nameForAppearance(int appearance) {
        switch (appearance) {
            case 0: {
                return "DARK";
            }
            case 1: {
                return "RED";
            }
            case 2: {
                return "FLASHRED";
            }
            case 4: {
                return "YELLOW";
            }
            case 8: {
                return "FLASHYELLOW";
            }
            case 16: {
                return "GREEN";
            }
            case 32: {
                return "FLASHGREEN";
            }
            case 64: {
                return "LUNAR";
            }
            case 128: {
                return "FLASHLUNAR";
            }
            case 256: {
                return "HELD";
            }
        }
        return "UNKNOWN";
    }

    protected int appearanceForName(String name) {
        if (name.equals("DARK")) {
            return 0;
        }
        if (name.equals("RED")) {
            return 1;
        }
        if (name.equals("FLASHRED")) {
            return 2;
        }
        if (name.equals("YELLOW")) {
            return 4;
        }
        if (name.equals("FLASHYELLOW")) {
            return 8;
        }
        if (name.equals("GREEN")) {
            return 16;
        }
        if (name.equals("FLASHGREEN")) {
            return 32;
        }
        if (name.equals("LUNAR")) {
            return 64;
        }
        if (name.equals("FLASHLUNARDARK")) {
            return 0;
        }
        if (name.equals("FLASHLUNAR")) {
            return 128;
        }
        return 0;
    }

    public void dispose() {
        for (Map.Entry<String, SignalHeadListener> signalHead : this.signalHeads.entrySet()) {
            SignalHead sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead.getKey());
            if (sh == null) continue;
            sh.removePropertyChangeListener(signalHead.getValue());
        }
        this.signalHeads.clear();
    }

    class SignalHeadListener
    implements PropertyChangeListener {
        String name = null;
        SignalHead signalHead = null;

        SignalHeadListener(String signalHeadName) {
            this.name = signalHeadName;
            this.signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("Appearance") || e.getPropertyName().equals("Held")) {
                SignalHead sh = (SignalHead)e.getSource();
                int state = sh.getAppearance();
                if (sh.getHeld()) {
                    state = 256;
                }
                try {
                    AbstractSignalHeadServer.this.sendStatus(this.name, state);
                }
                catch (IOException iOException) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unable to send status, removing listener from signalHead {}", (Object)this.name);
                    }
                    this.signalHead.removePropertyChangeListener(this);
                    AbstractSignalHeadServer.this.removeSignalHeadFromList(this.name);
                }
            }
        }
    }
}

