/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.SensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSensorServer {
    private static final String ERROR_SENDING_STATUS = "Error Sending Status";
    private final HashMap<String, SensorListener> sensors = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(AbstractSensorServer.class);

    public abstract void sendStatus(String var1, int var2) throws IOException;

    public abstract void sendErrorStatus(String var1) throws IOException;

    public abstract void parseStatus(String var1) throws JmriException, IOException;

    protected synchronized void addSensorToList(String sensorName) {
        Sensor s;
        if (!this.sensors.containsKey(sensorName) && (s = InstanceManager.getDefault(SensorManager.class).getSensor(sensorName)) != null) {
            SensorListener sl = new SensorListener(sensorName);
            s.addPropertyChangeListener(sl);
            this.sensors.put(sensorName, sl);
        }
    }

    protected synchronized void removeSensorFromList(String sensorName) {
        Sensor s;
        if (this.sensors.containsKey(sensorName) && (s = InstanceManager.getDefault(SensorManager.class).getSensor(sensorName)) != null) {
            s.removePropertyChangeListener(this.sensors.get(sensorName));
            this.sensors.remove(sensorName);
        }
    }

    public Sensor initSensor(String sensorName) {
        Sensor sensor = InstanceManager.getDefault(SensorManager.class).provideSensor(sensorName);
        this.addSensorToList(sensorName);
        return sensor;
    }

    public void setSensorActive(String sensorName) {
        try {
            this.addSensorToList(sensorName);
            Sensor sensor = InstanceManager.getDefault(SensorManager.class).getSensor(sensorName);
            if (sensor == null) {
                log.error("Sensor {} is not available", (Object)sensorName);
            } else if (sensor.getKnownState() != 2) {
                log.debug("changing sensor '{}' to Active ({}->{})", new Object[]{sensorName, sensor.getKnownState(), 2});
                sensor.setKnownState(2);
            } else {
                log.debug("not changing sensor '{}', already Active ({})", (Object)sensorName, (Object)sensor.getKnownState());
                this.sendStatusWithErrorHandling(sensorName, 2);
            }
        }
        catch (JmriException ex) {
            log.error("set sensor active", (Throwable)ex);
        }
    }

    public void dispose() {
        for (Map.Entry<String, SensorListener> sensor : this.sensors.entrySet()) {
            Sensor s = InstanceManager.getDefault(SensorManager.class).getSensor(sensor.getKey());
            if (s == null) continue;
            s.removePropertyChangeListener(sensor.getValue());
        }
        this.sensors.clear();
    }

    public void setSensorInactive(String sensorName) {
        try {
            this.addSensorToList(sensorName);
            Sensor sensor = InstanceManager.getDefault(SensorManager.class).getSensor(sensorName);
            if (sensor == null) {
                log.error("Sensor {} is not available", (Object)sensorName);
            } else if (sensor.getKnownState() != 4) {
                log.debug("changing sensor '{}' to InActive ({}->{})", new Object[]{sensorName, sensor.getKnownState(), 4});
                sensor.setKnownState(4);
            } else {
                log.debug("not changing sensor '{}', already InActive ({})", (Object)sensorName, (Object)sensor.getKnownState());
                this.sendStatusWithErrorHandling(sensorName, 4);
            }
        }
        catch (JmriException ex) {
            log.error("set sensor inactive", (Throwable)ex);
        }
    }

    private void sendStatusWithErrorHandling(String sensorName, int status) {
        try {
            this.sendStatus(sensorName, status);
        }
        catch (IOException iOException) {
            log.error(ERROR_SENDING_STATUS);
        }
    }

    class SensorListener
    implements PropertyChangeListener {
        String name = null;
        Sensor sensor = null;

        SensorListener(String sensorName) {
            this.name = sensorName;
            this.sensor = InstanceManager.getDefault(SensorManager.class).getSensor(sensorName);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("KnownState")) {
                int now = (Integer)e.getNewValue();
                try {
                    AbstractSensorServer.this.sendStatus(this.name, now);
                }
                catch (IOException iOException) {
                    log.debug(AbstractSensorServer.ERROR_SENDING_STATUS);
                    this.sensor.removePropertyChangeListener(this);
                    AbstractSensorServer.this.removeSensorFromList(this.name);
                }
            }
        }
    }
}

