/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Reporter;
import jmri.ReporterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReporterServer {
    private final HashMap<String, ReporterListener> reporters = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(AbstractReporterServer.class);

    public abstract void sendReport(String var1, Object var2) throws IOException;

    public abstract void sendErrorStatus(String var1) throws IOException;

    public abstract void parseStatus(String var1) throws JmriException, IOException;

    protected synchronized void addReporterToList(String reporterName) {
        if (!this.reporters.containsKey(reporterName)) {
            this.reporters.put(reporterName, new ReporterListener(reporterName));
            Reporter reporter = InstanceManager.getDefault(ReporterManager.class).getReporter(reporterName);
            if (reporter != null) {
                reporter.addPropertyChangeListener(this.reporters.get(reporterName));
            }
        }
    }

    protected synchronized void removeReporterFromList(String reporterName) {
        if (this.reporters.containsKey(reporterName)) {
            Reporter reporter = InstanceManager.getDefault(ReporterManager.class).getReporter(reporterName);
            if (reporter != null) {
                reporter.removePropertyChangeListener(this.reporters.get(reporterName));
            }
            this.reporters.remove(reporterName);
        }
    }

    public Reporter initReporter(String reporterName) throws IllegalArgumentException {
        Reporter reporter = InstanceManager.getDefault(ReporterManager.class).provideReporter(reporterName);
        this.addReporterToList(reporterName);
        return reporter;
    }

    public void setReporterReport(String reporterName, Object r) {
        try {
            this.addReporterToList(reporterName);
            Reporter reporter = InstanceManager.getDefault(ReporterManager.class).getReporter(reporterName);
            if (reporter == null) {
                log.error("Reporter {} is not available", (Object)reporterName);
            } else {
                log.debug("about to set reporter State");
                reporter.setReport(r);
            }
        }
        catch (Exception ex) {
            log.error("set reporter report", (Throwable)ex);
        }
    }

    public void dispose() {
        for (Map.Entry<String, ReporterListener> entry : this.reporters.entrySet()) {
            Reporter reporter = InstanceManager.getDefault(ReporterManager.class).getReporter(entry.getKey());
            if (reporter == null) continue;
            reporter.removePropertyChangeListener(entry.getValue());
        }
        this.reporters.clear();
    }

    class ReporterListener
    implements PropertyChangeListener {
        String name = null;
        Reporter reporter = null;

        ReporterListener(String reporterName) {
            this.name = reporterName;
            this.reporter = InstanceManager.getDefault(ReporterManager.class).getReporter(reporterName);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("currentReport")) {
                String now;
                try {
                    now = e.getNewValue().toString();
                }
                catch (NullPointerException nullPointerException) {
                    now = null;
                }
                try {
                    AbstractReporterServer.this.sendReport(this.name, now);
                }
                catch (IOException iOException) {
                    log.debug("Error Sending Status");
                    this.reporter.removePropertyChangeListener(this);
                    AbstractReporterServer.this.removeReporterFromList(this.name);
                }
            }
        }
    }
}

