/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.io.IOException;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProgrammerServer
implements ProgListener {
    private Programmer p = null;
    protected int lastCV = -1;
    private static final Logger log = LoggerFactory.getLogger(AbstractProgrammerServer.class);

    protected Programmer getProgrammer() {
        return this.p;
    }

    public AbstractProgrammerServer() {
        if (InstanceManager.getNullableDefault(GlobalProgrammerManager.class) != null) {
            this.p = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer();
        } else {
            log.warn("no Service Mode ProgrammerManager configured, network programming disabled");
        }
    }

    public abstract void sendStatus(int var1, int var2, int var3) throws IOException;

    public abstract void sendNotAvailableStatus() throws IOException;

    public abstract void parseRequest(String var1) throws JmriException, IOException;

    public void writeCV(ProgrammingMode mode, int CV, int value) {
        if (this.p == null) {
            try {
                this.sendNotAvailableStatus();
            }
            catch (IOException iOException) {}
            return;
        }
        this.lastCV = CV;
        try {
            this.p.setMode(mode);
            this.p.writeCV(String.valueOf(CV), value, this);
        }
        catch (ProgrammerException programmerException) {
            try {
                this.sendNotAvailableStatus();
            }
            catch (IOException iOException) {}
        }
    }

    public void readCV(ProgrammingMode mode, int CV) {
        if (this.p == null || !this.p.getCanRead()) {
            try {
                this.sendNotAvailableStatus();
            }
            catch (IOException iOException) {}
            return;
        }
        this.lastCV = CV;
        try {
            this.p.setMode(mode);
            this.p.readCV(String.valueOf(CV), this);
        }
        catch (ProgrammerException programmerException) {
            try {
                this.sendNotAvailableStatus();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void programmingOpReply(int value, int status) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug("programmingOpReply called with value {} and status {}", (Object)value, (Object)status);
            }
            try {
                this.sendStatus(this.lastCV, value, status);
            }
            catch (IOException iOException) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Exception while sending reply");
            }
        }
    }

    public void dispose() {
    }
}

