/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperationsServer
implements PropertyChangeListener {
    protected final TrainManager tm = InstanceManager.getDefault(TrainManager.class);
    protected final LocationManager lm;
    protected final HashMap<String, TrainListener> trains;
    private static boolean exactLocationName = true;
    private static final Logger log = LoggerFactory.getLogger(AbstractOperationsServer.class);

    public AbstractOperationsServer() {
        this.tm.addPropertyChangeListener(this);
        this.lm = InstanceManager.getDefault(LocationManager.class);
        this.lm.addPropertyChangeListener(this);
        this.addPropertyChangeListeners();
        this.trains = new HashMap();
    }

    public abstract void sendTrainList();

    public abstract void sendLocationList();

    public String constructTrainStatus(String trainName) throws IOException {
        Train train = this.tm.getTrainByName(trainName);
        if (train != null) {
            return train.getStatus();
        }
        this.sendErrorStatus("ERROR train name doesn't exist " + trainName);
        return null;
    }

    public String constructTrainLocation(String trainName) throws IOException {
        Train train = this.tm.getTrainByName(trainName);
        if (train != null) {
            return train.getCurrentLocationName();
        }
        this.sendErrorStatus("ERROR train name doesn't exist " + trainName);
        return null;
    }

    public String setTrainLocation(String trainName, String locationName) throws IOException {
        log.debug("Set train {} Location {}", (Object)trainName, (Object)locationName);
        Train train = this.tm.getTrainByName(trainName);
        if (train != null) {
            if (!exactLocationName && train.move(locationName) || exactLocationName && train.moveToNextLocation(locationName)) {
                return this.constructTrainLocation(trainName);
            }
            this.sendErrorStatus("WARNING move of " + trainName + " to location " + locationName + " failed. Train's current location " + train.getCurrentLocationName() + " next location " + train.getNextLocationName());
        } else {
            this.sendErrorStatus("ERROR train name doesn't exist " + trainName);
        }
        return null;
    }

    public static void setExactLocationName(boolean enabled) {
        exactLocationName = enabled;
    }

    public static boolean isExactLoationNameEnabled() {
        return exactLocationName;
    }

    public String constructTrainLength(String trainName) throws IOException {
        Train train = this.tm.getTrainByName(trainName);
        if (train != null) {
            return String.valueOf(train.getTrainLength());
        }
        this.sendErrorStatus("ERROR train name doesn't exist " + trainName);
        return null;
    }

    public String constructTrainWeight(String trainName) throws IOException {
        Train train = this.tm.getTrainByName(trainName);
        if (train != null) {
            return String.valueOf(train.getTrainWeight());
        }
        this.sendErrorStatus("ERROR train name doesn't exist " + trainName);
        return null;
    }

    public String constructTrainNumberOfCars(String trainName) throws IOException {
        Train train = this.tm.getTrainByName(trainName);
        if (train != null) {
            return String.valueOf(train.getNumberCarsInTrain());
        }
        this.sendErrorStatus("ERROR train name doesn't exist " + trainName);
        return null;
    }

    public String constructTrainLeadLoco(String trainName) throws IOException {
        Train train = this.tm.getTrainByName(trainName);
        if (train != null) {
            Engine leadEngine = train.getLeadEngine();
            if (leadEngine != null) {
                return leadEngine.toString();
            }
        } else {
            this.sendErrorStatus("ERROR train name doesn't exist " + trainName);
        }
        return null;
    }

    public String constructTrainCaboose(String trainName) throws IOException {
        Train train = this.tm.getTrainByName(trainName);
        if (train != null) {
            return train.getCabooseRoadAndNumber();
        }
        this.sendErrorStatus("ERROR train name doesn't exist " + trainName);
        return null;
    }

    public String terminateTrain(String trainName) throws IOException {
        Train train = this.tm.getTrainByName(trainName);
        if (train != null) {
            train.terminate();
            return this.constructTrainStatus(trainName);
        }
        this.sendErrorStatus("ERROR train name doesn't exist " + trainName);
        return null;
    }

    public abstract void sendFullStatus(Train var1) throws IOException;

    private void addPropertyChangeListeners() {
        List<Train> trainList = this.tm.getTrainsByNameList();
        for (Train train : trainList) {
            train.addPropertyChangeListener(this);
        }
    }

    private void removePropertyChangeListeners() {
        List<Train> trainList = this.tm.getTrainsByNameList();
        for (Train train : trainList) {
            train.removePropertyChangeListener(this);
        }
    }

    @Override
    public abstract void propertyChange(PropertyChangeEvent var1);

    protected synchronized void addTrainToList(String trainId) {
        if (!this.trains.containsKey(trainId)) {
            this.trains.put(trainId, new TrainListener(trainId));
            InstanceManager.getDefault(TrainManager.class).getTrainById(trainId).addPropertyChangeListener(this.trains.get(trainId));
        }
    }

    protected synchronized void removeTrainFromList(String trainId) {
        if (this.trains.containsKey(trainId)) {
            InstanceManager.getDefault(TrainManager.class).getTrainById(trainId).removePropertyChangeListener(this.trains.get(trainId));
            this.trains.remove(trainId);
        }
    }

    protected TrainListener getListener(String trainId) {
        return new TrainListener(trainId);
    }

    public void dispose() {
        if (this.tm != null) {
            this.tm.removePropertyChangeListener(this);
            this.removePropertyChangeListeners();
        }
        if (this.lm != null) {
            this.lm.removePropertyChangeListener(this);
        }
        for (Map.Entry<String, TrainListener> train : this.trains.entrySet()) {
            InstanceManager.getDefault(TrainManager.class).getTrainById(train.getKey()).removePropertyChangeListener(train.getValue());
        }
        this.trains.clear();
    }

    public abstract void sendMessage(ArrayList<Attribute> var1) throws IOException;

    public abstract void sendErrorStatus(String var1) throws IOException;

    public abstract void parseStatus(String var1) throws JmriException, IOException;

    protected class TrainListener
    implements PropertyChangeListener {
        private final Train train;

        protected TrainListener(String trainId) {
            this.train = InstanceManager.getDefault(TrainManager.class).getTrainById(trainId);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            try {
                AbstractOperationsServer.this.sendFullStatus(this.train);
            }
            catch (IOException iOException) {
                log.debug("Error Sending Status");
                this.train.removePropertyChangeListener(this);
                AbstractOperationsServer.this.removeTrainFromList(this.train.getId());
            }
        }
    }
}

