/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Light;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLightServer {
    private final HashMap<String, LightListener> lights = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(AbstractLightServer.class);

    public abstract void sendStatus(String var1, int var2) throws IOException;

    public abstract void sendErrorStatus(String var1) throws IOException;

    public abstract void parseStatus(String var1) throws JmriException, IOException;

    protected synchronized void addLightToList(String lightName) {
        if (!this.lights.containsKey(lightName)) {
            Light li = InstanceManager.lightManagerInstance().getLight(lightName);
            if (li != null) {
                this.lights.put(lightName, new LightListener(lightName));
                li.addPropertyChangeListener(this.lights.get(lightName));
            } else {
                log.error("Failed to get light {}", (Object)lightName);
            }
        }
    }

    protected synchronized void removeLightFromList(String lightName) {
        if (this.lights.containsKey(lightName)) {
            Light li = InstanceManager.lightManagerInstance().getLight(lightName);
            if (li != null) {
                li.removePropertyChangeListener(this.lights.get(lightName));
                this.lights.remove(lightName);
            } else {
                log.error("Failed to get light {}", (Object)lightName);
            }
        }
    }

    public Light initLight(String lightName) throws IllegalArgumentException {
        Light light = InstanceManager.lightManagerInstance().provideLight(lightName);
        this.addLightToList(lightName);
        return light;
    }

    public void lightOff(String lightName) {
        try {
            this.addLightToList(lightName);
            Light light = InstanceManager.lightManagerInstance().getLight(lightName);
            if (light == null) {
                log.error("Light {} is not available", (Object)lightName);
            } else {
                log.debug("about to command OFF");
                light.setState(4);
            }
        }
        catch (Exception ex) {
            log.error("light off", (Throwable)ex);
        }
    }

    public void lightOn(String lightName) {
        try {
            this.addLightToList(lightName);
            Light light = InstanceManager.lightManagerInstance().getLight(lightName);
            if (light == null) {
                log.error("Light {} is not available", (Object)lightName);
            } else {
                log.debug("about to command ON");
                light.setState(2);
            }
        }
        catch (Exception ex) {
            log.error("light on", (Throwable)ex);
        }
    }

    public void dispose() {
        for (Map.Entry<String, LightListener> light : this.lights.entrySet()) {
            Light li = InstanceManager.lightManagerInstance().getLight(light.getKey());
            if (li == null) continue;
            li.removePropertyChangeListener(light.getValue());
        }
        this.lights.clear();
    }

    class LightListener
    implements PropertyChangeListener {
        Light light = null;
        String name = null;

        LightListener(String lightName) {
            this.name = lightName;
            this.light = InstanceManager.lightManagerInstance().getLight(lightName);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("KnownState")) {
                int now = (Integer)e.getNewValue();
                try {
                    AbstractLightServer.this.sendStatus(this.name, now);
                }
                catch (IOException iOException) {
                    log.debug("Error Sending Status");
                    this.light.removePropertyChangeListener(this);
                    AbstractLightServer.this.removeLightFromList(this.name);
                }
            }
        }
    }
}

