/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.swing;

import java.awt.Component;
import javax.swing.JOptionPane;
import jmri.implementation.AbstractShutDownTask;
import jmri.implementation.swing.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingShutDownTask
extends AbstractShutDownTask {
    String warning;
    String action;
    Component component;
    private boolean didPrompt = false;
    private static final Logger log = LoggerFactory.getLogger(SwingShutDownTask.class);

    public SwingShutDownTask(String name, String warning, String action, Component component) {
        super(name);
        this.component = component;
        this.warning = warning;
        this.action = action;
    }

    @Override
    public final Boolean call() {
        if (!this.checkPromptNeeded()) {
            Object[] possibleValues = this.action != null ? new Object[]{Bundle.getMessage("ButtonContinue"), Bundle.getMessage("ButtonAbort"), this.action} : new Object[]{Bundle.getMessage("ButtonContinue"), Bundle.getMessage("ButtonAbort")};
            int selectedValue = JOptionPane.showOptionDialog(this.component, this.warning, Bundle.getMessage("ShutDownWarningTitle"), -1, 2, null, possibleValues, possibleValues[possibleValues.length - 1]);
            switch (selectedValue) {
                case -1: 
                case 1: {
                    return false;
                }
                case 0: {
                    return true;
                }
                case 2: {
                    this.didPrompt = true;
                    return this.doPrompt();
                }
            }
            log.error("unexpected selection: {}", (Object)selectedValue);
            return true;
        }
        return true;
    }

    @Override
    public void run() {
        if (this.didPrompt) {
            this.didPrompt();
        }
    }

    protected boolean checkPromptNeeded() {
        return false;
    }

    protected void didPrompt() {
    }

    protected boolean doPrompt() {
        return true;
    }

    @Deprecated
    protected boolean doClose() {
        return true;
    }
}

