/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.decorators;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.IdTag;
import jmri.IdTagListener;
import jmri.JmriException;
import jmri.Reporter;
import jmri.implementation.decorators.AbstractNamedBeanDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutReporter
extends AbstractNamedBeanDecorator
implements Reporter,
IdTagListener,
PropertyChangeListener {
    private Reporter reporter;
    private static final int TIMEOUT = 2000;
    private long whenLastReported = 0L;
    private TimeoutThread timeoutThread = null;
    private static final Logger log = LoggerFactory.getLogger(TimeoutReporter.class);

    public TimeoutReporter(Reporter reporter) {
        super(reporter);
        this.reporter = reporter;
        this.reporter.addPropertyChangeListener(this);
    }

    @Override
    public Object getLastReport() {
        return this.reporter.getLastReport();
    }

    @Override
    public Object getCurrentReport() {
        return this.reporter.getCurrentReport();
    }

    @Override
    public void setReport(Object r) {
        this.reporter.setReport(r);
    }

    @Override
    public int getState() {
        return this.reporter.getState();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.reporter.dispose();
    }

    @Override
    public void setState(int i) throws JmriException {
        this.reporter.setState(i);
    }

    @Override
    public void notify(IdTag r) {
        if (this.reporter instanceof IdTagListener) {
            ((IdTagListener)((Object)this.reporter)).notify(r);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        log.debug("event received {}", (Object)evt);
        if (evt.getPropertyName().equals("currentReport") && evt.getNewValue() != null) {
            this.whenLastReported = System.currentTimeMillis();
            if (this.timeoutThread == null) {
                this.timeoutThread = new TimeoutThread();
                this.timeoutThread.start();
            }
        }
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    private void cleanUpTimeout() {
        log.debug("Cleanup timeout thread for {}", (Object)this.getSystemName());
        this.timeoutThread = null;
    }

    private class TimeoutThread
    extends Thread {
        TimeoutThread() {
            this.setName("Timeout-" + TimeoutReporter.this.getSystemName());
        }

        @Override
        public void run() {
            while (TimeoutReporter.this.whenLastReported + 2000L > System.currentTimeMillis()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            TimeoutReporter.this.reporter.setReport(null);
            log.debug("Timeout-{}", (Object)TimeoutReporter.this.getSystemName());
            TimeoutReporter.this.cleanUpTimeout();
        }
    }
}

