/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Turnout;
import jmri.implementation.TripleTurnoutSignalHead;
import jmri.implementation.configurexml.DoubleTurnoutSignalHeadXml;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripleTurnoutSignalHeadXml
extends DoubleTurnoutSignalHeadXml {
    private static final Logger log = LoggerFactory.getLogger(TripleTurnoutSignalHeadXml.class);

    @Override
    public Element store(Object o) {
        TripleTurnoutSignalHead p = (TripleTurnoutSignalHead)o;
        Element element = new Element("signalhead");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        element.addContent((Content)this.addTurnoutElement(p.getGreen(), "green"));
        element.addContent((Content)this.addTurnoutElement(p.getYellow(), "yellow"));
        element.addContent((Content)this.addTurnoutElement(p.getRed(), "red"));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        List l = shared.getChildren("turnoutname");
        if (l.size() == 0) {
            l = shared.getChildren("turnout");
        }
        NamedBeanHandle<Turnout> green = this.loadTurnout(l.get(0));
        NamedBeanHandle<Turnout> yellow = this.loadTurnout(l.get(1));
        NamedBeanHandle<Turnout> red = this.loadTurnout(l.get(2));
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        TripleTurnoutSignalHead h = uname == null ? new TripleTurnoutSignalHead(sys, green, yellow, red) : new TripleTurnoutSignalHead(sys, uname, green, yellow, red);
        this.loadCommon(h, shared);
        SignalHead existingBean = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(sys);
        if (existingBean != null && existingBean != h) {
            log.error("systemName is already registered: {}", (Object)sys);
        } else {
            InstanceManager.getDefault(SignalHeadManager.class).register(h);
        }
        return true;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }
}

