/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Turnout;
import jmri.implementation.SingleTurnoutSignalHead;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTurnoutSignalHeadXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(SingleTurnoutSignalHeadXml.class);

    @Override
    public Element store(Object o) {
        SingleTurnoutSignalHead p = (SingleTurnoutSignalHead)o;
        Element element = new Element("signalhead");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        Element el = new Element("appearance");
        el.setAttribute("defines", "thrown");
        el.addContent(this.getSignalColour(p.getOnAppearance()));
        element.addContent((Content)el);
        el = new Element("appearance");
        el.setAttribute("defines", "closed");
        el.addContent(this.getSignalColour(p.getOffAppearance()));
        element.addContent((Content)el);
        el = new Element("turnoutname");
        el.setAttribute("defines", "aspect");
        el.addContent(p.getOutput().getName());
        element.addContent((Content)el);
        return element;
    }

    private String getSignalColour(int mAppearance) {
        switch (mAppearance) {
            case 1: {
                return "red";
            }
            case 2: {
                return "flashred";
            }
            case 4: {
                return "yellow";
            }
            case 8: {
                return "flashyellow";
            }
            case 16: {
                return "green";
            }
            case 32: {
                return "flashgreen";
            }
            case 64: {
                return "lunar";
            }
            case 128: {
                return "flashlunar";
            }
            case 0: {
                return "dark";
            }
        }
        log.warn("Unexpected appearance: {}", (Object)mAppearance);
        return "dark";
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        List l = shared.getChildren("turnoutname");
        if (l.size() == 0) {
            l = shared.getChildren("turnout");
        }
        NamedBeanHandle<Turnout> lit = this.loadTurnout(l.get(0));
        int off = this.loadAppearance(shared.getChildren("appearance"), "closed");
        int on = this.loadAppearance(shared.getChildren("appearance"), "thrown");
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        SingleTurnoutSignalHead h = uname == null ? new SingleTurnoutSignalHead(sys, lit, on, off) : new SingleTurnoutSignalHead(sys, uname, lit, on, off);
        this.loadCommon(h, shared);
        SignalHead existingBean = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(sys);
        if (existingBean != null && existingBean != h) {
            log.error("systemName is already registered: {}", (Object)sys);
        } else {
            InstanceManager.getDefault(SignalHeadManager.class).register(h);
        }
        return true;
    }

    private int loadAppearance(List<Element> l, String state) {
        int i = 0;
        while (i < l.size()) {
            if (l.get(i).getAttribute("defines").getValue().equals(state)) {
                return this.getIntFromColour(l.get(i).getText());
            }
            ++i;
        }
        return 0;
    }

    NamedBeanHandle<Turnout> loadTurnout(Object o) {
        Element e = (Element)o;
        String name = e.getText();
        try {
            Turnout t = InstanceManager.turnoutManagerInstance().provideTurnout(name);
            return InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, t);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Failed to provide Turnout \"{}\" in loadTurnout", (Object)name);
            return null;
        }
    }

    private int getIntFromColour(String colour) {
        switch (colour.toLowerCase()) {
            case "red": {
                return 1;
            }
            case "yellow": {
                return 4;
            }
            case "green": {
                return 16;
            }
            case "lunar": {
                return 64;
            }
            case "dark": {
                return 0;
            }
            case "flashred": {
                return 2;
            }
            case "flashyellow": {
                return 8;
            }
            case "flashgreen": {
                return 32;
            }
            case "flashlunar": {
                return 128;
            }
        }
        log.warn("Unexpected appearance: {}", (Object)colour);
        return 0;
    }
}

