/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.implementation.SignalHeadSignalMast;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHeadSignalMastXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(SignalHeadSignalMastXml.class);

    @Override
    public Element store(Object o) {
        SignalHeadSignalMast p = (SignalHeadSignalMast)o;
        Element e = new Element("signalmast");
        e.setAttribute("class", this.getClass().getName());
        e.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, e);
        Element unlit = new Element("unlit");
        if (p.allowUnLit()) {
            unlit.setAttribute("allowed", "yes");
        } else {
            unlit.setAttribute("allowed", "no");
        }
        e.addContent((Content)unlit);
        List<String> disabledAspects = p.getDisabledAspects();
        if (disabledAspects != null) {
            Element el = new Element("disabledAspects");
            for (String aspect : disabledAspects) {
                Element ele = new Element("disabledAspect");
                ele.addContent(aspect);
                el.addContent((Content)ele);
            }
            if (disabledAspects.size() != 0) {
                e.addContent((Content)el);
            }
        }
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        Element unlit;
        SignalMast m;
        String sys = this.getSystemName(shared);
        try {
            m = InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(sys);
        }
        catch (Exception e) {
            log.error("An error occurred while trying to create the signal '{}' {}", (Object)sys, (Object)e.toString());
            return false;
        }
        if (this.getUserName(shared) != null) {
            m.setUserName(this.getUserName(shared));
        }
        this.loadCommon(m, shared);
        if (shared.getChild("unlit") != null && (unlit = shared.getChild("unlit")).getAttribute("allowed") != null) {
            if (unlit.getAttribute("allowed").getValue().equals("no")) {
                m.setAllowUnLit(false);
            } else {
                m.setAllowUnLit(true);
            }
        }
        if ((e = shared.getChild("disabledAspects")) != null) {
            List list = e.getChildren("disabledAspect");
            for (Element aspect : list) {
                ((SignalHeadSignalMast)m).setAspectDisabled(aspect.getText());
            }
        }
        return true;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }
}

