/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.configurexml;

import java.util.Enumeration;
import java.util.List;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalAppearanceMap;
import jmri.SignalMastManager;
import jmri.implementation.MatrixSignalMast;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatrixSignalMastXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(MatrixSignalMastXml.class);

    @Override
    public Element store(Object o) {
        List<String> disabledAspects;
        SignalAppearanceMap appMap;
        MatrixSignalMast p = (MatrixSignalMast)o;
        Element e = new Element("matrixsignalmast");
        e.setAttribute("class", this.getClass().getName());
        e.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, e);
        Element unlit = new Element("unlit");
        if (p.allowUnLit()) {
            unlit.setAttribute("allowed", "yes");
            unlit.addContent((Content)new Element("bitString").addContent(p.getUnLitChars()));
        } else {
            unlit.setAttribute("allowed", "no");
        }
        e.addContent((Content)unlit);
        Element delay = new Element("delay");
        if (p.getMatrixMastCommandDelay() > 0) {
            delay.setAttribute("duration", Integer.toString(p.getMatrixMastCommandDelay()));
        } else {
            delay.setAttribute("duration", "0");
        }
        e.addContent((Content)delay);
        List<String> outputs = p.getOutputs();
        Element outps = new Element("outputs");
        int i = 1;
        for (String _output : outputs) {
            log.debug("   handling {}", (Object)_output);
            String key = "output" + i;
            Element outp = new Element("output");
            outp.setAttribute("matrixCol", key);
            outp.addContent(p.getOutputName(i));
            outps.addContent((Content)outp);
            ++i;
        }
        if (outputs.size() != 0) {
            e.addContent((Content)outps);
        }
        if ((appMap = p.getAppearanceMap()) != null) {
            Element bss = new Element("bitStrings");
            Enumeration<String> aspects = appMap.getAspects();
            while (aspects.hasMoreElements()) {
                String key = aspects.nextElement();
                Element bs = new Element("bitString");
                bs.setAttribute("aspect", key);
                bs.addContent(p.getBitstring(key));
                bss.addContent((Content)bs);
            }
            e.addContent((Content)bss);
        }
        if ((disabledAspects = p.getDisabledAspects()) != null) {
            Element el = new Element("disabledAspects");
            for (String aspect : disabledAspects) {
                Element ele = new Element("disabledAspect");
                ele.addContent(aspect);
                el.addContent((Content)ele);
            }
            if (disabledAspects.size() != 0) {
                e.addContent((Content)el);
            }
        }
        if (p.resetPreviousStates()) {
            e.addContent((Content)new Element("resetPreviousStates").addContent("yes"));
        }
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        Element disabled;
        Element bss;
        Element outps;
        Element delay;
        Element unlit;
        MatrixSignalMast m;
        String sys = this.getSystemName(shared);
        try {
            m = (MatrixSignalMast)InstanceManager.getDefault(SignalMastManager.class).provideCustomSignalMast(sys, MatrixSignalMast.class);
        }
        catch (JmriException e) {
            log.error("Failed to load MatrixSignalMast {}: {}", (Object)sys, (Object)e);
            return false;
        }
        if (this.getUserName(shared) != null) {
            m.setUserName(this.getUserName(shared));
        }
        this.loadCommon(m, shared);
        if (shared.getChild("unlit") != null && (unlit = shared.getChild("unlit")).getAttribute("allowed") != null) {
            if (unlit.getAttribute("allowed").getValue().equals("no")) {
                m.setAllowUnLit(false);
            } else {
                m.setAllowUnLit(true);
                String bits = unlit.getChild("bitString").getText();
                m.setUnLitBits(bits);
            }
        }
        if (shared.getChild("delay") != null && (delay = shared.getChild("delay")).getAttribute("duration") != null) {
            m.setMatrixMastCommandDelay(Integer.parseInt(delay.getAttribute("duration").getValue()));
        }
        if ((outps = shared.getChild("outputs")) != null) {
            List list = outps.getChildren("output");
            m.setBitNum(list.size());
            for (Element outp : list) {
                String outputname = outp.getAttribute("matrixCol").getValue();
                String turnoutname = outp.getText();
                m.setOutput(outputname, turnoutname);
            }
        }
        if ((bss = shared.getChild("bitStrings")) != null) {
            List list = bss.getChildren("bitString");
            for (Element bs : list) {
                m.setBitstring(bs.getAttribute("aspect").getValue(), bs.getText());
            }
        }
        if ((disabled = shared.getChild("disabledAspects")) != null) {
            List list = disabled.getChildren("disabledAspect");
            for (Element asp : list) {
                m.setAspectDisabled(asp.getText());
            }
        }
        if (shared.getChild("resetPreviousStates") != null && shared.getChild("resetPreviousStates").getText().equals("yes")) {
            m.resetPreviousStates(true);
        }
        return true;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }
}

